/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.Logging;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.description.DimensionDescriptor;
import mcjty.rftools.dimension.network.PacketGetDimensionEnergy;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class RealizedDimensionTab
extends Item {
    private static long lastTime = 0L;

    public RealizedDimensionTab() {
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af()) {
            RfToolsDimensionManager dimensionManager;
            DimensionInformation information;
            NBTTagCompound tagCompound = stack.func_77978_p();
            Logging.message((EntityPlayer)player, (String)tagCompound.func_74779_i("descriptionString"));
            int id = tagCompound.func_74762_e("id");
            if (id != 0 && (information = (dimensionManager = RfToolsDimensionManager.getDimensionManager(world)).getDimensionInformation(id)) != null) {
                information.dump(player);
            }
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            String name = tagCompound.func_74779_i("name");
            int id = 0;
            if (name != null) {
                id = tagCompound.func_74762_e("id");
                if (id == 0) {
                    list.add(EnumChatFormatting.BLUE + "Name: " + name);
                } else {
                    list.add(EnumChatFormatting.BLUE + "Name: " + name + " (Id " + id + ")");
                }
            }
            String descriptionString = tagCompound.func_74779_i("descriptionString");
            this.constructDescriptionHelp(list, descriptionString);
            Integer ticksLeft = tagCompound.func_74762_e("ticksLeft");
            if (ticksLeft == 0) {
                DimensionInformation information = RfToolsDimensionManager.getDimensionManager(player.func_130014_f_()).getDimensionInformation(id);
                if (information == null) {
                    list.add(EnumChatFormatting.RED + "Dimension information Missing!");
                } else {
                    list.add(EnumChatFormatting.BLUE + "Dimension ready!");
                    int maintainCost = tagCompound.func_74762_e("rfMaintainCost");
                    int actualCost = information.getActualRfCost();
                    if (actualCost == maintainCost || actualCost == 0) {
                        list.add(EnumChatFormatting.YELLOW + "    Maintenance cost: " + maintainCost + " RF/tick");
                    } else {
                        list.add(EnumChatFormatting.YELLOW + "    Maintenance cost: " + actualCost + " RF/tick (Specified: " + maintainCost + " RF/tick)");
                    }
                    if (id != 0) {
                        if (System.currentTimeMillis() - lastTime > 500L) {
                            lastTime = System.currentTimeMillis();
                            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetDimensionEnergy(id));
                        }
                        DimensionStorage storage = DimensionStorage.getDimensionStorage(player.func_130014_f_());
                        int power = storage.getEnergyLevel(id);
                        list.add(EnumChatFormatting.YELLOW + "    Current power: " + power + " RF");
                    }
                }
            } else {
                int createCost = tagCompound.func_74762_e("rfCreateCost");
                int maintainCost = tagCompound.func_74762_e("rfMaintainCost");
                int tickCost = tagCompound.func_74762_e("tickCost");
                int percentage = (tickCost - ticksLeft) * 100 / tickCost;
                list.add(EnumChatFormatting.BLUE + "Dimension progress: " + percentage + "%");
                list.add(EnumChatFormatting.YELLOW + "    Creation cost: " + createCost + " RF/tick");
                list.add(EnumChatFormatting.YELLOW + "    Maintenance cost: " + maintainCost + " RF/tick");
                list.add(EnumChatFormatting.YELLOW + "    Tick cost: " + tickCost + " ticks");
            }
        }
    }

    private void constructDescriptionHelp(List list, String descriptionString) {
        DimletType type;
        HashMap dimletTypeListMap = new HashMap();
        for (DimletKey dimletKey : DimensionDescriptor.parseDescriptionString(descriptionString)) {
            type = dimletKey.getType();
            if (!dimletTypeListMap.containsKey((Object)type)) {
                dimletTypeListMap.put(type, new ArrayList());
            }
            ((List)dimletTypeListMap.get((Object)dimletKey.getType())).add(dimletKey);
        }
        for (Map.Entry entry : dimletTypeListMap.entrySet()) {
            type = (DimletType)((Object)entry.getKey());
            List keys = (List)entry.getValue();
            if (keys == null || keys.isEmpty()) continue;
            if (type == DimletType.DIMLET_DIGIT) {
                String digitString = "";
                for (DimletKey key : keys) {
                    digitString = digitString + DimletObjectMapping.idToDigit.get(key);
                }
                list.add(EnumChatFormatting.GREEN + "Digits " + digitString);
                continue;
            }
            if (keys.size() == 1) {
                list.add(EnumChatFormatting.GREEN + type.dimletType.getName() + " 1 dimlet");
                continue;
            }
            list.add(EnumChatFormatting.GREEN + type.dimletType.getName() + " " + keys.size() + " dimlets");
        }
    }
}

