/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.varia;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import mcjty.rftools.RFTools;
import mcjty.rftools.apideps.DraconicEvolutionCompatibility;
import mcjty.rftools.apideps.EnderIOCompatibility;
import mcjty.rftools.apideps.MekanismCompatibility;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyTools {
    public static boolean isEnergyTE(TileEntity te) {
        return te instanceof IEnergyHandler || te instanceof IEnergyReceiver || te instanceof IEnergyProvider;
    }

    public static EnergyLevelMulti getEnergyLevelMulti(TileEntity tileEntity) {
        long energyStored;
        long maxEnergyStored;
        if (RFTools.instance.enderio && EnderIOCompatibility.isPowerStorage(tileEntity)) {
            maxEnergyStored = EnderIOCompatibility.getMaxEnergyLevel(tileEntity);
            energyStored = EnderIOCompatibility.getEnergyLevel(tileEntity);
        } else if (RFTools.instance.draconicevolution && DraconicEvolutionCompatibility.isPowerStorage(tileEntity)) {
            maxEnergyStored = DraconicEvolutionCompatibility.getMaxEnergyLevel(tileEntity);
            energyStored = DraconicEvolutionCompatibility.getEnergyLevel(tileEntity);
        } else if (RFTools.instance.mekanism && MekanismCompatibility.isPowerStorage(tileEntity)) {
            maxEnergyStored = MekanismCompatibility.getMaxEnergyLevel(tileEntity);
            energyStored = MekanismCompatibility.getEnergyLevel(tileEntity);
        } else if (tileEntity instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)tileEntity;
            maxEnergyStored = handler.getMaxEnergyStored(ForgeDirection.DOWN);
            energyStored = handler.getEnergyStored(ForgeDirection.DOWN);
        } else if (tileEntity instanceof IEnergyReceiver) {
            IEnergyReceiver handler = (IEnergyReceiver)tileEntity;
            maxEnergyStored = handler.getMaxEnergyStored(ForgeDirection.DOWN);
            energyStored = handler.getEnergyStored(ForgeDirection.DOWN);
        } else if (tileEntity instanceof IEnergyProvider) {
            IEnergyProvider handler = (IEnergyProvider)tileEntity;
            maxEnergyStored = handler.getMaxEnergyStored(ForgeDirection.DOWN);
            energyStored = handler.getEnergyStored(ForgeDirection.DOWN);
        } else {
            maxEnergyStored = 0L;
            energyStored = 0L;
        }
        return new EnergyLevelMulti(energyStored, maxEnergyStored);
    }

    public static EnergyLevel getEnergyLevel(TileEntity tileEntity) {
        int energyStored;
        int maxEnergyStored;
        if (tileEntity instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)tileEntity;
            maxEnergyStored = handler.getMaxEnergyStored(ForgeDirection.DOWN);
            energyStored = handler.getEnergyStored(ForgeDirection.DOWN);
        } else if (tileEntity instanceof IEnergyReceiver) {
            IEnergyReceiver handler = (IEnergyReceiver)tileEntity;
            maxEnergyStored = handler.getMaxEnergyStored(ForgeDirection.DOWN);
            energyStored = handler.getEnergyStored(ForgeDirection.DOWN);
        } else if (tileEntity instanceof IEnergyProvider) {
            IEnergyProvider handler = (IEnergyProvider)tileEntity;
            maxEnergyStored = handler.getMaxEnergyStored(ForgeDirection.DOWN);
            energyStored = handler.getEnergyStored(ForgeDirection.DOWN);
        } else {
            maxEnergyStored = 0;
            energyStored = 0;
        }
        return new EnergyLevel(energyStored, maxEnergyStored);
    }

    public static int extractEnergy(TileEntity tileEntity, ForgeDirection from, int maxExtract) {
        if (tileEntity instanceof IEnergyHandler) {
            return ((IEnergyHandler)tileEntity).extractEnergy(from, maxExtract, false);
        }
        if (tileEntity instanceof IEnergyProvider) {
            return ((IEnergyProvider)tileEntity).extractEnergy(from, maxExtract, false);
        }
        return 0;
    }

    public static int receiveEnergy(TileEntity tileEntity, ForgeDirection from, int maxReceive) {
        if (tileEntity instanceof IEnergyHandler) {
            return ((IEnergyHandler)tileEntity).receiveEnergy(from, maxReceive, false);
        }
        if (tileEntity instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)tileEntity).receiveEnergy(from, maxReceive, false);
        }
        return 0;
    }

    public static class EnergyLevelMulti {
        private final long energy;
        private final long maxEnergy;

        public EnergyLevelMulti(long energy, long maxEnergy) {
            this.energy = energy;
            this.maxEnergy = maxEnergy;
        }

        public long getEnergy() {
            return this.energy;
        }

        public long getMaxEnergy() {
            return this.maxEnergy;
        }
    }

    public static class EnergyLevel {
        private final int energy;
        private final int maxEnergy;

        public EnergyLevel(int energy, int maxEnergy) {
            this.energy = energy;
            this.maxEnergy = maxEnergy;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getMaxEnergy() {
            return this.maxEnergy;
        }
    }
}

