/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.multi;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.FileHandler;
import journeymap.client.io.nbt.ChunkLoader;
import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.log.ChatLog;
import journeymap.client.log.LogFormatter;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.task.multi.BaseMapTask;
import journeymap.client.task.multi.ITask;
import journeymap.client.task.multi.ITaskManager;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.apache.logging.log4j.Logger;

public class MapRegionTask
extends BaseMapTask {
    private static final int MAX_RUNTIME = 30000;
    private static final Logger logger = Journeymap.getLogger();
    private static volatile long lastTaskCompleted;
    final RegionCoord rCoord;
    final Collection<ChunkCoordIntPair> retainedCoords;

    private MapRegionTask(ChunkRenderController renderController, World world, MapType mapType, RegionCoord rCoord, Collection<ChunkCoordIntPair> chunkCoords, Collection<ChunkCoordIntPair> retainCoords) {
        super(renderController, world, mapType, chunkCoords, true, false, 5000);
        this.rCoord = rCoord;
        this.retainedCoords = retainCoords;
    }

    public static BaseMapTask create(ChunkRenderController renderController, RegionCoord rCoord, MapType mapType, Minecraft minecraft) {
        boolean missing = false;
        WorldClient world = minecraft.field_71441_e;
        List<ChunkCoordIntPair> renderCoords = rCoord.getChunkCoordsInRegion();
        ArrayList<ChunkCoordIntPair> retainedCoords = new ArrayList<ChunkCoordIntPair>(renderCoords.size());
        HashMap<RegionCoord, Boolean> existingRegions = new HashMap<RegionCoord, Boolean>();
        for (ChunkCoordIntPair coord : renderCoords) {
            for (ChunkCoordIntPair keepAliveOffset : keepAliveOffsets) {
                ChunkCoordIntPair keepAliveCoord = new ChunkCoordIntPair(coord.field_77276_a + keepAliveOffset.field_77276_a, coord.field_77275_b + keepAliveOffset.field_77275_b);
                RegionCoord neighborRCoord = RegionCoord.fromChunkPos(rCoord.worldDir, mapType, keepAliveCoord.field_77276_a, keepAliveCoord.field_77275_b);
                if (!existingRegions.containsKey(neighborRCoord)) {
                    existingRegions.put(neighborRCoord, neighborRCoord.exists());
                }
                if (renderCoords.contains(keepAliveCoord) || !((Boolean)existingRegions.get(neighborRCoord)).booleanValue()) continue;
                retainedCoords.add(keepAliveCoord);
            }
        }
        return new MapRegionTask(renderController, (World)world, mapType, rCoord, renderCoords, retainedCoords);
    }

    @Override
    public final void performTask(Minecraft mc, JourneymapClient jm, File jmWorldDir, boolean threadLogging) throws InterruptedException {
        ChunkMD chunkMD;
        AnvilChunkLoader loader = new AnvilChunkLoader(FileHandler.getWorldSaveDir(mc));
        int missing = 0;
        for (ChunkCoordIntPair coord : this.retainedCoords) {
            chunkMD = ChunkLoader.getChunkMD(loader, mc, coord, true);
            if (chunkMD == null) continue;
            DataCache.instance().addChunkMD(chunkMD);
        }
        for (ChunkCoordIntPair coord : this.chunkCoords) {
            chunkMD = ChunkLoader.getChunkMD(loader, mc, coord, true);
            if (chunkMD != null) {
                DataCache.instance().addChunkMD(chunkMD);
                continue;
            }
            ++missing;
        }
        if (this.chunkCoords.size() - missing > 0) {
            logger.info(String.format("Potential chunks to map in %s: %s (out of %s)", this.rCoord, this.chunkCoords.size() - missing, this.chunkCoords.size()));
            super.performTask(mc, jm, jmWorldDir, threadLogging);
        } else {
            logger.info(String.format("Skipping empty region: %s", this.rCoord));
        }
    }

    @Override
    protected void complete(int mappedChunks, boolean cancelled, boolean hadError) {
        lastTaskCompleted = System.currentTimeMillis();
        RegionImageCache.instance().flushToDisk(false);
        DataCache.instance().invalidateChunkMDCache();
        if (hadError || cancelled) {
            logger.warn("MapRegionTask cancelled %s hadError %s", new Object[]{cancelled, hadError});
        } else {
            logger.info(String.format("Actual chunks mapped in %s: %s ", this.rCoord, mappedChunks));
        }
    }

    @Override
    public int getMaxRuntime() {
        return 30000;
    }

    public static class Manager
    implements ITaskManager {
        final int mapTaskDelay = 0;
        RegionLoader regionLoader;
        boolean enabled;

        @Override
        public Class<? extends ITask> getTaskClass() {
            return MapRegionTask.class;
        }

        @Override
        public boolean enableTask(Minecraft minecraft, Object params) {
            boolean underground;
            EntityDTO player = DataCache.getPlayer();
            boolean cavesAllowed = FeatureManager.isAllowed(Feature.MapCaves);
            boolean worldHasSky = !ForgeHelper.INSTANCE.hasNoSky((Entity)player.entityLivingRef.get());
            boolean bl = underground = ForgeHelper.INSTANCE.hasNoSky((Entity)player.entityLivingRef.get()) || player.underground != false;
            if (underground && !cavesAllowed) {
                if (worldHasSky) {
                    underground = false;
                } else {
                    logger.info("Cave mapping not permitted.");
                    return false;
                }
            }
            boolean bl2 = this.enabled = params != null;
            if (!this.enabled) {
                return false;
            }
            if (System.currentTimeMillis() - lastTaskCompleted < (long)JourneymapClient.getCoreProperties().autoMapPoll.get()) {
                return false;
            }
            this.enabled = false;
            if (minecraft.func_71387_A()) {
                try {
                    long time;
                    MapType mapType = underground ? MapType.underground(player) : ((time = minecraft.field_71441_e.func_72912_H().func_76073_f() % 24000L) < 13800L ? MapType.day(player) : MapType.night(player));
                    Boolean mapAll = params == null ? false : (Boolean)params;
                    this.regionLoader = new RegionLoader(minecraft, mapType, mapAll);
                    if (this.regionLoader.getRegionsFound() == 0) {
                        this.disableTask(minecraft);
                    } else {
                        this.enabled = true;
                    }
                }
                catch (Throwable t) {
                    String error = "Couldn't Auto-Map: " + t.getMessage();
                    ChatLog.announceError(error);
                    logger.error(error + ": " + LogFormatter.toString(t));
                }
            }
            return this.enabled;
        }

        @Override
        public boolean isEnabled(Minecraft minecraft) {
            return this.enabled;
        }

        @Override
        public void disableTask(Minecraft minecraft) {
            if (this.regionLoader != null) {
                if (this.regionLoader.isUnderground()) {
                    ChatLog.announceI18N("jm.common.automap_complete_underground", this.regionLoader.getVSlice());
                } else {
                    ChatLog.announceI18N("jm.common.automap_complete", new Object[0]);
                }
            }
            this.enabled = false;
            if (this.regionLoader != null) {
                RegionImageCache.instance().flushToDisk(false);
                RegionImageCache.instance().clear();
                this.regionLoader.getRegions().clear();
                this.regionLoader = null;
            }
        }

        @Override
        public BaseMapTask getTask(Minecraft minecraft) {
            if (!this.enabled) {
                return null;
            }
            if (this.regionLoader.getRegions().isEmpty()) {
                this.disableTask(minecraft);
                return null;
            }
            RegionCoord rCoord = this.regionLoader.getRegions().peek();
            ChunkRenderController chunkRenderController = JourneymapClient.getInstance().getChunkRenderController();
            BaseMapTask baseMapTask = MapRegionTask.create(chunkRenderController, rCoord, this.regionLoader.getMapType(), minecraft);
            return baseMapTask;
        }

        @Override
        public void taskAccepted(ITask task, boolean accepted) {
            if (accepted) {
                this.regionLoader.getRegions().pop();
                float total = 1.0f * (float)this.regionLoader.getRegionsFound();
                float remaining = total - (float)this.regionLoader.getRegions().size();
                String percent = new DecimalFormat("##.#").format(remaining * 100.0f / total) + "%";
                if (this.regionLoader.isUnderground()) {
                    ChatLog.announceI18N("jm.common.automap_status_underground", this.regionLoader.getVSlice(), percent);
                } else {
                    ChatLog.announceI18N("jm.common.automap_status", percent);
                }
            }
        }
    }
}

