/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.client.properties.PropertiesBase;
import journeymap.client.ui.component.IPropertyHolder;
import journeymap.client.ui.component.OnOffButton;

public class BooleanPropertyButton
extends OnOffButton
implements IPropertyHolder<AtomicBoolean, Boolean> {
    final PropertiesBase properties;
    final AtomicBoolean valueHolder;

    public BooleanPropertyButton(String labelOn, String labelOff, PropertiesBase properties, AtomicBoolean valueHolderParam) {
        super(labelOn, labelOff, valueHolderParam != null && valueHolderParam.get());
        this.valueHolder = valueHolderParam;
        this.properties = properties;
    }

    public AtomicBoolean getValueHolder() {
        return this.valueHolder;
    }

    @Override
    public void toggle() {
        if (this.isEnabled()) {
            if (this.properties != null) {
                this.setToggled(this.properties.toggle(this.valueHolder));
            } else {
                this.setToggled(this.toggled == false);
            }
        }
    }

    @Override
    public void refresh() {
        if (this.valueHolder != null) {
            this.setToggled(this.valueHolder.get());
        }
    }

    @Override
    public Boolean getPropertyValue() {
        return this.valueHolder.get();
    }

    @Override
    public void setPropertyValue(Boolean value) {
        if (this.valueHolder == null) {
            return;
        }
        this.valueHolder.set(value);
        this.properties.save();
    }

    @Override
    public AtomicBoolean getProperty() {
        return this.valueHolder;
    }
}

