/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.PacketSetGuiStyle;
import mcjty.lib.preferences.PlayerPreferencesProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class GuiSideWindow {
    protected GuiStyle style;
    protected Window sideWindow;
    private Button guiButton;
    private Button helpButton;
    private int sideLeft;
    private int sideTop;
    private int manual;
    private String manualNode;

    public GuiSideWindow(int manual, String manualNode) {
        this.manual = manual;
        this.manualNode = manualNode;
    }

    public void initGui(final ModBase modBase, final SimpleNetworkWrapper network, final Minecraft mc, GuiScreen gui, int guiLeft, int guiTop, int xSize, int ySize) {
        this.style = PlayerPreferencesProperties.getProperties((EntityPlayer)mc.field_71439_g).getPreferencesProperties().getStyle();
        this.helpButton = ((Button)((Button)((Button)new Button(mc, (Gui)gui).setText("?")).setLayoutHint(new PositionalLayout.PositionalHint(1, 1, 16, 16))).setTooltips(new String[]{"Open manual"})).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiSideWindow.this.help(modBase, mc);
            }
        });
        this.guiButton = ((Button)((Button)new Button(mc, (Gui)gui).setText("s")).setLayoutHint(new PositionalLayout.PositionalHint(1, 19, 16, 16))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiSideWindow.this.changeStyle(network);
            }
        });
        this.setStyleTooltip();
        Panel sidePanel = (Panel)((Panel)new Panel(mc, (Gui)gui).setLayout(new PositionalLayout()).addChild(this.guiButton)).addChild(this.helpButton);
        this.sideLeft = guiLeft + xSize;
        this.sideTop = guiTop + (ySize - 20) / 2 - 8;
        sidePanel.setBounds(new Rectangle(this.sideLeft, this.sideTop, 20, 40));
        this.sideWindow = new Window(gui, sidePanel);
    }

    private void help(ModBase modBase, Minecraft mc) {
        EntityClientPlayerMP player = mc.field_71439_g;
        modBase.openManual((EntityPlayer)player, this.manual, this.manualNode);
    }

    private void setStyleTooltip() {
        this.guiButton.setTooltips(new String[]{"Gui style:", this.style.getStyle()});
    }

    private void changeStyle(SimpleNetworkWrapper network) {
        int next = this.style.ordinal() + 1;
        if (next >= GuiStyle.values().length) {
            next = 0;
        }
        this.style = GuiStyle.values()[next];
        network.sendToServer((IMessage)new PacketSetGuiStyle(this.style.getStyle()));
        this.setStyleTooltip();
    }

    public Window getWindow() {
        return this.sideWindow;
    }
}

