/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.updatechecker;

import covers1624.powerconverters.util.FMLLogHelper;
import covers1624.powerconverters.util.LogHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.logging.log4j.Level;

public class UpdateCheckThread
extends Thread {
    private String updateURL = "https://raw.github.com/covers1624/PowerConverters/master/UpdateInfo.update";
    private boolean checkComplete = false;
    private boolean newVersionAvalable = false;
    private float newVersion = 0.0f;
    private float currentVersion = 0.0f;

    public UpdateCheckThread() {
        super("PowerConverters Update Thread");
    }

    @Override
    public void run() {
        try {
            URL versionFile = new URL(this.updateURL);
            BufferedReader reader = new BufferedReader(new InputStreamReader(versionFile.openStream()));
            String remoteString = reader.readLine();
            String[] localSplit = "1.7.10-2.11".split("-");
            String[] remoteSplit = remoteString.split("-");
            if (this.compareVersions(localSplit[1], remoteSplit[1])) {
                this.newVersionAvalable = true;
                LogHelper.info("We Have An update");
            } else {
                LogHelper.info("We Have No Update");
            }
            this.checkComplete = true;
        }
        catch (Exception e) {
            FMLLogHelper.logException(Level.INFO, "It Broke!", e);
        }
    }

    private boolean compareVersions(String local, String remote) {
        if (Float.parseFloat(local) > Float.parseFloat(remote)) {
            this.newVersion = Float.parseFloat(remote);
            this.currentVersion = Float.parseFloat(local);
            return true;
        }
        return false;
    }

    public float getNewVersion() {
        return this.newVersion;
    }

    public boolean checkFinished() {
        return this.checkComplete;
    }

    public boolean newVersion() {
        return this.newVersionAvalable;
    }
}

