/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.network.message;

import buildcraft.additionalpipes.gui.GuiJeweledPipe;
import buildcraft.additionalpipes.pipes.PipeItemsJeweled;
import buildcraft.additionalpipes.pipes.SideFilterData;
import buildcraft.additionalpipes.utils.NetworkUtils;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.tileentity.TileEntity;

public class MessageJeweledPipeOptionsClient
implements IMessage,
IMessageHandler<MessageJeweledPipeOptionsClient, IMessage> {
    public int x;
    public int y;
    public int z;
    boolean[] acceptUnsorted;
    boolean[] matchNBT;
    boolean[] matchMeta;

    public MessageJeweledPipeOptionsClient() {
    }

    public MessageJeweledPipeOptionsClient(int x, int y, int z, SideFilterData[] sideFilters) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.acceptUnsorted = new boolean[6];
        this.matchNBT = new boolean[6];
        this.matchMeta = new boolean[6];
        for (int sideNumber = 0; sideNumber < 6; ++sideNumber) {
            this.acceptUnsorted[sideNumber] = sideFilters[sideNumber].acceptsUnsortedItems();
            this.matchNBT[sideNumber] = sideFilters[sideNumber].matchNBT();
            this.matchMeta[sideNumber] = sideFilters[sideNumber].matchMetadata();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.acceptUnsorted = NetworkUtils.readBooleanArray(buf, 6);
        this.matchNBT = NetworkUtils.readBooleanArray(buf, 6);
        this.matchMeta = NetworkUtils.readBooleanArray(buf, 6);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        NetworkUtils.writeBooleanArray(buf, this.acceptUnsorted);
        NetworkUtils.writeBooleanArray(buf, this.matchNBT);
        NetworkUtils.writeBooleanArray(buf, this.matchMeta);
    }

    public IMessage onMessage(MessageJeweledPipeOptionsClient message, MessageContext ctx) {
        TileEntity te = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (te instanceof TileGenericPipe) {
            PipeItemsJeweled pipe = (PipeItemsJeweled)((TileGenericPipe)te).pipe;
            for (int sideNumber = 0; sideNumber < 6; ++sideNumber) {
                pipe.filterData[sideNumber].setAcceptUnsortedItems(message.acceptUnsorted[sideNumber]);
                pipe.filterData[sideNumber].setMatchNBT(message.matchNBT[sideNumber]);
                pipe.filterData[sideNumber].setMatchMetadata(message.matchMeta[sideNumber]);
            }
            GuiScreen currentScreen = FMLClientHandler.instance().getClient().field_71462_r;
            if (currentScreen != null && currentScreen instanceof GuiJeweledPipe) {
                ((GuiJeweledPipe)currentScreen).updateButtonsForTab();
            }
        }
        return null;
    }

    public String toString() {
        return "MessageJeweledPipe";
    }
}

