/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.utils;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.item.ItemPipeAP;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.core.BCCreativeTab;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PipeCreator {
    public static Item createPipeAndRecipe(int output, Class<? extends Pipe<?>> clas, boolean shapeless, Object ... recipe) {
        Item pipe = PipeCreator.createPipe(clas);
        for (Object obj : recipe) {
            if (obj != null) continue;
            return pipe;
        }
        if (shapeless) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(pipe, output), recipe));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(pipe, output), recipe));
        }
        return pipe;
    }

    public static Item createPipe(Class<? extends Pipe<?>> clas) {
        ItemPipe res = BlockGenericPipe.registerPipe(clas, (BCCreativeTab)AdditionalPipes.instance.creativeTab);
        res.func_77655_b(clas.getSimpleName());
        AdditionalPipes.proxy.registerPipeRendering((Item)res);
        return res;
    }

    public static Item createPipeTooltip(Class<? extends APPipe<?>> clas, String tooltip) {
        ItemPipeAP item = new ItemPipeAP(tooltip);
        item.func_77655_b(clas.getSimpleName());
        AdditionalPipes.proxy.registerPipeRendering((Item)item);
        BlockGenericPipe.pipes.put(item, clas);
        GameRegistry.registerItem((Item)item, (String)item.func_77658_a());
        AdditionalPipes.proxy.createPipeSpecial(item, clas);
        return item;
    }
}

