/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ToolRegistry;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.registry.TreeRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import bspkrs.util.CommonUtils;
import bspkrs.util.Coord;
import bspkrs.util.ModulusBlockID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class Treecapitator {
    private World world;
    private EntityPlayer player;
    private Coord startPos;
    private ItemStack axe;
    private ItemStack shears;
    private final TreeDefinition treeDef;
    private final List<BlockID> masterLogList;
    private final BlockID vineID;
    private float currentAxeDamage;
    private float currentShearsDamage = 0.0f;
    private int numLogsToBreak;
    private int numLogsBroken;
    private int numLeavesSheared;
    private float logDamageMultiplier;
    private float leafDamageMultiplier;
    private List<ItemStack> drops;
    private Coord dropPos;
    private boolean maxAllowed = false;

    public Treecapitator(EntityPlayer entityPlayer, TreeDefinition treeDef) {
        this.player = entityPlayer;
        this.treeDef = treeDef;
        this.masterLogList = TreeRegistry.instance().masterLogList();
        this.vineID = new BlockID(Blocks.field_150395_bd);
        this.logDamageMultiplier = TCSettings.damageMultiplier;
        this.leafDamageMultiplier = TCSettings.damageMultiplier;
        this.numLogsToBreak = 0;
        this.numLogsBroken = 1;
        this.numLeavesSheared = 1;
    }

    public static boolean isBreakingPossible(EntityPlayer entityPlayer, Block block, int blockMetadata, boolean shouldLog) {
        ItemStack axe = entityPlayer.func_71045_bC();
        if (Treecapitator.isAxeItemEquipped(entityPlayer, block, blockMetadata) || !TCSettings.needItem) {
            if (!entityPlayer.field_71075_bZ.field_75098_d && TCSettings.allowItemDamage && axe != null && axe.func_77984_f() && (float)(axe.func_77958_k() - axe.func_77960_j()) <= TCSettings.damageMultiplier && !TCSettings.allowMoreBlocksThanDamage) {
                if (shouldLog) {
                    TCLog.debug("Chopping disabled due to axe durability.", new Object[0]);
                }
                return false;
            }
            return true;
        }
        if (shouldLog) {
            TCLog.debug("Player does not have an axe equipped.", new Object[0]);
        }
        return false;
    }

    private boolean isBreakingPossible() {
        this.axe = this.player.func_71045_bC();
        if (this.isAxeItemEquipped() || !TCSettings.needItem) {
            if (!this.player.field_71075_bZ.field_75098_d && TCSettings.allowItemDamage && this.axe != null && this.axe.func_77984_f() && (float)(this.axe.func_77958_k() - this.axe.func_77960_j()) <= TCSettings.damageMultiplier && !TCSettings.allowMoreBlocksThanDamage) {
                TCLog.debug("Chopping disabled due to axe durability.", new Object[0]);
                return false;
            }
            return true;
        }
        TCLog.debug("Player does not have an axe equipped.", new Object[0]);
        return false;
    }

    private boolean isAxeItemEquipped() {
        ItemStack item = this.player.func_71045_bC();
        if (TCSettings.enableEnchantmentMode) {
            if (item != null && item.func_77948_v()) {
                for (int i = 0; i < item.func_77986_q().func_74745_c(); ++i) {
                    NBTTagCompound tag = item.func_77986_q().func_150305_b(i);
                    if (tag.func_74765_d("id") != TCSettings.treecapitating.field_77352_x) continue;
                    this.axe = item;
                    return true;
                }
            }
            this.axe = null;
            return false;
        }
        if (ToolRegistry.instance().isAxe(item)) {
            this.axe = item;
            return true;
        }
        this.axe = null;
        return false;
    }

    public static boolean isAxeItemEquipped(EntityPlayer entityPlayer, Block block, int blockMetadata) {
        ItemStack item = entityPlayer.func_71045_bC();
        if (TCSettings.enableEnchantmentMode) {
            if (item != null && item.func_77948_v()) {
                for (int i = 0; i < item.func_77986_q().func_74745_c(); ++i) {
                    NBTTagCompound tag = item.func_77986_q().func_150305_b(i);
                    if (tag.func_74765_d("id") != TCSettings.treecapitating.field_77352_x) continue;
                    return true;
                }
            }
            return false;
        }
        if (item != null && !ToolRegistry.instance().isAxe(item) && TCSettings.allowAutoAxeDetection) {
            ToolRegistry.autoDetectAxe(item, block, blockMetadata);
        }
        return ToolRegistry.instance().isAxe(item);
    }

    public static boolean isBreakingEnabled(EntityPlayer player) {
        return (TCSettings.sneakAction.equalsIgnoreCase("none") || TCSettings.sneakAction.equalsIgnoreCase("disable") && !player.func_70093_af() || TCSettings.sneakAction.equalsIgnoreCase("enable") && player.func_70093_af()) && (!player.field_71075_bZ.field_75098_d || !TCSettings.disableInCreative);
    }

    public static int getTreeHeight(TreeDefinition tree, World world, int x, int y, int z, int md, EntityPlayer entityPlayer) {
        Coord topLog;
        Coord startPos = new Coord(x, y, z);
        if (!tree.onlyDestroyUpwards()) {
            startPos = tree.useAdvancedTopLogLogic() ? Treecapitator.getBottomLog(tree.getLogList(), world, startPos, false) : Treecapitator.getBottomLogAtPos(tree.getLogList(), world, startPos, false);
        }
        Coord coord = topLog = tree.useAdvancedTopLogLogic() ? Treecapitator.getTopLog(tree.getLogList(), world, new Coord(x, y, z), false) : Treecapitator.getTopLogAtPos(tree.getLogList(), world, new Coord(x, y, z), false);
        if (!tree.allowSmartTreeDetection() || tree.getLeafList().size() == 0 || Treecapitator.hasXLeavesInDist(tree.getLeafList(), world, topLog, tree.maxLeafIDDist(), tree.minLeavesToID(), false)) {
            return topLog.y - startPos.y + 1;
        }
        return 1;
    }

    public void onBlockHarvested(World world, int x, int y, int z, int md) {
        if (!world.field_72995_K) {
            TCLog.debug("In TreeCapitator.onBlockHarvested() " + x + ", " + y + ", " + z, new Object[0]);
            this.world = world;
            this.startPos = new Coord(x, y, z);
            this.dropPos = this.startPos.clone();
            this.drops = new ArrayList<ItemStack>();
            if (Treecapitator.isBreakingEnabled(this.player)) {
                Coord topLog = this.getTopLog(world, new Coord(x, y, z));
                if (!this.treeDef.allowSmartTreeDetection() || this.treeDef.getLeafList().size() == 0 || this.hasXLeavesInDist(world, topLog, this.treeDef.maxLeafIDDist(), this.treeDef.minLeavesToID())) {
                    if (this.isBreakingPossible()) {
                        long beginning = System.currentTimeMillis();
                        TCLog.debug("Proceeding to chop tree...", new Object[0]);
                        LinkedList<Coord> listFinal = new LinkedList<Coord>();
                        TCLog.debug("Finding log blocks...", new Object[0]);
                        long startTime = System.currentTimeMillis();
                        LinkedList<Coord> logs = this.addLogs(world, new Coord(x, y, z));
                        TCLog.debug("Log Discovery: %dms", System.currentTimeMillis() - startTime);
                        if (logs.isEmpty() && this.maxAllowed) {
                            return;
                        }
                        startTime = System.currentTimeMillis();
                        this.addLogsAbove(world, new Coord(x, y, z), listFinal);
                        TCLog.debug("Final Logs: %dms", System.currentTimeMillis() - startTime);
                        TCLog.debug("Destroying %d log blocks...", logs.size());
                        startTime = System.currentTimeMillis();
                        this.destroyBlocks(world, logs);
                        TCLog.debug("Log Destruction: %dms", System.currentTimeMillis() - startTime);
                        if (this.numLogsBroken > 1) {
                            TCLog.debug("Number of logs broken: %d", this.numLogsBroken);
                        }
                        if (TCSettings.destroyLeaves && this.treeDef.getLeafList().size() != 0) {
                            TCLog.debug("Finding leaf blocks...", new Object[0]);
                            ArrayList<Coord> leaves = new ArrayList<Coord>();
                            startTime = System.currentTimeMillis();
                            for (Coord pos : listFinal) {
                                this.addLeaves(world, pos, leaves);
                            }
                            TCLog.debug("Leaf Discovery: %dms", System.currentTimeMillis() - startTime);
                            TCLog.debug("Destroying %d leaf blocks...", leaves.size());
                            startTime = System.currentTimeMillis();
                            this.destroyBlocksWithChance(world, leaves, 0.5f, this.hasShearsInHotbar(this.player));
                            TCLog.debug("Leaf Destruction: %dms", System.currentTimeMillis() - startTime);
                            if (this.numLeavesSheared > 1) {
                                TCLog.debug("Number of leaves sheared: %d", this.numLeavesSheared);
                            }
                        }
                        if (this.currentAxeDamage > 0.0f && this.axe != null) {
                            this.currentAxeDamage = Math.round(this.currentAxeDamage);
                            for (int i = 0; i < MathHelper.func_76128_c((double)this.currentAxeDamage); ++i) {
                                this.axe.func_77973_b().func_150894_a(this.axe, world, this.treeDef.getLogList().get(0).getBlock(), x, y, z, (EntityLivingBase)this.player);
                            }
                        }
                        if (this.currentShearsDamage > 0.0f && this.shears != null) {
                            this.currentShearsDamage = Math.round(this.currentShearsDamage);
                            int i = 0;
                            while ((double)i < Math.floor(this.currentShearsDamage)) {
                                if (this.shears.func_77973_b().equals(Items.field_151097_aZ)) {
                                    this.shears.func_77972_a(1, (EntityLivingBase)this.player);
                                } else {
                                    this.shears.func_77973_b().func_150894_a(this.shears, world, this.treeDef.getLeafList().get(0).getBlock(), x, y, z, (EntityLivingBase)this.player);
                                }
                                ++i;
                            }
                        }
                        startTime = System.currentTimeMillis();
                        if (TCSettings.stackDrops) {
                            while (this.drops.size() > 0) {
                                world.func_72838_d((Entity)new EntityItem(world, (double)this.dropPos.x, (double)this.dropPos.y, (double)this.dropPos.z, this.drops.remove(0)));
                            }
                        }
                        TCLog.debug("Drops: %dms", System.currentTimeMillis() - startTime);
                        TCLog.debug("Total: %dms", System.currentTimeMillis() - beginning);
                    }
                } else {
                    TCLog.debug("Could not identify tree.", new Object[0]);
                }
            } else {
                TCLog.debug("Tree Chopping is disabled due to player state or gamemode.", new Object[0]);
            }
        } else {
            TCLog.debug("World is remote, skipping TreeCapitator.onBlockHarvested().", new Object[0]);
        }
    }

    public static List<BlockID> getLeavesForTree(World world, BlockID logID, Coord pos, boolean shouldLog) {
        ArrayList<BlockID> leaves = new ArrayList();
        ArrayList<BlockID> logs = new ArrayList<BlockID>();
        logs.add(logID);
        Coord topLogPos = TCSettings.useAdvancedTopLogLogic ? Treecapitator.getTopLog(logs, world, pos, shouldLog) : Treecapitator.getTopLogAtPos(logs, world, pos, shouldLog);
        leaves = Treecapitator.getLeavesInDist(world, topLogPos, TCSettings.maxLeafIDDist, shouldLog);
        return leaves;
    }

    private static List<BlockID> getLeavesInDist(World world, Coord pos, int range, boolean shouldLog) {
        if (shouldLog) {
            TCLog.debug("Attempting to identify tree...", new Object[0]);
        }
        ArrayList<BlockID> leaves = new ArrayList<BlockID>();
        for (int x = -range; x <= range; ++x) {
            for (int y = -1; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    if (x == 0 && y == 0 && z == 0 || world.func_147437_c(pos.x + x, pos.y + y, pos.z + z)) continue;
                    Block block = world.func_147439_a(pos.x + x, pos.y + y, pos.z + z);
                    ModulusBlockID blockID = new ModulusBlockID(world, pos.x + x, pos.y + y, pos.z + z, 8);
                    if (block.isLeaves((IBlockAccess)world, pos.x + x, pos.y + y, pos.z + z)) {
                        if (shouldLog) {
                            TCLog.debug("Found leaf block: %s", blockID);
                        }
                        leaves.add((BlockID)blockID);
                        continue;
                    }
                    if (!shouldLog) continue;
                    TCLog.debug("Not a leaf block: %s", blockID);
                }
            }
        }
        if (shouldLog) {
            TCLog.debug("Found %d leaves.", leaves.size());
        }
        return leaves;
    }

    private Coord getTopLog(World world, Coord pos) {
        if (this.treeDef.useAdvancedTopLogLogic()) {
            return Treecapitator.getTopLog(this.treeDef.getLogList(), world, pos, true);
        }
        return Treecapitator.getTopLogAtPos(this.treeDef.getLogList(), world, pos, true);
    }

    private static Coord getTopLog(List<BlockID> logBlocks, World world, Coord pos, boolean shouldLog) {
        LinkedList<Coord> topLogs = new LinkedList<Coord>();
        HashSet<Coord> processed = new HashSet<Coord>();
        Coord topLog = pos.clone();
        topLogs.add(Treecapitator.getTopLogAtPos(logBlocks, world, topLog, false));
        while (topLogs.size() > 0) {
            Coord newPos;
            int z;
            int x;
            Coord nextLog = (Coord)topLogs.pollFirst();
            processed.add(nextLog);
            if (nextLog.y > topLog.y) {
                topLog = nextLog;
            }
            int currentSize = topLogs.size();
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0 || !logBlocks.contains(new BlockID(world, nextLog.x + x, nextLog.y + 1, nextLog.z + z)) || topLogs.contains(newPos = nextLog.add(new Coord(x, 1, z))) || processed.contains(newPos)) continue;
                    topLogs.add(Treecapitator.getTopLogAtPos(logBlocks, world, newPos, false));
                }
            }
            if (topLogs.size() != currentSize) continue;
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0 || !logBlocks.contains(new BlockID(world, nextLog.x + x, nextLog.y, nextLog.z + z)) || topLogs.contains(newPos = nextLog.add(new Coord(x, 0, z))) || processed.contains(newPos)) continue;
                    topLogs.add(Treecapitator.getTopLogAtPos(logBlocks, world, newPos, false));
                }
            }
        }
        if (shouldLog) {
            TCLog.debug("Top Log: " + pos.x + ", " + pos.y + ", " + pos.z, new Object[0]);
        }
        return topLog;
    }

    private static Coord getTopLogAtPos(List<? extends BlockID> logBlocks, World world, Coord pos, boolean shouldLog) {
        while (logBlocks.contains(new BlockID(world, pos.x, pos.y + 1, pos.z))) {
            ++pos.y;
        }
        if (shouldLog) {
            TCLog.debug("Top Log: " + pos.x + ", " + pos.y + ", " + pos.z, new Object[0]);
        }
        return pos.clone();
    }

    private static Coord getBottomLog(List<BlockID> logBlocks, World world, Coord pos, boolean shouldLog) {
        LinkedList<Coord> bottomLogs = new LinkedList<Coord>();
        HashSet<Coord> processed = new HashSet<Coord>();
        Coord bottomLog = pos.clone();
        bottomLogs.add(Treecapitator.getBottomLogAtPos(logBlocks, world, bottomLog, false));
        while (bottomLogs.size() > 0) {
            Coord newPos;
            int z;
            int x;
            Coord nextLog = (Coord)bottomLogs.pollFirst();
            processed.add(nextLog);
            if (nextLog.y < bottomLog.y) {
                bottomLog = nextLog;
            }
            int currentSize = bottomLogs.size();
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0 || !logBlocks.contains(new BlockID(world, nextLog.x + x, nextLog.y - 1, nextLog.z + z)) || bottomLogs.contains(newPos = new Coord(nextLog.x + x, nextLog.y - 1, nextLog.z + z)) || processed.contains(newPos)) continue;
                    bottomLogs.add(Treecapitator.getBottomLogAtPos(logBlocks, world, newPos, false));
                }
            }
            if (bottomLogs.size() != currentSize) continue;
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0 || !logBlocks.contains(new BlockID(world, nextLog.x + x, nextLog.y, nextLog.z + z)) || bottomLogs.contains(newPos = new Coord(nextLog.x + x, nextLog.y, nextLog.z + z)) || processed.contains(newPos)) continue;
                    bottomLogs.add(Treecapitator.getBottomLogAtPos(logBlocks, world, newPos, false));
                }
            }
        }
        if (shouldLog) {
            TCLog.debug("Bottom Log: " + pos.x + ", " + pos.y + ", " + pos.z, new Object[0]);
        }
        return bottomLog;
    }

    private static Coord getBottomLogAtPos(List<BlockID> logBlocks, World world, Coord pos, boolean shouldLog) {
        while (logBlocks.contains(new BlockID(world, pos.x, pos.y - 1, pos.z))) {
            --pos.y;
        }
        if (shouldLog) {
            TCLog.debug("Bottom Log: " + pos.x + ", " + pos.y + ", " + pos.z, new Object[0]);
        }
        return pos;
    }

    private static boolean hasXLeavesInDist(List<BlockID> leafBlocks, World world, Coord pos, int range, int limit, boolean shouldLog) {
        if (shouldLog) {
            TCLog.debug("Attempting to identify tree...", new Object[0]);
        }
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -1; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockID blockID;
                    if (x == 0 && y == 0 && z == 0 || !(blockID = new BlockID(world, pos.x + x, pos.y + y, pos.z + z)).isValid()) continue;
                    if (Treecapitator.isLeafBlock(leafBlocks, blockID)) {
                        if (shouldLog) {
                            TCLog.debug("Found leaf block: %s", blockID);
                        }
                        if (++i < limit) continue;
                        return true;
                    }
                    if (!shouldLog) continue;
                    TCLog.debug("Not a leaf block: %s", blockID);
                }
            }
        }
        if (shouldLog) {
            TCLog.debug("Number of leaf blocks is less than the limit. Found: %s", i);
        }
        return false;
    }

    private boolean hasXLeavesInDist(World world, Coord pos, int range, int limit) {
        return Treecapitator.hasXLeavesInDist(this.treeDef.getLeafList(), world, pos, range, limit, true);
    }

    private boolean hasShearsInHotbar(EntityPlayer entityplayer) {
        return this.shearsHotbarIndex(entityplayer) != -1;
    }

    private int shearsHotbarIndex(EntityPlayer entityPlayer) {
        for (int i = 0; i < 9; ++i) {
            ItemStack item = entityPlayer.field_71071_by.field_70462_a[i];
            if (item == null || item.field_77994_a <= 0 || !ToolRegistry.instance().isShears(item)) continue;
            this.shears = item;
            return i;
        }
        this.shears = null;
        return -1;
    }

    public static boolean isLeafBlock(List<BlockID> leafBlocks, BlockID blockID) {
        return leafBlocks.contains(blockID) || leafBlocks.contains(new BlockID(blockID.id, blockID.metadata & 7));
    }

    public boolean isLeafBlock(BlockID blockID) {
        return Treecapitator.isLeafBlock(this.treeDef.getLeafList(), blockID);
    }

    private void destroyBlocks(World world, LinkedList<Coord> list) {
        this.destroyBlocksWithChance(world, list, 1.0f, false);
    }

    private void destroyBlocksWithChance(World world, List<Coord> list, float f, boolean canShear) {
        while (list.size() > 0) {
            Coord pos = list.remove(0);
            Block block = world.func_147439_a(pos.x, pos.y, pos.z);
            if (block.isAir((IBlockAccess)world, pos.x, pos.y, pos.z)) continue;
            int metadata = world.func_72805_g(pos.x, pos.y, pos.z);
            BlockID blockID = new BlockID(block, metadata);
            if (block instanceof IShearable && (this.vineID.equals((Object)blockID) && TCSettings.shearVines || this.isLeafBlock(blockID) && TCSettings.shearLeaves) && canShear && (!this.player.field_71075_bZ.field_75098_d || !TCSettings.disableCreativeDrops)) {
                IShearable target = (IShearable)block;
                if (target.isShearable(this.shears, (IBlockAccess)world, pos.x, pos.y, pos.z)) {
                    ArrayList drops = target.onSheared(this.shears, (IBlockAccess)this.player.field_70170_p, pos.x, pos.y, pos.z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.shears));
                    if (drops != null) {
                        if (TCSettings.stackDrops) {
                            this.addDrops(drops);
                        } else if (TCSettings.itemsDropInPlace) {
                            for (ItemStack itemStack : drops) {
                                world.func_72838_d((Entity)new EntityItem(world, (double)pos.x, (double)pos.y, (double)pos.z, itemStack));
                            }
                        } else {
                            for (ItemStack itemStack : drops) {
                                world.func_72838_d((Entity)new EntityItem(world, (double)this.startPos.x, (double)this.startPos.y, (double)this.startPos.z, itemStack));
                            }
                        }
                    }
                    if (TCSettings.allowItemDamage && !this.player.field_71075_bZ.field_75098_d && this.shears != null && this.shears.field_77994_a > 0) {
                        canShear = this.damageShearsAndContinue(world, block, pos.x, pos.y, pos.z);
                        ++this.numLeavesSheared;
                        if (canShear && TCSettings.useIncreasingItemDamage && this.numLeavesSheared % TCSettings.increaseDamageEveryXBlocks == 0) {
                            this.leafDamageMultiplier += TCSettings.damageIncreaseAmount;
                        }
                    }
                }
            } else if (!this.player.field_71075_bZ.field_75098_d || !TCSettings.disableCreativeDrops) {
                if (TCSettings.stackDrops) {
                    this.addDrop(block, metadata, pos);
                } else if (TCSettings.itemsDropInPlace) {
                    block.func_149697_b(world, pos.x, pos.y, pos.z, metadata, EnchantmentHelper.func_77517_e((EntityLivingBase)this.player));
                } else {
                    block.func_149697_b(world, this.startPos.x, this.startPos.y, this.startPos.z, metadata, EnchantmentHelper.func_77517_e((EntityLivingBase)this.player));
                }
                if (!(!TCSettings.allowItemDamage || this.player.field_71075_bZ.field_75098_d || this.axe == null || this.axe.field_77994_a <= 0 || this.vineID.equals((Object)new BlockID(block, metadata)) || this.isLeafBlock(new BlockID(block, metadata)) || pos.equals((Object)this.startPos))) {
                    if (!this.damageAxeAndContinue(world, block, this.startPos.x, this.startPos.y, this.startPos.z)) {
                        list.clear();
                    }
                    ++this.numLogsBroken;
                    if (TCSettings.useIncreasingItemDamage && this.numLogsBroken % TCSettings.increaseDamageEveryXBlocks == 0) {
                        this.logDamageMultiplier += TCSettings.damageIncreaseAmount;
                    }
                }
            }
            if (world.func_147438_o(pos.x, pos.y, pos.z) != null) {
                world.func_147475_p(pos.x, pos.y, pos.z);
            }
            world.func_147468_f(pos.x, pos.y, pos.z);
            this.player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
            this.player.func_71020_j(0.025f);
        }
    }

    private void addDrop(Block block, int metadata, Coord pos) {
        ArrayList stacks = null;
        Coord coord = this.dropPos = TCSettings.itemsDropInPlace ? pos.clone() : this.startPos.clone();
        if (block.canSilkHarvest(this.world, this.player, pos.x, pos.y, pos.z, metadata) && EnchantmentHelper.func_77502_d((EntityLivingBase)this.player)) {
            stacks = new ArrayList();
            stacks.add(new ItemStack(block, 1, metadata));
        } else {
            stacks = block.getDrops(this.world, pos.x, pos.y, pos.z, metadata, EnchantmentHelper.func_77517_e((EntityLivingBase)this.player));
        }
        this.addDrops(stacks);
    }

    private void addDrops(List<ItemStack> stacks) {
        if (stacks == null) {
            return;
        }
        for (ItemStack drop : stacks) {
            int i;
            if (drop == null) continue;
            int index = -1;
            for (i = 0; i < this.drops.size(); ++i) {
                if (!this.drops.get(i).func_77969_a(drop)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                this.drops.add(drop);
                index = this.drops.indexOf(drop);
            } else {
                int quantity = drop.field_77994_a;
                drop = this.drops.get(index);
                drop.field_77994_a += quantity;
            }
            if (drop.field_77994_a < drop.func_77976_d()) continue;
            i = drop.field_77994_a - drop.func_77976_d();
            drop.field_77994_a = drop.func_77976_d();
            this.world.func_72838_d((Entity)new EntityItem(this.world, (double)this.dropPos.x, (double)this.dropPos.y, (double)this.dropPos.z, drop));
            if (i > 0) {
                drop.field_77994_a = i;
                continue;
            }
            this.drops.remove(index);
        }
    }

    private boolean damageAxeAndContinue(World world, Block block, int x, int y, int z) {
        if (this.axe != null) {
            this.currentAxeDamage += this.logDamageMultiplier;
            for (int i = 0; i < (int)Math.floor(this.currentAxeDamage); ++i) {
                this.axe.func_77973_b().func_150894_a(this.axe, world, block, x, y, z, (EntityLivingBase)this.player);
            }
            this.currentAxeDamage = (float)((double)this.currentAxeDamage - Math.floor(this.currentAxeDamage));
            if (this.axe != null && this.axe.field_77994_a < 1) {
                this.player.func_71028_bD();
            }
        }
        return !TCSettings.needItem || TCSettings.allowMoreBlocksThanDamage || this.isAxeItemEquipped();
    }

    private boolean damageShearsAndContinue(World world, Block block, int x, int y, int z) {
        if (this.shears != null) {
            int shearsIndex = this.shearsHotbarIndex(this.player);
            this.currentShearsDamage += this.leafDamageMultiplier;
            int i = 0;
            while ((double)i < Math.floor(this.currentShearsDamage)) {
                if (this.shears.func_77973_b().equals(Items.field_151097_aZ)) {
                    this.shears.func_77972_a(1, (EntityLivingBase)this.player);
                } else {
                    this.shears.func_77973_b().func_150894_a(this.shears, world, block, x, y, z, (EntityLivingBase)this.player);
                }
                ++i;
            }
            this.currentShearsDamage = (float)((double)this.currentShearsDamage - Math.floor(this.currentShearsDamage));
            if (this.shears != null && this.shears.field_77994_a < 1 && shearsIndex != -1) {
                this.player.field_71071_by.func_70299_a(shearsIndex, (ItemStack)null);
            }
        }
        return TCSettings.allowMoreBlocksThanDamage || this.hasShearsInHotbar(this.player);
    }

    private LinkedList<Coord> addLogs(World world, Coord pos) {
        int index = 0;
        int lowY = pos.y;
        LinkedList<Coord> list = new LinkedList<Coord>();
        list.add(pos);
        do {
            Coord currentLog = (Coord)list.get(index);
            for (int x = -1; x <= 1; ++x) {
                int y;
                int n = y = this.treeDef.onlyDestroyUpwards() ? 0 : -1;
                while (y <= 1) {
                    for (int z = -1; z <= 1; ++z) {
                        if (world.func_147437_c(currentLog.x + x, currentLog.y + y, currentLog.z + z) || !this.treeDef.getLogList().contains(new BlockID(world, currentLog.x + x, currentLog.y + y, currentLog.z + z))) continue;
                        Coord newPos = new Coord(currentLog.x + x, currentLog.y + y, currentLog.z + z);
                        if (this.treeDef.maxHorLogBreakDist() != -1 && (Math.abs(newPos.x - this.startPos.x) > this.treeDef.maxHorLogBreakDist() || Math.abs(newPos.z - this.startPos.z) > this.treeDef.maxHorLogBreakDist() || this.treeDef.maxVerLogBreakDist() != -1 && Math.abs(newPos.y - this.startPos.y) > this.treeDef.maxVerLogBreakDist() || list.contains(newPos) || newPos.y < lowY && this.treeDef.onlyDestroyUpwards())) continue;
                        list.add(newPos);
                        if (TCSettings.maxNumberOfBlocksInTree == -1 || ++this.numLogsToBreak <= TCSettings.maxNumberOfBlocksInTree) continue;
                        list.clear();
                        TCLog.debug("Number of logs in tree is more than the maximum number allowed.", new Object[0]);
                        this.maxAllowed = true;
                        return list;
                    }
                    ++y;
                }
            }
        } while (++index < list.size());
        if (list.contains(pos)) {
            list.remove(pos);
        }
        return list;
    }

    private void addLogsAbove(World world, Coord position, List<Coord> listFinal) {
        ArrayList<Coord> listAbove = new ArrayList<Coord>();
        listAbove.add(position);
        do {
            Coord newPosition;
            int z;
            int x;
            ArrayList<Coord> list = listAbove;
            listAbove = new ArrayList();
            for (Coord pos : list) {
                int counter = 0;
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (!this.treeDef.getLogList().contains(new BlockID(world, pos.x + x, pos.y + 1, pos.z + z))) continue;
                        newPosition = new Coord(pos.x + x, pos.y + 1, pos.z + z);
                        if (!listAbove.contains(newPosition)) {
                            listAbove.add(newPosition);
                        }
                        ++counter;
                    }
                }
                if (counter != 0) continue;
                listFinal.add(pos);
            }
            int index = -1;
            while (++index < listAbove.size()) {
                Coord pos = (Coord)listAbove.get(index);
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (!this.treeDef.getLogList().contains(new BlockID(world, pos.x + x, pos.y, pos.z + z)) || listAbove.contains(newPosition = new Coord(pos.x + x, pos.y, pos.z + z))) continue;
                        listAbove.add(newPosition);
                    }
                }
            }
        } while (listAbove.size() > 0);
    }

    public List<Coord> addLeaves(World world, Coord pos, List<Coord> list) {
        int index = -1;
        if (list == null) {
            list = new ArrayList<Coord>();
        }
        this.addLeavesInDistance(world, pos, this.treeDef.maxHorLeafBreakDist(), list);
        while (++index < list.size()) {
            Coord pos2 = list.get(index);
            if (this.treeDef.maxHorLeafBreakDist() != -1 && CommonUtils.getHorSquaredDistance((Coord)pos, (Coord)pos2) > this.treeDef.maxHorLeafBreakDist()) continue;
            this.addLeavesInDistance(world, pos2, 1, list);
        }
        return list;
    }

    public void addLeavesInDistance(World world, Coord pos, int range, List<Coord> list) {
        if (range == -1) {
            range = 4;
        }
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    Coord newPos;
                    int md;
                    Block block = world.func_147439_a(x + pos.x, y + pos.y, z + pos.z);
                    if (!this.isLeafBlock(new BlockID(block, md = world.func_72805_g(x + pos.x, y + pos.y, z + pos.z))) && !this.vineID.equals((Object)new BlockID(block)) || this.treeDef.requireLeafDecayCheck() && ((md & 8) == 0 || (md & 4) != 0) || list.contains(newPos = new Coord(x + pos.x, y + pos.y, z + pos.z)) || this.hasLogClose(world, newPos, 1)) continue;
                    list.add(newPos);
                }
            }
        }
    }

    public boolean hasLogClose(World world, Coord pos, int i) {
        for (int x = -i; x <= i; ++x) {
            for (int y = -i; y <= i; ++y) {
                for (int z = -i; z <= i; ++z) {
                    Coord neighborPos = new Coord(x + pos.x, y + pos.y, z + pos.z);
                    if (x == 0 && y == 0 && z == 0 || neighborPos.isAirBlock(world) || !this.treeDef.getLogList().contains(new BlockID(world, neighborPos.x, neighborPos.y, neighborPos.z)) || neighborPos.equals((Object)this.startPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

