/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.grid;

import covers1624.powerconverters.grid.IGrid;
import covers1624.powerconverters.grid.IGridController;
import covers1624.powerconverters.grid.INode;
import covers1624.powerconverters.tile.main.EnergyNetwork;
import covers1624.powerconverters.tile.main.TileEnergyConduit;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.LinkedHashSet;

public class GridTickHandler<G extends IGrid, N extends INode>
implements IGridController {
    public static final GridTickHandler<EnergyNetwork, TileEnergyConduit> energy = new GridTickHandler("Energy");
    private LinkedHashSet<G> tickingGridsToRegenerate = new LinkedHashSet();
    private LinkedHashSet<G> tickingGridsToAdd = new LinkedHashSet();
    private LinkedHashSet<G> tickingGrids = new LinkedHashSet();
    private LinkedHashSet<G> tickingGridsToRemove = new LinkedHashSet();
    private LinkedHashSet<N> conduit = new LinkedHashSet();
    private LinkedHashSet<N> conduitToAdd = new LinkedHashSet();
    private LinkedHashSet<N> conduitToUpd = new LinkedHashSet();
    private final String label;

    public GridTickHandler(String name) {
        name.hashCode();
        this.label = "GridTickHandler[" + name + "]";
    }

    public void addGrid(G grid) {
        this.tickingGridsToAdd.add(grid);
        this.tickingGridsToRemove.remove(grid);
    }

    public void removeGrid(G grid) {
        this.tickingGridsToRemove.add(grid);
        this.tickingGridsToAdd.remove(grid);
    }

    public void regenerateGrid(G grid) {
        this.tickingGridsToRegenerate.add(grid);
    }

    public boolean isGridTicking(G grid) {
        return this.tickingGrids.contains(grid);
    }

    public void addConduitForTick(N node) {
        this.conduitToAdd.add(node);
    }

    public void addConduitForUpdate(N node) {
        this.conduitToUpd.add(node);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        } else {
            this.tickEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickStart() {
        LinkedHashSet<Object> linkedHashSet;
        if (!this.tickingGridsToRegenerate.isEmpty()) {
            linkedHashSet = this.tickingGridsToRegenerate;
            synchronized (linkedHashSet) {
                for (IGrid grid : this.tickingGridsToRegenerate) {
                    grid.markSweep();
                }
                this.tickingGridsToRegenerate.clear();
            }
        }
        if (!this.conduitToUpd.isEmpty()) {
            linkedHashSet = this.conduitToUpd;
            synchronized (linkedHashSet) {
                this.conduit.addAll(this.conduitToUpd);
                this.conduitToUpd.clear();
            }
        }
        if (!this.conduit.isEmpty()) {
            INode cond2 = null;
            try {
                for (INode cond2 : this.conduit) {
                    if (cond2.isNotValid()) continue;
                    cond2.updateInternalTypes(this);
                }
                this.conduit.clear();
            }
            catch (Throwable _) {
                throw new RuntimeException("Crashing on conduit " + cond2, _);
            }
        }
        if (!this.tickingGrids.isEmpty()) {
            for (IGrid grid : this.tickingGrids) {
                grid.doGridPreUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickEnd() {
        LinkedHashSet<G> linkedHashSet;
        if (!this.tickingGridsToRemove.isEmpty()) {
            linkedHashSet = this.tickingGridsToRemove;
            synchronized (linkedHashSet) {
                this.tickingGrids.removeAll(this.tickingGridsToRemove);
                this.tickingGridsToRemove.clear();
            }
        }
        if (!this.tickingGridsToAdd.isEmpty()) {
            linkedHashSet = this.tickingGridsToAdd;
            synchronized (linkedHashSet) {
                this.tickingGrids.addAll(this.tickingGridsToAdd);
                this.tickingGridsToAdd.clear();
            }
        }
        if (!this.tickingGrids.isEmpty()) {
            for (IGrid grid : this.tickingGrids) {
                grid.doGridUpdate();
            }
        }
        if (!this.conduitToAdd.isEmpty()) {
            LinkedHashSet<N> i$ = this.conduitToAdd;
            synchronized (i$) {
                this.conduit.addAll(this.conduitToAdd);
                this.conduitToAdd.clear();
            }
        }
        if (!this.conduit.isEmpty()) {
            INode cond2 = null;
            try {
                for (INode cond2 : this.conduit) {
                    if (cond2.isNotValid()) continue;
                    cond2.firstTick(this);
                }
                this.conduit.clear();
            }
            catch (Throwable _) {
                throw new RuntimeException("Crashing on conduit " + cond2, _);
            }
        }
    }

    public String toString() {
        return this.label + "@" + this.hashCode();
    }
}

