/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.ic2;

import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.init.PowerSystems;
import covers1624.powerconverters.tile.main.TileEntityEnergyConsumer;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityIndustrialCraftConsumer
extends TileEntityEnergyConsumer<IEnergyEmitter>
implements IEnergySink {
    private boolean _isAddedToEnergyNet;
    private boolean _didFirstAddToNet;
    private double _euLastTick;
    private long _lastTickInjected;

    public TileEntityIndustrialCraftConsumer() {
        this(0);
    }

    public TileEntityIndustrialCraftConsumer(int voltageIndex) {
        super(PowerSystems.powerSystemIndustrialCraft, voltageIndex, IEnergyEmitter.class);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this._didFirstAddToNet && !this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this._didFirstAddToNet = true;
            this._isAddedToEnergyNet = true;
        }
        if (this.field_145850_b.func_72820_D() - this._lastTickInjected > 2L) {
            this._euLastTick = 0.0;
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this._isAddedToEnergyNet) {
            this._didFirstAddToNet = false;
        }
    }

    public void func_145843_s() {
        if (this._isAddedToEnergyNet) {
            if (!this.field_145850_b.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this._isAddedToEnergyNet = false;
        }
        super.func_145843_s();
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !ConfigurationHandler.dissableIC2Consumer;
    }

    public double getDemandedEnergy() {
        return this.getTotalEnergyDemand() / (double)PowerSystems.powerSystemIndustrialCraft.getScaleAmmount();
    }

    public double injectEnergy(ForgeDirection directionFrom, double realAmount, double voltage) {
        double amount = (int)Math.floor(realAmount);
        if (amount > (double)this.getSinkTier()) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            block.func_149697_b(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 0);
            return amount;
        }
        double pcuNotStored = this.storeEnergy(amount * (double)PowerSystems.powerSystemIndustrialCraft.getScaleAmmount(), false);
        double euNotStored = pcuNotStored / (double)PowerSystems.powerSystemIndustrialCraft.getScaleAmmount();
        double euThisInjection = amount - euNotStored;
        if (this._lastTickInjected == this.field_145850_b.func_72820_D()) {
            this._euLastTick += euThisInjection;
        } else {
            this._euLastTick = euThisInjection;
            this._lastTickInjected = this.field_145850_b.func_72820_D();
        }
        return euNotStored;
    }

    public int getSinkTier() {
        if (this.getVoltageIndex() == 3) {
            return Integer.MAX_VALUE;
        }
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }

    @Override
    public double getInputRate() {
        return this._euLastTick;
    }
}

