/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.main;

import cofh.api.energy.EnergyStorage;
import covers1624.powerconverters.grid.GridTickHandler;
import covers1624.powerconverters.grid.IGrid;
import covers1624.powerconverters.tile.main.TileEnergyConduit;
import covers1624.powerconverters.util.BlockPosition;
import covers1624.repack.cofh.lib.util.ArrayHashList;
import covers1624.repack.cofh.lib.util.LinkedHashList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyNetwork
implements IGrid {
    public static final int TRANSFER_RATE = 1000;
    public static final int STORAGE = 6000;
    static final GridTickHandler<EnergyNetwork, TileEnergyConduit> HANDLER = GridTickHandler.energy;
    private ArrayHashList<TileEnergyConduit> nodeSet = new ArrayHashList();
    LinkedHashList<TileEnergyConduit> conduitSet;
    private TileEnergyConduit master;
    private int overflowSelector;
    private boolean regenerating = false;
    EnergyStorage storage = new EnergyStorage(480, 80);
    public int distribution;
    public int distributionSide;

    protected EnergyNetwork() {
        this.storage.setCapacity(6000);
        this.storage.setMaxTransfer(1000);
    }

    public EnergyNetwork(TileEnergyConduit base) {
        this.storage.setCapacity(6000);
        this.storage.setMaxTransfer(1000);
        this.conduitSet = new LinkedHashList();
        this.regenerating = true;
        this.addConduit(base);
        this.regenerating = false;
    }

    public int getNodeShare(TileEnergyConduit conduit) {
        int size = this.nodeSet.size();
        if (size <= 1) {
            return this.storage.getEnergyStored();
        }
        int amt = 0;
        if (this.master == conduit) {
            amt = this.storage.getEnergyStored() % size;
        }
        return amt + this.storage.getEnergyStored() / size;
    }

    public void addConduit(TileEnergyConduit conduit) {
        if (this.conduitSet.add(conduit)) {
            if (!this.conduitAdded(conduit)) {
                return;
            }
            if (conduit.isNode) {
                if (this.nodeSet.add(conduit)) {
                    this.nodeAdded(conduit);
                }
            } else if (!this.nodeSet.isEmpty()) {
                int share = this.getNodeShare(conduit);
                if (this.nodeSet.remove(conduit)) {
                    conduit.energyForGrid = this.storage.extractEnergy(share, false);
                    this.nodeRemoved(conduit);
                }
            }
        }
    }

    public void removeConduit(TileEnergyConduit conduit) {
        this.conduitSet.remove(conduit);
        if (!this.nodeSet.isEmpty()) {
            int share = this.getNodeShare(conduit);
            if (this.nodeSet.remove(conduit)) {
                conduit.energyForGrid = this.storage.extractEnergy(share, false);
                this.nodeRemoved(conduit);
            }
        }
    }

    public void regenerate() {
        this.regenerating = true;
        HANDLER.regenerateGrid(this);
    }

    public boolean isRegenerating() {
        return this.regenerating;
    }

    @Override
    public void doGridPreUpdate() {
        if (this.regenerating) {
            return;
        }
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
            return;
        }
        EnergyStorage tempStorage = this.storage;
        if (tempStorage.getEnergyStored() >= tempStorage.getMaxEnergyStored()) {
            return;
        }
        ForgeDirection[] directions = ForgeDirection.VALID_DIRECTIONS;
        for (TileEnergyConduit conduit : this.nodeSet) {
            int i = 6;
            while (i-- > 0) {
                conduit.extract(directions[i], tempStorage);
            }
        }
    }

    @Override
    public void doGridUpdate() {
        if (this.regenerating) {
            return;
        }
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
            return;
        }
        EnergyStorage storage = this.storage;
        if (storage.getEnergyStored() <= 0) {
            return;
        }
        ForgeDirection[] directions = ForgeDirection.VALID_DIRECTIONS;
        int size = this.nodeSet.size();
        int toDistribute = storage.getEnergyStored() / size;
        int sideDistribute = toDistribute / 6;
        this.distribution = toDistribute;
        this.distributionSide = sideDistribute;
        int overflow = this.overflowSelector = (this.overflowSelector + 1) % size;
        TileEnergyConduit master = this.nodeSet.get(overflow);
        if (sideDistribute > 0) {
            for (TileEnergyConduit cond : this.nodeSet) {
                if (cond == master) continue;
                int e = 0;
                int i = 6;
                while (i-- > 0) {
                    e += cond.transfer(directions[i], sideDistribute);
                }
                if (e <= 0) continue;
                storage.modifyEnergyStored(-e);
            }
        }
        if ((sideDistribute = (toDistribute += storage.getEnergyStored() % size) / 6) > 0) {
            int e = 0;
            int i = 6;
            while (i-- > 0) {
                e += master.transfer(directions[i], sideDistribute);
            }
            if (e > 0) {
                storage.modifyEnergyStored(-e);
            }
        } else if (toDistribute > 0) {
            int e;
            int i = 6;
            for (e = 0; i-- > 0 && e < toDistribute; e += master.transfer(directions[i], toDistribute - e)) {
            }
            if (e > 0) {
                storage.modifyEnergyStored(-e);
            }
        }
    }

    @Override
    public void markSweep() {
        this.destroyGrid();
        if (this.conduitSet.isEmpty()) {
            return;
        }
        TileEnergyConduit main = this.conduitSet.poke();
        LinkedHashList<TileEnergyConduit> oldSet = this.conduitSet;
        this.nodeSet.clear();
        this.conduitSet = new LinkedHashList(Math.min(oldSet.size() / 6, 5));
        LinkedHashList<TileEnergyConduit> toCheck = new LinkedHashList<TileEnergyConduit>();
        LinkedHashList<TileEnergyConduit> checked = new LinkedHashList<TileEnergyConduit>();
        BlockPosition bp = new BlockPosition(0, 0, 0);
        ForgeDirection[] dir = ForgeDirection.VALID_DIRECTIONS;
        toCheck.add(main);
        checked.add(main);
        while (!toCheck.isEmpty()) {
            main = (TileEnergyConduit)toCheck.shift();
            this.addConduit(main);
            World world = main.func_145831_w();
            int i = 6;
            while (i-- > 0) {
                TileEnergyConduit teConduit;
                TileEntity te;
                bp.x = main.field_145851_c;
                bp.y = main.field_145848_d;
                bp.z = main.field_145849_e;
                bp.step(dir[i]);
                if (!world.func_72899_e(bp.x, bp.y, bp.z) || !((te = bp.getTileEntity(world)) instanceof TileEnergyConduit) || !main.canInterface(teConduit = (TileEnergyConduit)te, dir[i ^ 1]) || !checked.add(teConduit)) continue;
                toCheck.add(teConduit);
            }
            oldSet.remove(main);
        }
        if (!oldSet.isEmpty()) {
            EnergyNetwork newGrid = new EnergyNetwork();
            newGrid.conduitSet = oldSet;
            newGrid.regenerating = true;
            newGrid.markSweep();
        }
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
        } else {
            HANDLER.addGrid(this);
        }
        this.rebalanceGrid();
        this.regenerating = false;
    }

    public void destroyGrid() {
        this.master = null;
        this.regenerating = true;
        for (TileEnergyConduit currentConduit : this.nodeSet) {
            this.destroyNode(currentConduit);
        }
        for (TileEnergyConduit currentConduit : this.conduitSet) {
            this.destroyConduit(currentConduit);
        }
        HANDLER.removeGrid(this);
    }

    public void destroyNode(TileEnergyConduit conduit) {
        conduit.energyForGrid = this.getNodeShare(conduit);
        conduit.grid = null;
    }

    public void destroyConduit(TileEnergyConduit conduit) {
        conduit.grid = null;
    }

    public boolean canMergeGrid(EnergyNetwork otherGrid) {
        return otherGrid != null;
    }

    public void mergeGrid(EnergyNetwork grid) {
        if (grid == this) {
            return;
        }
        boolean r = this.regenerating || grid.regenerating;
        grid.destroyGrid();
        if (!this.regenerating & r) {
            this.regenerate();
        }
        this.regenerating = true;
        for (TileEnergyConduit conduit : grid.conduitSet) {
            this.addConduit(conduit);
        }
        this.regenerating = r;
        grid.conduitSet.clear();
        grid.nodeSet.clear();
    }

    public void nodeAdded(TileEnergyConduit conduit) {
        if (this.master == null) {
            this.master = conduit;
            HANDLER.addGrid(this);
        }
        this.rebalanceGrid();
        this.storage.modifyEnergyStored(conduit.energyForGrid);
    }

    public void nodeRemoved(TileEnergyConduit conduit) {
        this.rebalanceGrid();
        if (conduit == this.master) {
            if (this.nodeSet.isEmpty()) {
                this.master = null;
                HANDLER.removeGrid(this);
            } else {
                this.master = this.nodeSet.get(0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean conduitAdded(TileEnergyConduit conduit) {
        if (conduit.grid != null) {
            if (conduit.grid == this) return false;
            this.conduitSet.remove(conduit);
            if (!this.canMergeGrid(conduit.grid)) return false;
            this.mergeGrid(conduit.grid);
            return true;
        } else {
            conduit.setGrid(this);
        }
        return true;
    }

    public void rebalanceGrid() {
        this.storage.setCapacity(this.nodeSet.size() * 6000);
    }

    public int getConduitCount() {
        return this.conduitSet.size();
    }

    public int getNodeCount() {
        return this.nodeSet.size();
    }
}

