/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.main;

import covers1624.powerconverters.api.charge.IChargeHandler;
import covers1624.powerconverters.api.registry.UniversalChargerRegistry;
import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.init.PowerSystems;
import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import covers1624.powerconverters.util.BlockPosition;
import covers1624.powerconverters.util.IAdvancedLogTile;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCharger
extends TileEntityEnergyProducer<IInventory>
implements IAdvancedLogTile,
ISidedInventory {
    private TileEntity[] sideCache = new TileEntity[6];
    private ItemStack[] slots = new ItemStack[32];

    public TileEntityCharger() {
        super(PowerSystems.powerSystemRedstoneFlux, 0, IInventory.class);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.searchForTiles();
        this.validateSlots();
    }

    @Override
    public double produceEnergy(double energy) {
        if (energy == 0.0) {
            return 0.0;
        }
        if (ConfigurationHandler.dissableUniversalCharger) {
            return energy;
        }
        double energyRemaining = energy;
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null) continue;
            for (IChargeHandler handler : UniversalChargerRegistry.getChargeHandlers()) {
                if (!handler.canHandle(stack) || (energyRemaining = handler.charge(stack, energyRemaining)) != 0.0) continue;
                return 0.0;
            }
        }
        energyRemaining = this.powerTiles(energyRemaining);
        return energyRemaining;
    }

    private void searchForTiles() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = BlockPosition.getAdjacentTileEntity(this, dir);
            if (tileEntity != null && tileEntity instanceof IInventory) {
                this.sideCache[dir.ordinal()] = tileEntity;
            }
            if (tileEntity != null) continue;
            this.sideCache[dir.ordinal()] = null;
        }
    }

    private void validateSlots() {
        for (int i = 0; i < 16; ++i) {
            if (this.slots[i] == null) continue;
            block1: for (IChargeHandler handler : UniversalChargerRegistry.getChargeHandlers()) {
                if (!handler.canHandle(this.slots[i]) || !handler.isItemCharged(this.slots[i])) continue;
                for (int j = 16; j < 32; ++j) {
                    if (this.slots[j] != null) continue;
                    this.slots[j] = this.slots[i];
                    this.slots[i] = null;
                    continue block1;
                }
            }
        }
    }

    public double powerTiles(double energyRemaining) {
        for (TileEntity tileEntity : this.sideCache) {
            if (tileEntity == null) continue;
            IInventory iInventory = (IInventory)tileEntity;
            for (int i = 0; i < iInventory.func_70302_i_(); ++i) {
                ItemStack itemStack = iInventory.func_70301_a(i);
                if (itemStack == null) continue;
                for (IChargeHandler handler : UniversalChargerRegistry.getChargeHandlers()) {
                    if (!handler.canHandle(itemStack) || (energyRemaining = handler.charge(itemStack, energyRemaining)) != 0.0) continue;
                    return 0.0;
                }
            }
        }
        return energyRemaining;
    }

    @Override
    public void getTileInfo(List<IChatComponent> info, ForgeDirection side, EntityPlayer player, boolean debug) {
        info.add((IChatComponent)this.text("-SideCache-"));
        for (int i = 0; i < this.sideCache.length; ++i) {
            String data = this.sideCache[i] != null ? this.sideCache[i].getClass().getName() : "Null";
            info.add((IChatComponent)this.text(String.format("Side: %s, Data: %s", ForgeDirection.VALID_DIRECTIONS[i], data)));
        }
    }

    private ChatComponentText text(String string) {
        return new ChatComponentText(string);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74768_a("Slot", i);
            this.slots[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        tagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList nbttaglist = tagCompound.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74762_e("Slot");
            if (j < 0 || j >= this.slots.length) continue;
            this.slots[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.slots[slot];
    }

    public ItemStack func_70298_a(int slot, int ammount) {
        if (this.slots[slot] != null) {
            if (this.slots[slot].field_77994_a <= ammount) {
                ItemStack itemStack = this.slots[slot];
                this.slots[slot] = null;
                return itemStack;
            }
            ItemStack itemStack = this.slots[slot].func_77979_a(ammount);
            if (this.slots[slot].field_77994_a == 0) {
                this.slots[slot] = null;
            }
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return this.slots[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Universal Charger";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < 16) {
            for (IChargeHandler chargeHandler : UniversalChargerRegistry.getChargeHandlers()) {
                if (!chargeHandler.canHandle(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot > 16;
    }
}

