/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.main;

import covers1624.powerconverters.api.bridge.BridgeSideData;
import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.net.EnergyBridgeSyncPacket;
import covers1624.powerconverters.tile.main.TileEntityBridgeComponent;
import covers1624.powerconverters.tile.main.TileEntityEnergyConsumer;
import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import covers1624.powerconverters.util.BlockPosition;
import covers1624.powerconverters.util.INeighboorUpdateTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergyBridge
extends TileEntity
implements INeighboorUpdateTile {
    private double _energyStored;
    private double _energyStoredMax = ConfigurationHandler.bridgeBufferSize;
    private double _energyScaledClient;
    private double _energyStoredLast;
    private boolean _isInputLimited;
    private Map<ForgeDirection, TileEntityEnergyProducer<?>> _producerTiles = new HashMap();
    private Map<ForgeDirection, BridgeSideData> clientSideData = new HashMap<ForgeDirection, BridgeSideData>();
    private Map<ForgeDirection, Double> _producerOutputRates = new HashMap<ForgeDirection, Double>();
    private boolean _initialized;

    public TileEntityEnergyBridge() {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this.clientSideData.put(d, new BridgeSideData());
            this._producerOutputRates.put(d, 0.0);
        }
    }

    public double getEnergyStored() {
        return this._energyStored;
    }

    public double getEnergyStoredMax() {
        return this._energyStoredMax;
    }

    public double storeEnergy(double energy, boolean simulate) {
        double toStore = Math.min(energy, this._energyStoredMax - this._energyStored);
        if (simulate) {
            return energy - toStore;
        }
        this._energyStored += toStore;
        return energy - toStore;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this._initialized) {
            this.onNeighboorChanged();
            this._initialized = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            double energyRemaining = Math.min(this._energyStored, this._energyStoredMax);
            double energyNotProduced = 0.0;
            for (Map.Entry<ForgeDirection, TileEntityEnergyProducer<?>> prod : this._producerTiles.entrySet()) {
                if (prod.getValue().isGettingRedstone()) continue;
                if (energyRemaining > 0.0) {
                    energyNotProduced = prod.getValue().produceEnergy(energyRemaining);
                    if (energyNotProduced > energyRemaining) {
                        energyNotProduced = energyRemaining;
                    }
                    this._producerOutputRates.put(prod.getKey(), (energyRemaining - energyNotProduced) / (double)prod.getValue().getPowerSystem().getScaleAmmount());
                    energyRemaining = energyNotProduced;
                    continue;
                }
                prod.getValue().produceEnergy(0.0);
                this._producerOutputRates.put(prod.getKey(), 0.0);
            }
            this._energyStored = Math.max(0.0, energyRemaining);
            this._isInputLimited = !(this._energyStored == this._energyStoredLast && this._energyStored == this._energyStoredMax || this._energyStored > this._energyStoredLast);
            this._energyStoredLast = this._energyStored;
        }
    }

    @Override
    public void onNeighboorChanged() {
        HashMap producerTiles = new HashMap();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            BlockPosition p = new BlockPosition(this);
            p.orientation = d;
            p.moveForwards(1);
            TileEntity te = this.field_145850_b.func_147438_o(p.x, p.y, p.z);
            if (te == null || !(te instanceof TileEntityEnergyProducer)) continue;
            producerTiles.put(d, (TileEntityEnergyProducer)te);
        }
        this._producerTiles = producerTiles;
    }

    public BridgeSideData getDataForSide(ForgeDirection dir) {
        if (!this.field_145850_b.field_72995_K) {
            BridgeSideData d = new BridgeSideData();
            BlockPosition p = new BlockPosition(this);
            p.orientation = dir;
            p.moveForwards(1);
            TileEntity te = this.field_145850_b.func_147438_o(p.x, p.y, p.z);
            if (te != null && te instanceof TileEntityBridgeComponent) {
                if (te instanceof TileEntityEnergyConsumer) {
                    d.isConsumer = true;
                    d.outputRate = ((TileEntityEnergyConsumer)te).getInputRate();
                }
                if (te instanceof TileEntityEnergyProducer) {
                    d.isProducer = true;
                    d.outputRate = this._producerOutputRates.get(dir);
                }
                TileEntityBridgeComponent c = (TileEntityBridgeComponent)te;
                d.powerSystem = c.getPowerSystem();
                d.isConnected = c.isConnected();
                d.side = dir;
                d.voltageNameIndex = c.getVoltageIndex();
            }
            return d;
        }
        return this.clientSideData.get(dir);
    }

    public BridgeSideData[] getClientData() {
        BridgeSideData[] data = new BridgeSideData[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            data[dir.ordinal()] = this.clientSideData.get(dir);
        }
        return data;
    }

    public void setClientDataForSide(ForgeDirection dir, BridgeSideData data) {
        if (this.clientSideData.containsKey(dir)) {
            this.clientSideData.remove(dir);
        }
        this.clientSideData.put(dir, data);
    }

    public boolean isInputLimited() {
        return this._isInputLimited;
    }

    @SideOnly(value=Side.CLIENT)
    public void setIsInputLimited(boolean isInputLimited) {
        this._isInputLimited = isInputLimited;
    }

    public double getEnergyScaled() {
        if (this.field_145850_b.field_72995_K) {
            return this._energyScaledClient;
        }
        return 120.0 * (this._energyStored / this._energyStoredMax);
    }

    public void setEnergyScaled(double scaled) {
        this._energyScaledClient = scaled;
    }

    public void addWailaInfo(List<String> info) {
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74780_a("energyStored", this._energyStored);
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this._energyStored = par1nbtTagCompound.func_74769_h("energyStored");
    }

    public EnergyBridgeSyncPacket getNetPacket() {
        BridgeSideData[] bridgeSideData = new BridgeSideData[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            bridgeSideData[dir.ordinal()] = this.getDataForSide(dir);
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        for (int side = 0; side < 6; ++side) {
            BridgeSideData data = bridgeSideData[side];
            NBTTagCompound tag = new NBTTagCompound();
            data.writeToNBT(tag);
            tagCompound.func_74782_a(String.valueOf(side), (NBTBase)tag);
        }
        tagCompound.func_74757_a("InputLimited", this.isInputLimited());
        tagCompound.func_74780_a("Energy", this.getEnergyScaled());
        EnergyBridgeSyncPacket syncPacket = new EnergyBridgeSyncPacket(tagCompound, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return syncPacket;
    }
}

