/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.main;

import covers1624.powerconverters.api.registry.PowerSystemRegistry;
import covers1624.powerconverters.tile.main.TileEntityBridgeComponent;
import covers1624.powerconverters.tile.main.TileEntityEnergyBridge;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityEnergyConsumer<T>
extends TileEntityBridgeComponent<T> {
    public TileEntityEnergyConsumer(PowerSystemRegistry.PowerSystem powerSystem, int voltageNameIndex, Class<T> adjacentClass) {
        super(powerSystem, voltageNameIndex, adjacentClass);
        this.type = "Consumer";
    }

    protected double storeEnergy(double energy, boolean simulate) {
        for (Map.Entry<ForgeDirection, TileEntityEnergyBridge> bridge : this.getBridges().entrySet()) {
            if (!this.isGettingRedstone()) {
                energy = bridge.getValue().storeEnergy(energy, simulate);
            }
            if (!(energy <= 0.0)) continue;
            return 0.0;
        }
        return energy;
    }

    protected double getTotalEnergyDemand() {
        double demand = 0.0;
        for (Map.Entry<ForgeDirection, TileEntityEnergyBridge> bridge : this.getBridges().entrySet()) {
            demand += bridge.getValue().getEnergyStoredMax() - bridge.getValue().getEnergyStored();
        }
        return demand;
    }

    public abstract double getInputRate();
}

