/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.steam;

import covers1624.powerconverters.PowerConverters;
import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.init.PowerSystems;
import covers1624.powerconverters.tile.main.TileEntityEnergyConsumer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySteamConsumer
extends TileEntityEnergyConsumer<IFluidHandler>
implements IFluidHandler {
    private FluidTank _steamTank = new FluidTank(10000);
    private int _mBLastTick;

    public TileEntitySteamConsumer() {
        super(PowerSystems.powerSystemSteam, 0, IFluidHandler.class);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this._steamTank != null && this._steamTank.getFluid() != null) {
            int amount = this._steamTank.getFluid().amount;
            double energy = amount * PowerSystems.powerSystemSteam.getScaleAmmount();
            energy = this.storeEnergy(energy, false);
            int toDrain = amount - (int)(energy / (double)PowerSystems.powerSystemSteam.getScaleAmmount());
            this._steamTank.drain(toDrain, true);
            this._mBLastTick = toDrain;
        } else {
            this._mBLastTick = 0;
        }
    }

    @Override
    public int getVoltageIndex() {
        return 0;
    }

    @Override
    public double getInputRate() {
        return this._mBLastTick;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluidID() != PowerConverters.steamId || PowerConverters.steamId == -1) {
            return 0;
        }
        return this._steamTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && fluid.getID() == PowerConverters.steamId && !ConfigurationHandler.dissableSteamConsumer;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this._steamTank.getInfo()};
    }
}

