/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import gnu.trove.impl.unmodifiable.TUnmodifiableObjectLongMap;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.text.WordUtils;
import wanion.unidict.UniDict;
import wanion.unidict.common.Reference;
import wanion.unidict.resource.Resource;

public final class Config {
    private static final Configuration config = new Configuration(new File("." + Reference.SLASH + "config" + Reference.SLASH + "UniDict" + ".cfg"), "1.7.10-2.9.2");
    public static boolean forestry;
    public static boolean foundry;
    public static boolean ic2;
    public static boolean tinkersConstruct;
    private static final String general = "general";
    public static final boolean keepOneEntry;
    public static final boolean inputReplacement;
    public static final Set<String> keepOneEntryModBlackSet;
    public static boolean autoHideInNEI;
    public static final Set<String> hideInNEIBlackSet;
    public static final boolean kindDebugMode;
    private static final String resources = "resources";
    public static final boolean enableSpecificKindSort;
    public static final TObjectLongMap<String> ownerOfEveryThing;
    public static final Set<String> metalsToUnify;
    public static final Set<String> childrenOfMetals;
    public static final List<String> resourceBlackList;
    public static final Map<String, Set<String>> customUnifiedResources;
    private static final String modules = "modules";
    static final boolean integrationModule;
    public static boolean abyssalCraft;
    public static boolean ae2Integration;
    public static boolean electricalAgeIntegration;
    public static boolean enderIOIntegration;
    public static boolean forestryIntegration;
    public static boolean foundryIntegration;
    public static boolean fspIntegration;
    public static boolean hydrauliCraftIntegration;
    public static boolean ic2Integration;
    public static boolean ieIntegration;
    public static boolean magnetiCraftIntegration;
    public static boolean mekanismIntegration;
    public static boolean nuclearCraftIntegration;
    public static boolean railCraftIntegration;
    public static boolean teIntegration;
    private static final String vanillaIntegrations = "vanillaIntegrations";
    public static final boolean chestIntegration;
    public static final boolean craftingIntegration;
    public static final boolean furnaceIntegration;

    static void init() {
        boolean deleted = false;
        try {
            if (!config.getDefinedConfigVersion().equals(config.getLoadedConfigVersion())) {
                deleted = config.getConfigFile().delete();
            }
            forestry = Loader.isModLoaded((String)"Forestry");
            foundry = Loader.isModLoaded((String)"foundry");
            ic2 = Loader.isModLoaded((String)"IC2");
            tinkersConstruct = Loader.isModLoaded((String)"TConstruct");
            autoHideInNEI = config.getBoolean("autoHideInNEI", general, true, "auto hide items in NEI?") && Loader.isModLoaded((String)"NotEnoughItems");
            String integrations = "integrations";
            abyssalCraft = config.getBoolean("abyssalCraft", "integrations", true, "AbyssalCraft Integration.") && Loader.isModLoaded((String)"abyssalcraft");
            ae2Integration = config.getBoolean("appliedEnergistics2", "integrations", true, "Applied Energistics 2 Integration.") && Loader.isModLoaded((String)"appliedenergistics2");
            electricalAgeIntegration = config.getBoolean("electricalAge", "integrations", true, "Electrical Age Integration.") && Loader.isModLoaded((String)"Eln");
            enderIOIntegration = config.getBoolean("enderIO", "integrations", true, "Ender IO Integration.") && Loader.isModLoaded((String)"EnderIO");
            forestryIntegration = config.getBoolean("forestry", "integrations", true, "Forestry Integration.") && forestry;
            foundryIntegration = config.getBoolean("foundry", "integrations", true, "Foundry Integration.") && Loader.isModLoaded((String)"foundry");
            fspIntegration = config.getBoolean("flaxbeardsSteamPower", "integrations", true, "Flaxbeard's Steam Power Integration.") && Loader.isModLoaded((String)"Steamcraft");
            hydrauliCraftIntegration = config.getBoolean("hydrauliCraft", "integrations", true, "Hydraulicraft Integration.") && Loader.isModLoaded((String)"HydCraft");
            ic2Integration = config.getBoolean("industrialCraft2", "integrations", true, "Industrial Craft 2 Integration.") && ic2;
            ieIntegration = config.getBoolean("immersiveEngineering", "integrations", true, "Immersive Engineering Integration.") && Loader.isModLoaded((String)"ImmersiveEngineering");
            magnetiCraftIntegration = config.getBoolean("magnetiCraft", "integrations", true, "Magneticraft Integration.") && Loader.isModLoaded((String)"Magneticraft");
            mekanismIntegration = config.getBoolean("mekanism", "integrations", true, "Mekanism Integration.") && Loader.isModLoaded((String)"Mekanism");
            nuclearCraftIntegration = config.getBoolean("nuclearCraft", "integrations", true, "NuclearCraft Integration") && Loader.isModLoaded((String)"NuclearCraft");
            railCraftIntegration = config.getBoolean("railcraft", "integrations", true, "Railcraft Integration.") && Loader.isModLoaded((String)"Railcraft");
            teIntegration = config.getBoolean("thermalExpansion", "integrations", true, "Thermal Expansion Integration.") && Loader.isModLoaded((String)"ThermalExpansion");
        }
        catch (Exception e) {
            UniDict.getLogger().info("Something went wrong on " + config.getConfigFile() + "loading. " + e);
        }
        if (config.hasChanged() || deleted) {
            config.save();
        }
    }

    public static void saveIfHasChanged() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static TObjectLongMap<String> getOwnerOfEveryKindMap(long kind) {
        String kindName = WordUtils.capitalize((String)Resource.getNameOfKind(kind));
        String[] ownerOfEveryKind = config.getStringList("ownerOfEvery" + kindName, resources, new String[]{"ThermalFoundation", "minecraft", "IC2", "TConstruct", "Mekanism", "Magneticraft"}, "entries of kind \"" + kindName + "\" will be sorted according to the modID list below\nmust be the exact modID.\n");
        TObjectLongHashMap ownerOfEveryThingMap = new TObjectLongHashMap(10, 1.0f, Long.MAX_VALUE);
        for (int i = 0; i < ownerOfEveryKind.length; ++i) {
            ownerOfEveryThingMap.put((Object)ownerOfEveryKind[i], (long)i);
        }
        return ownerOfEveryThingMap;
    }

    private static TObjectLongMap<String> getOwnerOfEveryThingMap() {
        String[] ownerOfEveryThing = config.getStringList("ownerOfEveryThing", resources, new String[]{"ThermalFoundation", "minecraft", "IC2", "TConstruct", "Mekanism", "Magneticraft"}, "all the entries will be sorted according to the modID list below\nmust be the exact modID.\n");
        TObjectLongHashMap ownerOfEveryThingMap = new TObjectLongHashMap(10, 1.0f, Long.MAX_VALUE);
        for (int i = 0; i < ownerOfEveryThing.length; ++i) {
            ownerOfEveryThingMap.put((Object)ownerOfEveryThing[i], (long)i);
        }
        return ownerOfEveryThingMap;
    }

    private static Map<String, Set<String>> getCustomUnifiedResourcesMap() {
        THashMap customUnifiedResources = new THashMap();
        Pattern splitPattern = Pattern.compile("\\|");
        for (String customUnifiedResource : config.getStringList("customUnifiedResources", resources, new String[]{"Obsidian:dustTiny|dust", "Stone:dust"}, "Here you can put a list to custom unify them.\nmay break some recipes.\nmust be in this format \"ResourceName:kind1|kind2|...\".\nif you put gems here, be aware that it will include the \"block\" of that gem too.")) {
            LinkedHashSet kindSet;
            int baseSeparatorIndex = customUnifiedResource.indexOf(58);
            if (baseSeparatorIndex == -1 || (kindSet = Sets.newLinkedHashSet(Arrays.asList(splitPattern.split(customUnifiedResource.substring(baseSeparatorIndex + 1, customUnifiedResource.length()))))).isEmpty()) continue;
            customUnifiedResources.put(customUnifiedResource.substring(0, baseSeparatorIndex), kindSet);
        }
        return customUnifiedResources;
    }

    static {
        keepOneEntry = config.getBoolean("keepOneEntry", general, false, "keep only one entry per ore dict entry?");
        inputReplacement = config.getBoolean("inputReplacement", general, false, "Enabling this will remove all non-standard items as input.\nNote: this will only affect machines that doesn't use OreDictionary.");
        keepOneEntryModBlackSet = Collections.unmodifiableSet(Sets.newLinkedHashSet(Arrays.asList(config.getStringList("keepOneEntryModBlackList", general, new String[0], "mods listed here will be blacklisted in keepOneEntry.\nmust be the exact modID."))));
        hideInNEIBlackSet = Collections.unmodifiableSet(Sets.newLinkedHashSet(Arrays.asList(config.getStringList("autoHideInNEIBlackList", general, new String[]{"ore"}, "put here things that you don't want to hide in NEI.\nonly works if keepOneEntry is false."))));
        kindDebugMode = config.getBoolean("kindDebugMode", general, false, "Enable this to keep track of all the kinds.\nthe output will be in logs folder.");
        enableSpecificKindSort = config.getBoolean("enableSpecificKindSort", resources, false, "enabling this allow you to specify the \"owner\" of each kind.\nalso will make \"S:ownerOfEveryThing\" be ignored.");
        ownerOfEveryThing = new TUnmodifiableObjectLongMap((TObjectLongMap)(!enableSpecificKindSort ? Config.getOwnerOfEveryThingMap() : new TObjectLongHashMap()));
        metalsToUnify = Collections.unmodifiableSet(Sets.newLinkedHashSet(Arrays.asList(config.getStringList("metalsToUnify", resources, new String[]{"Iron", "Gold", "Copper", "Tin", "Silver", "Lead", "Nickel", "Platinum", "Aluminum", "Aluminium", "Ardite", "Cobalt", "Osmium", "Mithril", "Zinc", "Invar", "Steel", "Bronze", "Electrum", "Brass"}, "list of things to do unifying things.\n"))));
        childrenOfMetals = Collections.unmodifiableSet(Sets.newLinkedHashSet(Arrays.asList(config.getStringList("childrenOfMetals", resources, new String[]{"ore", "dustTiny", "chunk", "dust", "nugget", "ingot", "block", "plate", "gear"}, "what kind of child do you want to make a standard?\n"))));
        resourceBlackList = Arrays.asList(config.getStringList("resourceBlackList", resources, new String[]{"Aluminium"}, "resources to be black-listed.\nthis exists to avoid duplicates.\nthis affect the API."));
        customUnifiedResources = Collections.unmodifiableMap(Config.getCustomUnifiedResourcesMap());
        integrationModule = config.getBoolean("integration", modules, true, "Integration Module enabled?\nif false all the Integrations will be disabled.\nthis will affect non-standalone tweak.\n");
        chestIntegration = config.getBoolean("chestIntegration", vanillaIntegrations, true, "Chest Integration? (\"dungeon chest, nether fortress chests, etc...\").");
        craftingIntegration = config.getBoolean("craftingIntegration", vanillaIntegrations, true, "Crafting Integration");
        furnaceIntegration = config.getBoolean("furnaceIntegration", vanillaIntegrations, true, "Furnace Integration");
    }
}

