/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.network.PacketHandler;
import buildcraft.additionalpipes.network.message.MessageChunkloadData;
import buildcraft.additionalpipes.network.message.MessageChunkloadRequest;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.core.LaserKind;
import buildcraft.core.lib.EntityBlock;
import buildcraft.core.lib.utils.LaserUtils;
import com.google.common.collect.ImmutableSetMultimap;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoadViewDataProxy
implements Comparator<ChunkCoordIntPair> {
    public static final int MAX_SIGHT_RANGE = 31;
    private int sightRange;
    private List<EntityBlock> lasers;
    private List<ChunkCoordIntPair> persistentChunks;
    private boolean active = false;

    public ChunkLoadViewDataProxy(int chunkSightRange) {
        this.setSightRange(chunkSightRange);
        this.lasers = new ArrayList<EntityBlock>();
        this.persistentChunks = new ArrayList<ChunkCoordIntPair>();
        this.active = false;
    }

    private void addLasersToList(EntityBlock[] entityBlocks) {
        for (EntityBlock laser : entityBlocks) {
            this.lasers.add(laser);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void toggleLasers() {
        if (this.lasersActive()) {
            this.deactivateLasers();
        } else {
            this.activateLasers();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void activateLasers() {
        this.deactivateLasers();
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        int playerY = (int)player.field_70163_u - 1;
        for (ChunkCoordIntPair coords : this.persistentChunks) {
            int xCoord = coords.field_77276_a * 16;
            int zCoord = coords.field_77275_b * 16;
            this.addLasersToList(LaserUtils.createLaserBox((World)player.field_70170_p, (double)xCoord, (double)playerY, (double)zCoord, (double)(xCoord + 16), (double)playerY, (double)(zCoord + 16), (LaserKind)LaserKind.Blue));
            this.addLasersToList(LaserUtils.createLaserBox((World)player.field_70170_p, (double)xCoord, (double)(playerY - 20), (double)zCoord, (double)(xCoord + 16), (double)(playerY - 20), (double)(zCoord + 16), (LaserKind)LaserKind.Blue));
            this.addLasersToList(LaserUtils.createLaserBox((World)player.field_70170_p, (double)xCoord, (double)(playerY + 20), (double)zCoord, (double)(xCoord + 16), (double)(playerY + 20), (double)(zCoord + 16), (LaserKind)LaserKind.Blue));
            this.addLasersToList(LaserUtils.createLaserBox((World)player.field_70170_p, (double)(xCoord + 7), (double)playerY, (double)(zCoord + 7), (double)(xCoord + 9), (double)playerY, (double)(zCoord + 9), (LaserKind)LaserKind.Red));
            this.addLasersToList(LaserUtils.createLaserBox((World)player.field_70170_p, (double)(xCoord + 7), (double)(playerY - 20), (double)(zCoord + 7), (double)(xCoord + 9), (double)(playerY - 20), (double)(zCoord + 9), (LaserKind)LaserKind.Red));
            this.addLasersToList(LaserUtils.createLaserBox((World)player.field_70170_p, (double)(xCoord + 7), (double)(playerY + 20), (double)(zCoord + 7), (double)(xCoord + 9), (double)(playerY + 20), (double)(zCoord + 9), (LaserKind)LaserKind.Red));
        }
        this.active = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void deactivateLasers() {
        for (EntityBlock laser : this.lasers) {
            laser.func_70106_y();
        }
        this.lasers.clear();
        this.active = false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean lasersActive() {
        return this.active;
    }

    @SideOnly(value=Side.CLIENT)
    public void requestPersistentChunks() {
        MessageChunkloadRequest message = new MessageChunkloadRequest();
        PacketHandler.INSTANCE.sendToServer((IMessage)message);
    }

    @SideOnly(value=Side.CLIENT)
    public void receivePersistentChunks(List<ChunkCoordIntPair> chunks) {
        boolean changed = true;
        if (this.persistentChunks.size() == chunks.size()) {
            changed = false;
            Collections.sort(chunks, this);
            Collections.sort(this.persistentChunks, this);
            for (int i = 0; i < chunks.size(); ++i) {
                if (chunks.get(i).equals((Object)this.persistentChunks.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.persistentChunks = chunks;
            if (this.active) {
                this.activateLasers();
            }
        }
    }

    public void setSightRange(int range) {
        this.sightRange = range;
        if (this.sightRange > 31) {
            this.sightRange = 31;
        }
    }

    public void sendPersistentChunksToPlayer(EntityPlayerMP player) {
        if (this.sightRange > 31) {
            this.sightRange = 31;
        }
        ImmutableSetMultimap persistentChunks = ForgeChunkManager.getPersistentChunksFor((World)player.field_70170_p);
        LinkedList<ChunkCoordIntPair> chunksInRange = new LinkedList<ChunkCoordIntPair>();
        int playerX = ((int)player.field_70165_t >> 4) - this.sightRange / 2;
        int playerZ = ((int)player.field_70161_v >> 4) - this.sightRange / 2;
        for (int i = -this.sightRange; i <= this.sightRange; ++i) {
            for (int j = -this.sightRange; j <= this.sightRange; ++j) {
                ChunkCoordIntPair coords = new ChunkCoordIntPair(playerX + i, playerZ + j);
                if (!persistentChunks.containsKey((Object)coords)) continue;
                chunksInRange.add(coords);
            }
        }
        MessageChunkloadData message = new MessageChunkloadData(chunksInRange);
        PacketHandler.INSTANCE.sendTo((IMessage)message, player);
        Log.debug("[ChunkLoadViewDataProxy] Sent chunks within " + this.sightRange + " of player.");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && APConfiguration.chunkSightAutorefresh && this.lasersActive()) {
            this.requestPersistentChunks();
        }
    }

    public String getLabel() {
        return this.getClass().getSimpleName();
    }

    public int nextTickSpacing() {
        return 100;
    }

    @Override
    public int compare(ChunkCoordIntPair first, ChunkCoordIntPair other) {
        int dx = first.field_77276_a - other.field_77276_a;
        return dx != 0 ? dx : first.field_77275_b - other.field_77275_b;
    }
}

