/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.gui;

import buildcraft.BuildCraftCore;
import buildcraft.additionalpipes.gui.ContainerTeleportPipe;
import buildcraft.additionalpipes.network.PacketHandler;
import buildcraft.additionalpipes.network.message.MessageTelePipeUpdate;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.textures.Textures;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

@SideOnly(value=Side.CLIENT)
public class GuiTeleportPipe
extends GuiBuildCraft {
    private final PipeTeleport<?> pipe;
    private final ContainerTeleportPipe container;
    private final GuiButton[] buttons = new GuiButton[8];

    public GuiTeleportPipe(EntityPlayer player, PipeTeleport<?> pipe) {
        super((BuildCraftContainer)new ContainerTeleportPipe(player, pipe), null, Textures.GUI_TELEPORT);
        this.pipe = pipe;
        this.container = (ContainerTeleportPipe)this.field_147002_h;
        this.field_146999_f = 228;
        this.field_147000_g = 117;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2 + 16;
        int bw = this.field_146999_f - 24;
        this.buttons[0] = new GuiButton(1, x + 12, y + 32, bw / 6, 20, "-100");
        this.field_146292_n.add(this.buttons[0]);
        this.buttons[1] = new GuiButton(2, x + 12 + bw / 6, y + 32, bw / 6, 20, "-10");
        this.field_146292_n.add(this.buttons[1]);
        this.buttons[2] = new GuiButton(3, x + 12 + bw * 2 / 6, y + 32, bw / 6, 20, "-1");
        this.field_146292_n.add(this.buttons[2]);
        this.buttons[3] = new GuiButton(4, x + 12 + bw * 3 / 6, y + 32, bw / 6, 20, "+1");
        this.field_146292_n.add(this.buttons[3]);
        this.buttons[4] = new GuiButton(5, x + 12 + bw * 4 / 6, y + 32, bw / 6, 20, "+10");
        this.field_146292_n.add(this.buttons[4]);
        this.buttons[5] = new GuiButton(6, x + 12 + bw * 5 / 6, y + 32, bw / 6, 20, "+100");
        this.field_146292_n.add(this.buttons[5]);
        this.buttons[6] = new GuiButton(7, x + 12, y + 10, bw / 2, 20, "Send Only");
        this.field_146292_n.add(this.buttons[6]);
        this.buttons[7] = new GuiButton(8, x + 12 + bw * 3 / 6, y + 10, bw / 2, 20, "Private");
        this.field_146292_n.add(this.buttons[7]);
    }

    protected void func_146979_b(int p1, int p2) {
        super.func_146979_b(p1, p2);
        this.field_146289_q.func_78276_b("Frequency: " + this.pipe.getFrequency(), 16, 12, 0x404040);
        this.field_146289_q.func_78276_b("(" + this.pipe.container.field_145851_c + ", " + this.pipe.container.field_145848_d + ", " + this.pipe.container.field_145849_e + ")", 128, 12, 0x404040);
        switch (this.pipe.state) {
            case 3: {
                this.buttons[6].field_146126_j = "Send & Receive";
                break;
            }
            case 2: {
                this.buttons[6].field_146126_j = "Receive Only";
                break;
            }
            case 1: {
                this.buttons[6].field_146126_j = "Send Only";
                break;
            }
            default: {
                this.buttons[6].field_146126_j = "Disabled";
            }
        }
        this.buttons[7].field_146126_j = this.pipe.isPublic ? "Public" : "Private";
    }

    protected void func_146284_a(GuiButton guibutton) {
        int freq = this.pipe.getFrequency();
        byte state = this.pipe.state;
        boolean isPublic = this.pipe.isPublic;
        switch (guibutton.field_146127_k) {
            case 1: {
                freq -= 100;
                break;
            }
            case 2: {
                freq -= 10;
                break;
            }
            case 3: {
                --freq;
                break;
            }
            case 4: {
                ++freq;
                break;
            }
            case 5: {
                freq += 10;
                break;
            }
            case 6: {
                freq += 100;
                break;
            }
            case 7: {
                state = (byte)((state + 1) % 4);
                break;
            }
            case 8: {
                boolean bl = isPublic = !isPublic;
            }
        }
        if (freq < 0) {
            freq = 0;
        }
        MessageTelePipeUpdate packet = new MessageTelePipeUpdate(this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e, freq, isPublic, state);
        PacketHandler.INSTANCE.sendToServer((IMessage)packet);
    }

    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.add((GuiBuildCraft.Ledger)new TeleportPipeLedger());
    }

    protected class TeleportPipeLedger
    extends GuiBuildCraft.Ledger {
        int headerColour;
        int subheaderColour;
        int textColour;
        String networkTitle;

        public TeleportPipeLedger() {
            super((GuiBuildCraft)GuiTeleportPipe.this);
            this.headerColour = 14797103;
            this.subheaderColour = 11186104;
            this.textColour = 0;
            this.maxHeight = 99;
            this.overlayColor = 13921311;
        }

        public void draw(int x, int y) {
            if (this.networkTitle == null) {
                this.networkTitle = (((GuiTeleportPipe)GuiTeleportPipe.this).pipe.state & 1) >= 1 ? "Outputs:" : "Inputs:";
            }
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Textures.ITEMS);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiTeleportPipe.this.field_146289_q.func_78261_a("Teleport Pipe", x + 22, y + 8, this.headerColour);
            GuiTeleportPipe.this.field_146289_q.func_78261_a("Owner:", x + 22, y + 20, this.subheaderColour);
            GuiTeleportPipe.this.field_146289_q.func_78276_b(((GuiTeleportPipe)GuiTeleportPipe.this).pipe.ownerName, x + 22, y + 32, this.textColour);
            GuiTeleportPipe.this.field_146289_q.func_78261_a(this.networkTitle, x + 22, y + 44, this.subheaderColour);
            GuiTeleportPipe.this.field_146289_q.func_78276_b(String.valueOf(((GuiTeleportPipe)GuiTeleportPipe.this).container.connectedPipes), x + 66, y + 45, this.textColour);
            int[] net = ((GuiTeleportPipe)GuiTeleportPipe.this).pipe.network;
            if (net.length > 0) {
                GuiTeleportPipe.this.field_146289_q.func_78276_b("(" + net[0] + ", " + net[1] + ", " + net[2] + ")", x + 22, y + 56, this.textColour);
            }
            if (net.length > 3) {
                GuiTeleportPipe.this.field_146289_q.func_78276_b("(" + net[3] + ", " + net[4] + ", " + net[5] + ")", x + 22, y + 68, this.textColour);
            }
            if (net.length > 6) {
                GuiTeleportPipe.this.field_146289_q.func_78276_b("(" + net[6] + ", " + net[7] + ", " + net[8] + ")", x + 22, y + 80, this.textColour);
            }
        }

        public String getTooltip() {
            return "Owner: " + ((GuiTeleportPipe)GuiTeleportPipe.this).pipe.ownerName;
        }
    }
}

