/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.network.message;

import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;

public class MessageTelePipeData
implements IMessage,
IMessageHandler<MessageTelePipeData, IMessage> {
    public int x;
    public int y;
    public int z;
    public int[] locations;
    public String ownerUUID;
    public String ownerName;

    public MessageTelePipeData() {
    }

    public MessageTelePipeData(int x, int y, int z, int[] locations, UUID ownerUUID, String ownerName) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.locations = locations;
        this.ownerUUID = ownerUUID.toString();
        this.ownerName = ownerName;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        int locationsLength = buf.readInt();
        this.locations = new int[locationsLength];
        for (int counter = 0; counter < locationsLength; ++counter) {
            this.locations[counter] = buf.readInt();
        }
        this.ownerUUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.locations.length);
        for (int location : this.locations) {
            buf.writeInt(location);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ownerUUID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ownerName);
    }

    public IMessage onMessage(MessageTelePipeData message, MessageContext ctx) {
        TileEntity te = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
        PipeTeleport pipe = (PipeTeleport)((TileGenericPipe)te).pipe;
        pipe.ownerUUID = UUID.fromString(message.ownerUUID);
        pipe.ownerName = message.ownerName;
        pipe.network = message.locations;
        return null;
    }

    public String toString() {
        return "MessageTelePipeData";
    }
}

