/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.messages;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import neresources.api.messages.RegistryMessage;
import neresources.api.messages.utils.MessageHelper;
import neresources.api.utils.Priority;
import neresources.utils.WeightedRandomChestContentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;

public class RegisterDungeonMessage
extends RegistryMessage {
    private Map<ItemStack, Float> chestDrops = new LinkedHashMap<ItemStack, Float>();
    private String name;
    private int maxStacks;
    private int minStacks;

    public RegisterDungeonMessage(String name, int maxStacks, List<WeightedRandomChestContent> chestDrops) {
        this(name, 0, maxStacks, chestDrops);
    }

    public RegisterDungeonMessage(String name, int minStacks, int maxStacks, List<WeightedRandomChestContent> chestDrops) {
        this(name, minStacks, maxStacks, Priority.FIRST);
        int totalWeight = 0;
        for (WeightedRandomChestContent chestItem : chestDrops) {
            totalWeight += chestItem.field_76292_a;
        }
        for (WeightedRandomChestContent chestItem : WeightedRandomChestContentHelper.sort(chestDrops.toArray(new WeightedRandomChestContent[chestDrops.size()]))) {
            this.chestDrops.put(chestItem.field_76297_b, Float.valueOf((float)(chestItem.field_76296_e + chestItem.field_76295_d) / 2.0f * (float)chestItem.field_76292_a / (float)totalWeight));
        }
    }

    public RegisterDungeonMessage(String name, int maxStacks, Map<ItemStack, Float> chestDrops) {
        this(name, 0, maxStacks, chestDrops);
    }

    public RegisterDungeonMessage(String name, int minStacks, int maxStacks, Map<ItemStack, Float> chestDrops) {
        this(name, minStacks, maxStacks, Priority.FIRST);
        this.chestDrops = chestDrops;
    }

    private RegisterDungeonMessage(String name, int minStacks, int maxStacks, Priority priority) {
        super(priority, true);
        this.name = name;
        this.minStacks = minStacks;
        this.maxStacks = maxStacks;
    }

    public RegisterDungeonMessage(NBTTagCompound tagCompound) {
        super(tagCompound);
        this.chestDrops = MessageHelper.nbtTagListToMap(tagCompound.func_150295_c("itemList", 10));
        this.name = tagCompound.func_74779_i("name");
        this.minStacks = tagCompound.func_74762_e("min");
        this.maxStacks = tagCompound.func_74762_e("max");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74782_a("itemList", (NBTBase)MessageHelper.mapToNBTTagList(this.chestDrops));
        tagCompound.func_74778_a("name", this.name);
        tagCompound.func_74768_a("min", this.minStacks);
        tagCompound.func_74768_a("max", this.maxStacks);
        return tagCompound;
    }

    @Override
    public boolean isValid() {
        return !this.name.equals("") && this.maxStacks > 0 && this.chestDrops != null && !this.chestDrops.isEmpty();
    }

    public Map<ItemStack, Float> getChestDrops() {
        return this.chestDrops;
    }

    public String getName() {
        return this.name;
    }

    public int getMinStacks() {
        return this.minStacks;
    }

    public int getMaxStacks() {
        return this.maxStacks;
    }
}

