/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.apiimpl.v2;

import com.InfinityRaider.AgriCraft.api.APIStatus;
import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v2.APIv2;
import com.InfinityRaider.AgriCraft.api.v2.ICrop;
import com.InfinityRaider.AgriCraft.api.v2.ICropPlant;
import com.InfinityRaider.AgriCraft.api.v2.IGrowthRequirementBuilder;
import com.InfinityRaider.AgriCraft.api.v2.IJournal;
import com.InfinityRaider.AgriCraft.api.v2.ISeedStats;
import com.InfinityRaider.AgriCraft.api.v2.IStatCalculator;
import com.InfinityRaider.AgriCraft.api.v2.IStatStringDisplayer;
import com.InfinityRaider.AgriCraft.apiimpl.v1.APIimplv1;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.PlantStats;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlantAPIv2;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import com.InfinityRaider.AgriCraft.farming.mutation.statcalculator.StatCalculator;
import com.InfinityRaider.AgriCraft.farming.mutation.statcalculator.StatCalculatorAPIv2;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.utility.statstringdisplayer.StatStringDisplayer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class APIimplv2
extends APIimplv1
implements APIv2 {
    public APIimplv2(int version, APIStatus status) {
        super(version, status);
    }

    @Override
    public boolean registerValidSoil(BlockWithMeta soil) {
        GrowthRequirementHandler.addSoil(soil);
        return true;
    }

    @Override
    public short getStatCap() {
        return (short)ConfigurationHandler.cropStatCap;
    }

    @Override
    public ISeedStats getSeedStats(ItemStack seed) {
        if (!this.isHandledByAgricraft(seed)) {
            return null;
        }
        if (seed.field_77990_d != null && seed.field_77990_d.func_74764_b("growth") && seed.field_77990_d.func_74767_n("analyzed")) {
            return PlantStats.readFromNBT(seed.field_77990_d);
        }
        return new PlantStats(-1, -1, -1);
    }

    @Override
    public void registerCropPlant(ICropPlant plant) {
        CropPlantHandler.addCropToRegister(new CropPlantAPIv2(plant));
    }

    @Override
    public ICropPlant getCropPlant(ItemStack seed) {
        return CropPlantHandler.getPlantFromStack(seed);
    }

    @Override
    public ICropPlant getCropPlant(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityCrop)) {
            return null;
        }
        return ((TileEntityCrop)te).getPlant();
    }

    @Override
    public void analyze(ItemStack seed) {
        if (CropPlantHandler.isValidSeed(seed)) {
            if (seed.func_77942_o()) {
                String[] keys;
                NBTTagCompound tag = seed.func_77978_p();
                for (String key : keys = new String[]{"growth", "gain", "strength"}) {
                    if (tag.func_74764_b(key)) continue;
                    tag.func_74777_a(key, (short)1);
                }
                tag.func_74757_a("analyzed", true);
            } else {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74777_a("growth", (short)1);
                tag.func_74777_a("gain", (short)1);
                tag.func_74777_a("strength", (short)1);
                tag.func_74757_a("analyzed", true);
                seed.func_77982_d(tag);
            }
        }
    }

    @Override
    public ICrop getCrop(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ICrop) {
            return (ICrop)te;
        }
        return null;
    }

    @Override
    public void setStatCalculator(IStatCalculator calculator) {
        StatCalculator.setStatCalculator(new StatCalculatorAPIv2(calculator));
    }

    @Override
    public IGrowthRequirementBuilder createGrowthRequirementBuilder() {
        return GrowthRequirementHandler.getNewBuilder();
    }

    @Override
    public IGrowthRequirement createDefaultGrowthRequirement() {
        return GrowthRequirementHandler.getNewBuilder().build();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStatStringDisplayer(IStatStringDisplayer displayer) {
        StatStringDisplayer.setStatStringDisplayer(displayer);
    }

    @Override
    public boolean isSeedDiscoveredInJournal(ItemStack journal, ItemStack seed) {
        if (journal == null || journal.func_77973_b() == null || !(journal.func_77973_b() instanceof IJournal)) {
            return false;
        }
        return ((IJournal)journal.func_77973_b()).isSeedDiscovered(journal, seed);
    }

    @Override
    public void addEntryToJournal(ItemStack journal, ItemStack seed) {
        if (journal == null || journal.func_77973_b() == null || !(journal.func_77973_b() instanceof IJournal)) {
            return;
        }
        ((IJournal)journal.func_77973_b()).addEntry(journal, seed);
    }

    @Override
    public ArrayList<ItemStack> getDiscoveredSeedsFromJournal(ItemStack journal) {
        if (journal == null || journal.func_77973_b() == null || !(journal.func_77973_b() instanceof IJournal)) {
            return new ArrayList<ItemStack>();
        }
        return ((IJournal)journal.func_77973_b()).getDiscoveredSeeds(journal);
    }

    @Override
    public boolean isSeedBlackListed(ItemStack seed) {
        return CropPlantHandler.isSeedBlackListed(seed);
    }

    @Override
    public void addToSeedBlackList(ItemStack seed) {
        CropPlantHandler.addSeedToBlackList(seed);
    }

    @Override
    public void addToSeedBlacklist(Collection<? extends ItemStack> seeds) {
        CropPlantHandler.addAllToSeedBlacklist(seeds);
    }

    @Override
    public void removeFromSeedBlackList(ItemStack seed) {
        CropPlantHandler.removeFromSeedBlackList(seed);
    }

    @Override
    public void removeFromSeedBlacklist(Collection<? extends ItemStack> seeds) {
        CropPlantHandler.removeAllFromSeedBlacklist(seeds);
    }
}

