/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.harvestthenether;

import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class CropPlantHarvestTheNether
extends CropPlant {
    private final Item seed;
    private final Block plant;
    private final Item fruit;

    protected CropPlantHarvestTheNether(Item seed, Block plant, Item fruit) {
        this.seed = seed;
        this.plant = plant;
        this.fruit = fruit;
    }

    @Override
    public int tier() {
        return 3;
    }

    @Override
    public ItemStack getSeed() {
        return new ItemStack(this.seed);
    }

    @Override
    public Block getBlock() {
        return this.plant;
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        ArrayList<ItemStack> fruits = new ArrayList<ItemStack>();
        fruits.add(new ItemStack(this.fruit));
        return fruits;
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        return new ItemStack(this.fruit);
    }

    @Override
    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int amount = (int)Math.ceil(((double)gain + 0.0) / 3.0); amount > 0; --amount) {
            list.add(this.getRandomFruit(rand));
        }
        return list;
    }

    @Override
    public boolean canBonemeal() {
        return this.getTier() <= 3;
    }

    @Override
    protected IGrowthRequirement initGrowthRequirement() {
        return GrowthRequirementHandler.getNewBuilder().build();
    }

    @Override
    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage, ICrop crop) {
        return true;
    }

    @Override
    public float getHeight(int meta) {
        return 0.8125f;
    }

    @Override
    public IIcon getPlantIcon(int growthStage) {
        return this.plant.func_149691_a(0, growthStage);
    }

    @Override
    public boolean renderAsFlower() {
        return false;
    }

    @Override
    public String getInformation() {
        String name = this.seed.func_77658_a();
        int index = name.indexOf("seedItem");
        name = index > 0 ? name.substring(0, index) : name;
        index = name.indexOf(46);
        name = index > 0 ? name.substring(index + 1) : name;
        return "agricraft_journal.harvestTheNether_" + name;
    }
}

