/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.item.IToolHammer;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.Optional;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="cofh.api.item.IToolHammer", modid="CoFHAPI|item")
public class ItemIETool
extends ItemIEBase
implements IToolHammer,
ITool {
    static int hammerMaxDamage;

    public ItemIETool() {
        super("tool", 1, "hammer", "wirecutter", "voltmeter", "manual");
        hammerMaxDamage = Config.getInt("hammerDurabiliy");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        int[] link;
        if (adv && stack.func_77960_j() == 0) {
            int nbtDamage = ItemNBTHelper.getInt(stack, "hammerDmg");
            list.add("Durability: " + (hammerMaxDamage - nbtDamage) + " / " + hammerMaxDamage);
        }
        if (ItemNBTHelper.hasKey(stack, "linkingPos") && (link = ItemNBTHelper.getIntArray(stack, "linkingPos")) != null && link.length > 3) {
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77960_j() == 0;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        int nbtDamage;
        if (stack.func_77960_j() == 0 && (nbtDamage = ItemNBTHelper.getInt(stack, "hammerDmg") + 1) < hammerMaxDamage) {
            ItemStack container = stack.func_77946_l();
            ItemNBTHelper.setInt(container, "hammerDmg", nbtDamage);
            return container;
        }
        return null;
    }

    public boolean func_77630_h(ItemStack stack) {
        return stack.func_77960_j() != 0;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (stack.func_77960_j() == 0) {
                int meta;
                String[] interdictedMultiblocks = null;
                if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction")) {
                    NBTTagList list = stack.func_77978_p().func_150295_c("multiblockInterdiction", 8);
                    interdictedMultiblocks = new String[list.func_74745_c()];
                    for (int i = 0; i < interdictedMultiblocks.length; ++i) {
                        interdictedMultiblocks[i] = list.func_150307_f(i);
                    }
                }
                for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
                    if (!mb.isBlockTrigger(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z))) continue;
                    boolean allowed = true;
                    if (interdictedMultiblocks != null) {
                        for (String s : interdictedMultiblocks) {
                            if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                            allowed = false;
                            break;
                        }
                    }
                    if (!allowed || !mb.createStructure(world, x, y, z, side, player)) continue;
                    return true;
                }
                if (world.func_147439_a(x, y, z) == Blocks.field_150331_J && !BlockPistonBase.func_150075_c((int)(meta = world.func_72805_g(x, y, z)))) {
                    int dir = BlockPistonBase.func_150076_b((int)meta);
                    dir = (dir + 1) % 6;
                    world.func_72921_c(x, y, z, meta - (meta & 7) + dir, 3);
                }
                return false;
            }
            if (stack.func_77960_j() == 1 && tileEntity instanceof IImmersiveConnectable) {
                IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC(nodeHere), world, new TargetingInfo(side, hitX, hitY, hitZ));
                IESaveData.setDirty(world.field_73011_w.field_76574_g);
                return true;
            }
            if (stack.func_77960_j() == 2) {
                if (!player.func_70093_af() && (tileEntity instanceof IEnergyReceiver || tileEntity instanceof IEnergyProvider)) {
                    int max = 0;
                    int stored = 0;
                    if (tileEntity instanceof IEnergyReceiver) {
                        max = ((IEnergyReceiver)tileEntity).getMaxEnergyStored(ForgeDirection.getOrientation((int)side));
                        stored = ((IEnergyReceiver)tileEntity).getEnergyStored(ForgeDirection.getOrientation((int)side));
                    } else {
                        max = ((IEnergyProvider)tileEntity).getMaxEnergyStored(ForgeDirection.getOrientation((int)side));
                        stored = ((IEnergyProvider)tileEntity).getEnergyStored(ForgeDirection.getOrientation((int)side));
                    }
                    if (max > 0) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.energyStorage", new Object[]{stored, max}));
                    }
                    return true;
                }
                if (player.func_70093_af() && tileEntity instanceof IImmersiveConnectable) {
                    if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                        ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.field_73011_w.field_76574_g, x, y, z});
                    } else {
                        int[] pos = ItemNBTHelper.getIntArray(stack, "linkingPos");
                        if (pos[0] == world.field_73011_w.field_76574_g) {
                            IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                            TileEntity te2 = world.func_147438_o(pos[1], pos[2], pos[3]);
                            if (!(te2 instanceof IImmersiveConnectable)) {
                                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.invalidPoint", new Object[0]));
                                return true;
                            }
                            IImmersiveConnectable nodeLink = (IImmersiveConnectable)te2;
                            Set<ImmersiveNetHandler.AbstractConnection> connections = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC(nodeLink), world);
                            for (ImmersiveNetHandler.AbstractConnection con : connections) {
                                if (!Utils.toCC(nodeHere).equals((Object)con.end)) continue;
                                player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.averageLoss", new Object[]{Utils.formatDouble(con.getAverageLossRate() * 100.0f, "###.000")}));
                            }
                        }
                        ItemNBTHelper.remove(stack, "linkingPos");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        if (player.func_71045_bC() != null && this.equals(player.func_71045_bC().func_77973_b())) {
            return player.func_71045_bC().func_77960_j() == 0;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77960_j() == 3) {
            player.func_71029_a((StatBase)IEAchievements.openManual);
            if (world.field_72995_K) {
                player.openGui((Object)ImmersiveEngineering.instance, 3, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        }
        return stack;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.getToolClasses(stack).contains(toolClass)) {
            return 2;
        }
        return -1;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77960_j() == 0 && ItemNBTHelper.getInt(stack, "hammerDmg") > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)ItemNBTHelper.getInt(stack, "hammerDmg") / (double)hammerMaxDamage;
    }

    public int getMaxDamage(ItemStack stack) {
        return hammerMaxDamage;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        int meta = stack.func_77960_j();
        return (Set)(meta == 0 ? ImmutableSet.of((Object)"IE_HAMMER") : (meta == 1 ? ImmutableSet.of((Object)"IE_WIRECUTTER") : new HashSet()));
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return 6.0f;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    @Override
    @Optional.Method(modid="CoFHAPI|item")
    public boolean isUsable(ItemStack stack, EntityLivingBase living, int x, int y, int z) {
        return stack != null && stack.func_77960_j() == 0;
    }

    @Override
    @Optional.Method(modid="CoFHAPI|item")
    public void toolUsed(ItemStack stack, EntityLivingBase living, int x, int y, int z) {
    }

    @Override
    public boolean isTool(ItemStack item) {
        return item.func_77960_j() != 3;
    }
}

