/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.recipes;

import aroma1997.core.recipes.IAromicRecipe;
import aroma1997.core.recipes.ShapedAromicRecipe;
import aroma1997.core.recipes.ShapelessAromicRecipe;
import aroma1997.core.util.ItemUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeUtil {
    public static void unregisterRecipe(IRecipe recipe) {
        CraftingManager.func_77594_a().func_77592_b().remove(recipe);
    }

    public static void unregisterRecipe(List<IRecipe> list) {
        for (IRecipe recipe : list) {
            RecipeUtil.unregisterRecipe(recipe);
        }
    }

    public static List<IRecipe> getRecipes(ItemStack item) {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        for (Object o : CraftingManager.func_77594_a().func_77592_b()) {
            IRecipe recipe = (IRecipe)o;
            if (!ItemUtil.areItemsSameMatching(recipe.func_77571_b(), item, ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.WILDCARD)) continue;
            list.add(recipe);
        }
        return list;
    }

    public static <E extends IRecipe> List<E> getRecipes(ItemStack item, Class<? super E> clazz) {
        List<IRecipe> list = RecipeUtil.getRecipes(item);
        ArrayList<IRecipe> ret = new ArrayList<IRecipe>();
        for (IRecipe recipe : list) {
            if (!clazz.isInstance(recipe)) continue;
            ret.add(recipe);
        }
        return ret;
    }

    public static void unregisterRecipe(ItemStack item) {
        RecipeUtil.unregisterRecipe(RecipeUtil.getRecipes(item));
    }

    public static IAromicRecipe createAromicRecipeFrom(IRecipe recipe) {
        if (recipe instanceof IAromicRecipe) {
            return (IAromicRecipe)recipe;
        }
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes r = (ShapedRecipes)recipe;
            ShapedAromicRecipe ret = new ShapedAromicRecipe();
            ret.height = r.field_77577_c;
            ret.width = r.field_77576_b;
            ret.input = r.field_77574_d;
            ret.output = r.func_77571_b();
            return ret;
        }
        if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes r = (ShapelessRecipes)recipe;
            ShapelessAromicRecipe ret = new ShapelessAromicRecipe(r.func_77571_b(), false, r.field_77579_b.toArray());
            return ret;
        }
        if (recipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe r = (ShapedOreRecipe)recipe;
            ShapedAromicRecipe ret = new ShapedAromicRecipe();
            ret.input = r.getInput();
            ret.output = r.func_77571_b();
            ret.width = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)r, (String[])new String[]{"width"});
            ret.height = ret.input.length / ret.width;
            return ret;
        }
        if (recipe instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe r = (ShapelessOreRecipe)recipe;
            ShapelessAromicRecipe ret = new ShapelessAromicRecipe(r.func_77571_b(), r.getInput().toArray());
            return ret;
        }
        throw new IllegalArgumentException("Unsupported conversion recipe. " + recipe.func_77571_b().toString() + " " + recipe.getClass());
    }

    public static void hideRecipe(IRecipe recipe) {
        IAromicRecipe arecipe = RecipeUtil.createAromicRecipeFrom(recipe);
        arecipe.setHidden(true);
        if (recipe != arecipe) {
            RecipeUtil.unregisterRecipe(recipe);
            GameRegistry.addRecipe((IRecipe)arecipe);
        }
    }
}

