/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.unidict.MetaItem;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.helper.RecipeHelper;
import wanion.unidict.recipe.IRecipeResearcher;
import wanion.unidict.resource.ResourceHandler;

public final class VanillaRecipeResearcher
implements IRecipeResearcher<ShapedRecipes, ShapelessRecipes> {
    @Override
    public int getShapedRecipeKey(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler) {
        TIntList recipeKeys = MetaItem.getList(((ShapedRecipes)recipe).field_77574_d, resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Override
    public int getShapelessRecipeKey(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler) {
        TIntList recipeKeys = MetaItem.getList(((ShapelessRecipes)recipe).field_77579_b.toArray(), resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Override
    @Nonnull
    public List<Class<? extends ShapedRecipes>> getShapedRecipeClasses() {
        return Collections.singletonList(ShapedRecipes.class);
    }

    @Override
    @Nonnull
    public List<Class<? extends ShapelessRecipes>> getShapelessRecipeClasses() {
        return Collections.singletonList(ShapelessRecipes.class);
    }

    @Override
    @Nonnull
    public ShapedOreRecipe getNewShapedRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        Object[] newRecipeInputs = new Object[9];
        ItemStack[] recipeInputs = ((ShapedRecipes)recipe).field_77574_d;
        int i = 0;
        for (int x = 0; x < ((ShapedRecipes)recipe).field_77576_b; ++x) {
            for (int y = 0; y < ((ShapedRecipes)recipe).field_77577_c; ++y) {
                ItemStack input;
                String bufferOreName;
                newRecipeInputs[x * 3 + y] = (bufferOreName = resourceHandler.getContainerName(input = recipeInputs[i++])) != null ? bufferOreName : input;
            }
        }
        return new ShapedOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape(newRecipeInputs));
    }

    @Override
    @Nonnull
    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        Object[] newRecipeInputs = new Object[9];
        List recipeInputs = ((ShapelessRecipes)recipe).field_77579_b;
        for (int i = 0; i < recipeInputs.size(); ++i) {
            String bufferOreName = resourceHandler.getContainerName((ItemStack)recipeInputs.get(i));
            newRecipeInputs[i] = bufferOreName != null ? bufferOreName : recipeInputs.get(i);
        }
        return new ShapedOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape(newRecipeInputs));
    }

    @Override
    @Nonnull
    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        ArrayList inputs = new ArrayList();
        ((ShapelessRecipes)recipe).field_77579_b.forEach(itemStack -> {
            if (itemStack != null) {
                String bufferOreName = uniOreDictionary.getName(itemStack);
                inputs.add(bufferOreName != null ? bufferOreName : itemStack);
            }
        });
        return new ShapelessOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), inputs.toArray());
    }

    @Override
    @Nonnull
    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        ArrayList<String> inputs = new ArrayList<String>();
        for (ItemStack itemStack : ((ShapedRecipes)recipe).field_77574_d) {
            if (itemStack == null) continue;
            String bufferOreName = uniOreDictionary.getName(itemStack);
            inputs.add(bufferOreName != null ? bufferOreName : itemStack);
        }
        return new ShapelessOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), inputs.toArray());
    }
}

