/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.network.IGuiReturnHandler;
import buildcraft.core.lib.network.Packet;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketGuiReturn
extends Packet {
    private EntityPlayer sender;
    private IGuiReturnHandler obj;
    private byte[] extraData;

    public PacketGuiReturn() {
    }

    public PacketGuiReturn(EntityPlayer sender) {
        this.sender = sender;
    }

    public PacketGuiReturn(IGuiReturnHandler obj) {
        this.obj = obj;
        this.extraData = null;
    }

    public PacketGuiReturn(IGuiReturnHandler obj, byte[] extraData) {
        this.obj = obj;
        this.extraData = extraData;
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeInt(this.obj.getWorld().field_73011_w.field_76574_g);
        if (this.obj instanceof TileEntity) {
            TileEntity tile = (TileEntity)this.obj;
            data.writeBoolean(true);
            data.writeInt(tile.field_145851_c);
            data.writeInt(tile.field_145848_d);
            data.writeInt(tile.field_145849_e);
        } else if (this.obj instanceof Entity) {
            Entity entity = (Entity)this.obj;
            data.writeBoolean(false);
            data.writeInt(entity.func_145782_y());
        } else {
            return;
        }
        this.obj.writeGuiData(data);
        if (this.extraData != null) {
            data.writeBytes(this.extraData);
        }
    }

    @Override
    public void readData(ByteBuf data) {
        int dim = data.readInt();
        WorldServer world = DimensionManager.getWorld((int)dim);
        boolean tileReturn = data.readBoolean();
        if (tileReturn) {
            int z;
            int y;
            int x = data.readInt();
            TileEntity t = world.func_147438_o(x, y = data.readInt(), z = data.readInt());
            if (t instanceof IGuiReturnHandler) {
                ((IGuiReturnHandler)t).readGuiData(data, this.sender);
            }
        } else {
            int entityId = data.readInt();
            Entity entity = world.func_73045_a(entityId);
            if (entity instanceof IGuiReturnHandler) {
                ((IGuiReturnHandler)entity).readGuiData(data, this.sender);
            }
        }
    }

    public void sendPacket() {
        BuildCraftCore.instance.sendToServer(this);
    }

    @Override
    public int getID() {
        return 80;
    }
}

