/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceId;
import buildcraft.api.robots.ResourceIdBlock;
import buildcraft.core.lib.utils.BlockScannerExpanding;
import buildcraft.core.lib.utils.BlockScannerRandom;
import buildcraft.core.lib.utils.BlockScannerZoneRandom;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.core.lib.utils.IterableAlgorithmRunner;
import buildcraft.core.lib.utils.PathFindingSearch;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AIRobotSearchBlock
extends AIRobot {
    public BlockIndex blockFound;
    public LinkedList<BlockIndex> path;
    private PathFindingSearch blockScanner = null;
    private IterableAlgorithmRunner blockScannerJob;
    private IBlockFilter pathFound;
    private Iterator<BlockIndex> blockIter;
    private double maxDistanceToEnd;
    private IZone zone;

    public AIRobotSearchBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchBlock(EntityRobotBase iRobot, boolean random, IBlockFilter iPathFound, double iMaxDistanceToEnd) {
        super(iRobot);
        this.pathFound = iPathFound;
        this.zone = iRobot.getZoneToWork();
        if (!random) {
            this.blockIter = new BlockScannerExpanding().iterator();
        } else if (this.zone != null) {
            BlockIndex pos = new BlockIndex((Entity)iRobot);
            this.blockIter = new BlockScannerZoneRandom(pos.x, pos.y, pos.z, iRobot.field_70170_p.field_73012_v, this.zone).iterator();
        } else {
            this.blockIter = new BlockScannerRandom(iRobot.field_70170_p.field_73012_v, 64).iterator();
        }
        this.blockFound = null;
        this.path = null;
        this.maxDistanceToEnd = iMaxDistanceToEnd;
    }

    @Override
    public void start() {
        this.blockScanner = new PathFindingSearch(this.robot.field_70170_p, new BlockIndex((Entity)this.robot), this.blockIter, this.pathFound, this.maxDistanceToEnd, 96.0f, this.zone);
        this.blockScannerJob = new IterableAlgorithmRunner(this.blockScanner);
        this.blockScannerJob.start();
    }

    @Override
    public void update() {
        if (this.blockScannerJob == null) {
            this.abort();
            return;
        }
        if (this.blockScannerJob.isDone()) {
            this.path = this.blockScanner.getResult();
            if (this.path != null && this.path.size() > 0) {
                this.path.removeLast();
                this.blockFound = this.blockScanner.getResultTarget();
            } else {
                this.path = null;
            }
            this.terminate();
        }
    }

    @Override
    public void end() {
        if (this.blockScannerJob != null) {
            this.blockScannerJob.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.blockFound != null;
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.func_74782_a("blockFound", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = new BlockIndex(nbt.func_74775_l("blockFound"));
        }
    }

    public boolean takeResource() {
        boolean taken = false;
        if (this.robot.getRegistry().take((ResourceId)new ResourceIdBlock(this.blockFound), this.robot)) {
            taken = true;
        }
        this.unreserve();
        return taken;
    }

    public void unreserve() {
        this.blockScanner.unreserve(this.blockFound);
    }

    @Override
    public int getEnergyCost() {
        return 2;
    }
}

