/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.BlockDimPos;
import ftb.lib.EntityPos;
import ftb.lib.FTBLib;
import ftb.lib.LMDimUtils;
import ftb.lib.LMNBTUtils;
import ftb.lib.api.item.StringIDInvLoader;
import ftb.lib.api.notification.ClickAction;
import ftb.lib.api.notification.MouseAction;
import ftb.lib.api.notification.Notification;
import ftb.utils.api.EventLMPlayerServer;
import ftb.utils.mod.FTBU;
import ftb.utils.mod.client.FTBUClickAction;
import ftb.utils.mod.handlers.FTBUChunkEventHandler;
import ftb.utils.net.MessageAreaUpdate;
import ftb.utils.net.MessageLMPlayerUpdate;
import ftb.utils.world.LMPlayer;
import ftb.utils.world.LMPlayerClient;
import ftb.utils.world.LMPlayerStats;
import ftb.utils.world.LMWorld;
import ftb.utils.world.LMWorldServer;
import ftb.utils.world.PersonalSettings;
import ftb.utils.world.Warps;
import ftb.utils.world.claims.ChunkType;
import ftb.utils.world.claims.ClaimedChunk;
import ftb.utils.world.ranks.Rank;
import ftb.utils.world.ranks.RankConfig;
import ftb.utils.world.ranks.Ranks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import latmod.lib.ByteCount;
import latmod.lib.ByteIOStream;
import latmod.lib.IntList;
import latmod.lib.LMUtils;
import net.minecraft.command.CommandException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.FakePlayer;

public class LMPlayerServer
extends LMPlayer {
    public static int lastPlayerID = 0;
    public final LMWorldServer world;
    private final PersonalSettings settings;
    private NBTTagCompound serverData = null;
    public BlockDimPos lastPos;
    public BlockDimPos lastDeath;
    public final LMPlayerStats stats;
    private EntityPlayerMP entityPlayer = null;
    public int lastChunkType = -99;
    public final Warps homes;

    public static final int nextPlayerID() {
        return ++lastPlayerID;
    }

    public static LMPlayerServer get(Object o) throws CommandException {
        LMPlayerServer p = LMWorldServer.inst.getPlayer(o);
        if (p == null || p.isFake()) {
            throw new PlayerNotFoundException();
        }
        return p;
    }

    public LMPlayerServer(LMWorldServer w, int i, GameProfile gp) {
        super(i, gp);
        this.world = w;
        this.settings = new PersonalSettings();
        this.stats = new LMPlayerStats();
        this.homes = new Warps();
    }

    @Override
    public LMWorld getWorld() {
        return this.world;
    }

    public Side getSide() {
        return Side.SERVER;
    }

    public boolean isOnline() {
        return this.entityPlayer != null;
    }

    @Override
    public LMPlayerServer toPlayerMP() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LMPlayerClient toPlayerSP() {
        return null;
    }

    public EntityPlayerMP getPlayer() {
        return this.entityPlayer;
    }

    public void setPlayer(EntityPlayerMP ep) {
        this.entityPlayer = ep;
    }

    @Override
    public PersonalSettings getSettings() {
        return this.settings;
    }

    public boolean isFake() {
        return this.getPlayer() instanceof FakePlayer;
    }

    public void sendUpdate() {
        new EventLMPlayerServer.UpdateSent(this).post();
        if (this.isOnline()) {
            new MessageLMPlayerUpdate(this, true).sendTo(this.getPlayer());
        }
        for (EntityPlayerMP ep : FTBLib.getAllOnlinePlayers((EntityPlayerMP)this.getPlayer())) {
            new MessageLMPlayerUpdate(this, false).sendTo(ep);
        }
    }

    public boolean isOP() {
        return FTBLib.isOP((GameProfile)this.getProfile());
    }

    public BlockDimPos getPos() {
        EntityPlayerMP ep = this.getPlayer();
        if (ep != null) {
            this.lastPos = new EntityPos((Entity)ep).toLinkedPos();
        }
        return this.lastPos.copy();
    }

    public void getInfo(LMPlayerServer owner, List<IChatComponent> info) {
        this.refreshStats();
        long ms = LMUtils.millis();
        if (!this.equalsPlayer(owner)) {
            boolean raw1 = this.isFriendRaw(owner);
            boolean raw2 = owner.isFriendRaw(this);
            if (raw1 && raw2) {
                IChatComponent c = FTBU.mod.chatComponent("label.friend", new Object[0]);
                c.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                info.add(c);
            } else if (raw1 || raw2) {
                IChatComponent c = FTBU.mod.chatComponent("label.pfriend", new Object[0]);
                c.func_150256_b().func_150238_a(raw1 ? EnumChatFormatting.GOLD : EnumChatFormatting.BLUE);
                info.add(c);
            }
        }
        new EventLMPlayerServer.CustomInfo(this, info).post();
        if (owner.getRank().config.show_rank.get()) {
            Rank rank = this.getRank();
            ChatComponentText rankC = new ChatComponentText("[" + rank.getID() + "]");
            rankC.func_150256_b().func_150238_a((EnumChatFormatting)rank.color.get());
            info.add((IChatComponent)rankC);
        }
        this.stats.getInfo(this, info, ms);
    }

    public void refreshStats() {
        if (this.isOnline()) {
            this.stats.refresh(this, false);
            this.getPos();
        }
    }

    public void readFromServer(NBTTagCompound tag) {
        int dim;
        double z;
        double y;
        double x;
        this.friends.clear();
        this.friends.addAll(tag.func_74759_k("Friends"));
        this.commonPublicData = tag.func_74775_l("CustomData");
        this.commonPrivateData = tag.func_74775_l("CustomPrivateData");
        StringIDInvLoader.readItemsFromNBT((ItemStack[])this.lastArmor, (NBTTagCompound)tag, (String)"LastItems");
        this.stats.readFromNBT(tag.func_74775_l("Stats"));
        NBTTagCompound nBTTagCompound = this.serverData = tag.func_74764_b("ServerData") ? tag.func_74775_l("ServerData") : null;
        if (tag.func_74764_b("LastPos")) {
            if (tag.func_150299_b("LastPos") == 11) {
                this.lastPos = new BlockDimPos(tag.func_74759_k("LastPos"));
            } else {
                x = tag.func_74769_h("X");
                y = tag.func_74769_h("Y");
                z = tag.func_74769_h("Z");
                dim = tag.func_74762_e("D");
                this.lastPos = new EntityPos(x, y, z, dim).toLinkedPos();
            }
        } else {
            this.lastPos = null;
        }
        if (tag.func_74764_b("LastDeath")) {
            if (tag.func_150299_b("LastDeath") == 11) {
                this.lastDeath = new BlockDimPos(tag.func_74759_k("LastDeath"));
            } else {
                x = tag.func_74769_h("X");
                y = tag.func_74769_h("Y");
                z = tag.func_74769_h("Z");
                dim = tag.func_74762_e("D");
                this.lastDeath = new EntityPos(x, y, z, dim).toLinkedPos();
            }
        } else {
            this.lastDeath = null;
        }
        NBTTagCompound settingsTag = tag.func_74775_l("Settings");
        this.settings.readFromServer(settingsTag);
        this.renderBadge = settingsTag.func_74764_b("Badge") ? settingsTag.func_74767_n("Badge") : true;
        this.homes.readFromNBT(tag, "Homes");
    }

    public void writeToServer(NBTTagCompound tag) {
        this.refreshStats();
        if (!this.friends.isEmpty()) {
            tag.func_74783_a("Friends", this.friends.toArray());
        }
        if (this.commonPublicData != null && !this.commonPublicData.func_82582_d()) {
            tag.func_74782_a("CustomData", (NBTBase)this.commonPublicData);
        }
        if (this.commonPrivateData != null && !this.commonPrivateData.func_82582_d()) {
            tag.func_74782_a("CustomPrivateData", (NBTBase)this.commonPrivateData);
        }
        StringIDInvLoader.writeItemsToNBT((ItemStack[])this.lastArmor, (NBTTagCompound)tag, (String)"LastItems");
        if (this.serverData != null && !this.serverData.func_82582_d()) {
            tag.func_74782_a("ServerData", (NBTBase)this.serverData);
        }
        if (this.lastPos != null) {
            tag.func_74783_a("LastPos", this.lastPos.toIntArray());
        }
        if (this.lastDeath != null) {
            tag.func_74783_a("LastDeath", this.lastDeath.toIntArray());
        }
        NBTTagCompound statsTag = new NBTTagCompound();
        this.stats.writeToNBT(statsTag);
        tag.func_74782_a("Stats", (NBTBase)statsTag);
        NBTTagCompound settingsTag = new NBTTagCompound();
        this.settings.writeToServer(settingsTag);
        settingsTag.func_74757_a("Badge", this.renderBadge);
        tag.func_74782_a("Settings", (NBTBase)settingsTag);
        this.homes.writeToNBT(tag, "Homes");
    }

    public void writeToNet(ByteIOStream io, boolean self) {
        this.refreshStats();
        new EventLMPlayerServer.DataSaved(this).post();
        Rank rank = this.getRank();
        io.writeBoolean(this.isOnline());
        io.writeBoolean(this.renderBadge);
        io.writeIntArray(this.friends.toArray(), ByteCount.SHORT);
        IntList otherFriends = new IntList();
        for (LMPlayerServer p : this.world.playerMap.values()) {
            if (!p.friends.contains(this.getPlayerID())) continue;
            otherFriends.add(p.getPlayerID());
        }
        io.writeIntArray(otherFriends.toArray(), ByteCount.SHORT);
        LMNBTUtils.writeTag((ByteIOStream)io, (NBTTagCompound)this.commonPublicData);
        if (self) {
            this.settings.writeToNet(io);
            LMNBTUtils.writeTag((ByteIOStream)io, (NBTTagCompound)this.commonPrivateData);
            io.writeShort(this.getClaimedChunks());
            io.writeShort(this.getLoadedChunks(true));
            io.writeShort(rank.config.max_claims.get());
            io.writeShort(rank.config.max_loaded_chunks.get());
        }
    }

    public void onPostLoaded() {
        new EventLMPlayerServer.DataLoaded(this).post();
    }

    public void checkNewFriends() {
        if (this.isOnline()) {
            ArrayList<String> requests = new ArrayList<String>();
            for (LMPlayerServer p : this.world.playerMap.values()) {
                if (!p.isFriendRaw(this) || this.isFriendRaw(p)) continue;
                requests.add(p.getProfile().getName());
            }
            if (requests.size() > 0) {
                IChatComponent cc = FTBU.mod.chatComponent("label.new_friends", new Object[0]);
                cc.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                Notification n = new Notification("new_friend_requests", cc, 6000);
                n.setDesc(FTBU.mod.chatComponent("label.new_friends_click", new Object[0]));
                MouseAction mouse = new MouseAction();
                mouse.click = new ClickAction(FTBUClickAction.FRIEND_ADD_ALL, null);
                Collections.sort(requests, null);
                for (String s : requests) {
                    mouse.hover.add(new ChatComponentText(s));
                }
                n.setMouseAction(mouse);
                FTBLib.notifyPlayer((EntityPlayerMP)this.getPlayer(), (Notification)n);
            }
        }
    }

    public Rank getRank() {
        return Ranks.getRankFor(this);
    }

    public void claimChunk(int dim, int cx, int cz) {
        RankConfig c = this.getRank().config;
        if (c.dimension_blacklist.get().contains(dim)) {
            return;
        }
        int max = c.max_claims.get();
        if (max == 0) {
            return;
        }
        if (this.getClaimedChunks() >= max) {
            return;
        }
        ChunkType t = this.world.claimedChunks.getType(dim, cx, cz);
        if (!t.isClaimed() && t.isChunkOwner(this) && this.world.claimedChunks.put(new ClaimedChunk(this.getPlayerID(), dim, cx, cz))) {
            this.sendUpdate();
        }
    }

    public void unclaimChunk(int dim, int cx, int cz) {
        if (this.world.claimedChunks.getType(dim, cx, cz).isChunkOwner(this)) {
            this.setLoaded(dim, cx, cz, false);
            this.world.claimedChunks.remove(dim, cx, cz);
            this.sendUpdate();
        }
    }

    public void unclaimAllChunks(Integer dim) {
        List<ClaimedChunk> list = this.world.claimedChunks.getChunks(this, dim);
        int size0 = list.size();
        if (size0 == 0) {
            return;
        }
        for (int i = 0; i < size0; ++i) {
            ClaimedChunk c = list.get(i);
            this.setLoaded(c.dim, c.posX, c.posZ, false);
            this.world.claimedChunks.remove(c.dim, c.posX, c.posZ);
        }
        this.sendUpdate();
    }

    public int getClaimedChunks() {
        return this.world.claimedChunks.getChunks(this, null).size();
    }

    public int getLoadedChunks(boolean forced) {
        int loaded = 0;
        for (ClaimedChunk c : this.world.claimedChunks.getChunks(this, null)) {
            if (!c.isChunkloaded || forced && !c.isForced) continue;
            ++loaded;
        }
        return loaded;
    }

    public NBTTagCompound getServerData() {
        if (this.serverData == null) {
            this.serverData = new NBTTagCompound();
        }
        return this.serverData;
    }

    public void setLoaded(int dim, int cx, int cz, boolean flag) {
        ClaimedChunk chunk = this.world.claimedChunks.getChunk(dim, cx, cz);
        if (chunk == null) {
            return;
        }
        if (flag != chunk.isChunkloaded && this.equalsPlayer(chunk.getOwnerS())) {
            if (flag) {
                RankConfig c = this.getRank().config;
                if (c.dimension_blacklist.get().contains(dim)) {
                    return;
                }
                int max = c.max_loaded_chunks.get();
                if (max == 0) {
                    return;
                }
                if (this.getLoadedChunks(false) >= max) {
                    return;
                }
            }
            chunk.isChunkloaded = flag;
            FTBUChunkEventHandler.instance.markDirty(LMDimUtils.getWorld((int)dim));
            if (this.getPlayer() != null) {
                new MessageAreaUpdate(this, cx, cz, dim, 1, 1).sendTo(this.getPlayer());
            }
            this.sendUpdate();
        }
    }

    @Override
    public boolean allowInteractSecure() {
        return this.getPlayer() != null && this.isOP();
    }

    public StatisticsFile getStatFile(boolean force) {
        if (this.isOnline()) {
            return this.getPlayer().func_147099_x();
        }
        return force ? FTBLib.getServer().func_71203_ab().func_152602_a((EntityPlayer)new FakePlayer(FTBLib.getServerWorld(), this.getProfile())) : null;
    }
}

