/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CFMalwareScanner {
    private static final byte[][] SIGNATURES = new byte[][]{{56, 84, 89, 4, 16, 53, 84, 89, 5, 16, 46, 84, 89, 6, 16, 50, 84, 89, 7, 16, 49, 84, 89, 8, 16, 55, 84, 89, 16, 6, 16, 46, 84, 89, 16, 7, 16, 49, 84, 89, 16, 8, 16, 52, 84, 89, 16, 9, 16, 52, 84, 89, 16, 10, 16, 46, 84, 89, 16, 11, 16, 49, 84, 89, 16, 12, 16, 51, 84, 89, 16, 13, 16, 48, 84, -73}, {104, 84, 89, 4, 16, 116, 84, 89, 5, 16, 116, 84, 89, 6, 16, 112, 84, 89, 7, 16, 58, 84, 89, 8, 16, 47, 84, 89, 16, 6, 16, 47, 84, 89, 16, 7, 16, 102, 84, 89, 16, 8, 16, 105, 84, 89, 16, 9, 16, 108, 84, 89, 16, 10, 16, 101, 84, 89, 16, 11, 16, 115, 84, 89, 16, 12, 16, 46, 84, 89, 16, 10, 16, 115, 84, 89, 16, 14, 16, 107, 84, 89, 16, 15, 16, 121, 84, 89, 16, 16, 16, 114, 84, 89, 16, 17, 16, 97, 84, 89, 16, 18, 16, 103, 84, 89, 16, 19, 16, 101, 84, 89, 16, 20, 16, 46, 84, 89, 16, 21, 16, 100}, {45, 84, 89, 4, 16, 106, 84, 89, 5, 16, 97, 84, 89, 6, 16, 114}};
    private static boolean DEBUG = false;

    public static void premain(String agentArgs, Instrumentation inst) {
        DEBUG = "debug".equals(agentArgs);
        try {
            CFMalwareScanner.scanFolder(new File("./").getAbsoluteFile());
        }
        catch (Throwable ex) {
            System.err.println("Error whilst trying to scan for CF Malware.");
            ex.printStackTrace(System.err);
        }
    }

    private static void scanFolder(File folder) throws IOException {
        File[] files;
        if (DEBUG) {
            System.out.println("Scanning folder: " + folder);
        }
        if ((files = folder.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    CFMalwareScanner.scanFolder(file);
                }
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                if (DEBUG) {
                    System.out.println("Scanning file: " + file);
                }
                if (!CFMalwareScanner.scanFile(file)) continue;
                if (DEBUG) {
                    System.out.println("Found malware!");
                }
                CFMalwareScanner.malwareFound(file);
            }
            catch (IOException ex) {
                if (DEBUG) {
                    System.err.println("Error whilst trying to scan file for Malware. '" + file + "'.");
                }
                ex.printStackTrace(System.err);
            }
        }
    }

    private static void malwareFound(File file) {
        System.err.println("###########################################");
        System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        System.err.println("###########################################");
        System.err.println("Found malware! The following file is suspected to be a malicious mod from the fractureiser malware package!");
        System.err.println("The mod will disabled!");
        System.err.println(file.toString());
        System.err.println("###########################################");
        System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        System.err.println("###########################################");
        if (!file.renameTo(new File(file.getParentFile(), file.getName() + ".compromised"))) {
            System.err.println("Failed to rename mod file! Exiting VM.");
            System.exit(1);
        }
    }

    private static boolean scanFile(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            for (ZipEntry zipEntry : CFMalwareScanner.iterable(zipFile.entries())) {
                if (!zipEntry.getName().endsWith(".class") || !CFMalwareScanner.scanClass(CFMalwareScanner.readAll(zipFile.getInputStream(zipEntry)))) continue;
                System.out.println("Class " + zipEntry.getName() + " in " + file.getName() + " is infected");
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static boolean scanClass(byte[] bytes) {
        for (byte[] signature : SIGNATURES) {
            int i2 = 0;
            for (int i = 0; i < bytes.length; ++i) {
                if (signature[i2] == bytes[i]) {
                    if (++i2 != signature.length) continue;
                    return true;
                }
                i2 = 0;
            }
        }
        return false;
    }

    private static byte[] readAll(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) > 0) {
            bos.write(buffer, 0, len);
        }
        return bos.toByteArray();
    }

    public static <E> Iterable<E> iterable(final Enumeration<E> enumeration) {
        return () -> new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public E next() {
                return enumeration.nextElement();
            }
        };
    }
}

