/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.commands;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.QuestingData;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.commands.CommandBase;
import hardcorequesting.parsing.QuestAdapter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.reputation.Reputation;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class CommandLoad
extends CommandBase {
    private static final Pattern JSON = Pattern.compile(".*\\.json$", 2);
    private static final Pattern BAGS = Pattern.compile(".*bags\\.json$", 2);
    private static final Pattern REPUTATIONS = Pattern.compile(".*reputations\\.json$", 2);
    private static final FileFilter QUEST_SET_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return JSON.matcher(pathname.getName()).find() && !REPUTATIONS.matcher(pathname.getName()).find() && !BAGS.matcher(pathname.getName()).find();
        }
    };

    public CommandLoad() {
        super("load", "all");
    }

    @Override
    public void handleCommand(ICommandSender sender, String[] arguments) {
        try {
            if (arguments.length == 1 && arguments[0].equals("all")) {
                this.loadReputation(sender, CommandLoad.getFile("reputations"));
                for (File file : this.getPossibleFiles(QUEST_SET_FILTER)) {
                    this.loadSet(sender, file);
                }
                QuestAdapter.postLoad();
            } else if (arguments.length == 1 && arguments[0].equals("bags")) {
                this.loadBags(sender, CommandLoad.getFile("bags"));
            } else if (arguments.length > 0) {
                String file = this.getCombinedArgs(arguments);
                this.loadSet(sender, CommandLoad.getFile(file));
                QuestAdapter.postLoad();
            }
            Quest.FILE_HELPER.saveData(null);
        }
        catch (IOException e) {
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }

    private File[] getPossibleFiles(FileFilter filter) {
        return new File(HardcoreQuesting.configDir + File.separator + "QuestFiles").listFiles(filter);
    }

    private void loadSet(ICommandSender sender, File file) {
        if (!file.exists()) {
            throw new CommandException("hqm.command.fileNotFound", new Object[0]);
        }
        try {
            if (sender instanceof EntityPlayer) {
                HardcoreQuesting.setPlayer((EntityPlayer)sender);
            }
            JsonReader reader = new JsonReader((Reader)new FileReader(file));
            QuestSet set = (QuestSet)GSON.fromJson(reader, QuestSet.class);
            reader.close();
            if (set == null) {
                throw new CommandException("hqm.command.loadFailed", new Object[0]);
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"hqm.command.loadSuccess", (Object[])new Object[]{set.getName()})));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException("hqm.command.loadFailed", new Object[0]);
        }
    }

    private void loadReputation(ICommandSender sender, File file) {
        if (!file.exists()) {
            throw new CommandException("hqm.command.fileNotFound", new Object[0]);
        }
        try {
            if (sender instanceof EntityPlayer) {
                HardcoreQuesting.setPlayer((EntityPlayer)sender);
            }
            JsonReader reader = new JsonReader((Reader)new FileReader(file));
            List reputations = (List)GSON.fromJson(reader, Reputation.getReputationList().getClass());
            reader.close();
            Reputation.getReputationList().clear();
            for (Reputation reputation : reputations) {
                if (reputation != null) {
                    Reputation.getReputationList().add(reputation);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"hqm.command.loadSuccess", (Object[])new Object[]{"Reputation: " + reputation.getName()})));
                    continue;
                }
                throw new CommandException("hqm.command.loadFailed", new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException("hqm.command.loadFailed", new Object[0]);
        }
    }

    private void loadBags(ICommandSender sender, File file) {
        if (!file.exists()) {
            throw new CommandException("hqm.command.fileNotFound", new Object[0]);
        }
        try {
            if (sender instanceof EntityPlayer) {
                HardcoreQuesting.setPlayer((EntityPlayer)sender);
            }
            JsonReader reader = new JsonReader((Reader)new FileReader(file));
            List bags = (List)GSON.fromJson(reader, new TypeToken<List<GroupTier>>(){}.getType());
            reader.close();
            if (bags == null) {
                throw new CommandException("hqm.command.loadFailed", new Object[0]);
            }
            GroupTier.getTiers().clear();
            GroupTier.getTiers().addAll(bags);
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"hqm.command.loadSuccess", (Object[])new Object[]{"Bags"})));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException("hqm.command.loadFailed", new Object[0]);
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        String text = this.getCombinedArgs(args);
        Pattern pattern = Pattern.compile("^" + Pattern.quote(text), 2);
        List<String> results = super.addTabCompletionOptions(sender, args);
        for (File file : this.getPossibleFiles(QUEST_SET_FILTER)) {
            if (!pattern.matcher(file.getName()).find()) continue;
            results.add(file.getName().replace(".json", ""));
        }
        return results;
    }

    @Override
    public boolean isVisible(ICommandSender sender) {
        return Quest.isEditing && QuestingData.hasData(sender.func_70005_c_()) && super.isVisible(sender);
    }

    @Override
    public int[] getSyntaxOptions(ICommandSender sender) {
        return new int[]{0, 1, 2};
    }
}

