/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network;

import cpw.mods.fml.common.FMLLog;
import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.PacketHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;

public class DataReader {
    private InputStream stream;
    private int byteBuffer;
    private int bitCountBuffer;
    private FileVersion version;
    private static final double LOG_2 = Math.log10(2.0);

    DataReader(byte[] data) {
        this.stream = new ByteArrayInputStream(data);
        this.version = QuestingData.FILE_VERSION;
    }

    DataReader(InputStream stream) {
        this.stream = stream;
        this.version = QuestingData.FILE_VERSION;
    }

    public int readByte() {
        return this.readData(DataBitHelper.BYTE);
    }

    public boolean readBoolean() {
        return this.readData(DataBitHelper.BOOLEAN) != 0;
    }

    public int readData(DataBitHelper bitCount) {
        return this.readData(bitCount.getBitCount(this.version));
    }

    public int readData(int bitCount) {
        int data = 0;
        int readBits = 0;
        while (true) {
            int bitsLeft;
            if (this.bitCountBuffer >= (bitsLeft = bitCount - readBits)) {
                data |= (this.byteBuffer & PacketHandler.BIT_MASK[bitsLeft]) << readBits;
                this.byteBuffer >>>= bitsLeft;
                this.bitCountBuffer -= bitsLeft;
                readBits += bitsLeft;
                break;
            }
            data |= this.byteBuffer << readBits;
            readBits += this.bitCountBuffer;
            try {
                this.byteBuffer = this.stream.read();
            }
            catch (IOException ignored) {
                this.byteBuffer = 0;
            }
            this.bitCountBuffer = 8;
        }
        return data;
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String readString(DataBitHelper bits) {
        int length = this.readData(bits);
        if (length == 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.readByte();
        }
        return new String(bytes);
    }

    public NBTTagCompound readNBT() {
        if (this.readBoolean()) {
            byte[] bytes = new byte[this.readData(DataBitHelper.NBT_LENGTH)];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)this.readByte();
            }
            try {
                return CompressedStreamTools.func_152457_a((byte[])bytes, (NBTSizeTracker)new NBTSizeTracker(2087152L));
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public boolean doesUnderlyingStreamHasMoreThanAByteOfData() {
        try {
            return this.stream.available() > 0;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public FileVersion readVersion() {
        this.version = FileVersion.values()[this.readByte()];
        return this.version;
    }

    public ItemStack readItemStack(boolean useSize) {
        return this.readRawItemStack(false, useSize);
    }

    public ItemStack readAndFixItemStack(boolean useSize) {
        return this.readRawItemStack(true, useSize);
    }

    private ItemStack readRawItemStack(boolean fix, boolean useSize) {
        if (fix && this.version.lacks(FileVersion.NO_ITEM_IDS_FIX)) {
            NBTTagCompound compound = this.readNBT();
            if (compound != null) {
                return ItemStack.func_77949_a((NBTTagCompound)compound);
            }
            return null;
        }
        Item item = this.readItem();
        int size = useSize ? this.readData(DataBitHelper.SHORT) : 1;
        int dmg = this.readData(DataBitHelper.SHORT);
        NBTTagCompound compound = this.readNBT();
        ItemStack itemStack = new ItemStack(item, size, dmg);
        itemStack.func_77982_d(compound);
        return itemStack;
    }

    public Item readItem() {
        if (this.version.contains(FileVersion.NO_ITEM_IDS)) {
            String readString = this.readString(DataBitHelper.SHORT);
            if (readString == null) {
                FMLLog.log((String)"HQM", (Level)Level.ERROR, (String)"Attempted to read an item that doesn't exist %s", (Object[])new Object[]{readString});
                return null;
            }
            Object obj = Item.field_150901_e.func_82594_a(readString);
            if (obj == null) {
                FMLLog.log((String)"HQM", (Level)Level.ERROR, (String)"Attempted to read an item that doesn't exist %s", (Object[])new Object[]{readString});
                return null;
            }
            if (obj instanceof Item) {
                return (Item)obj;
            }
        } else {
            this.readData(DataBitHelper.SHORT);
        }
        return null;
    }

    public <T extends Enum> T readEnum(Class<T> clazz) {
        try {
            Object[] values = (Object[])clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            int length = values.length;
            if (length == 0) {
                return null;
            }
            int bitCount = (int)(Math.log10(length) / LOG_2) + 1;
            int val = this.readData(bitCount);
            return (T)((Enum)values[val]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

