/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.DeathStats;
import hardcorequesting.OPBookHelper;
import hardcorequesting.QuestingData;
import hardcorequesting.Team;
import hardcorequesting.TeamStats;
import hardcorequesting.client.interfaces.GuiEditMenuItem;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.GuiReward;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketId;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestTask;
import hardcorequesting.tileentity.IBlockSync;
import hardcorequesting.tileentity.TileEntityTracker;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;

public class PacketHandler {
    public static final double BLOCK_UPDATE_RANGE = 128.0;
    public static final int BLOCK_UPDATE_BUFFER_DISTANCE = 5;
    public static final int[] BIT_MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private static final Map<String, String> nameOverride = new HashMap<String, String>();
    private static final Map<String, String> nameOverrideReversed = new HashMap<String, String>();
    private static String clientNameOverride;
    private int missingPackets;
    private byte[][] data;

    public static DataWriter getWriter(PacketId id) {
        DataWriter dw = new DataWriter();
        dw.writeByte(1);
        dw.writeData((int)id.getId(), DataBitHelper.PACKET_ID);
        return dw;
    }

    public static void add(EntityPlayer player, String name) {
        String playerName;
        if (name != null && !(playerName = player.func_146103_bH().getName()).equals(name)) {
            nameOverride.put(playerName, name);
            nameOverrideReversed.put(name, playerName);
            return;
        }
        PacketHandler.setBookState(player, true);
    }

    public static void remove(EntityPlayer player) {
        String name = nameOverride.remove(player.func_146103_bH().getName());
        if (name != null) {
            nameOverrideReversed.remove(name);
        } else {
            PacketHandler.setBookState(player, false);
        }
    }

    public static String getOverriddenName(String name) {
        return clientNameOverride != null ? clientNameOverride : nameOverride.get(name);
    }

    public static boolean canOverride(String name) {
        return !nameOverrideReversed.containsKey(name);
    }

    public static String getOverriddenBy(String name) {
        return nameOverrideReversed.get(name);
    }

    private static void setBookState(EntityPlayer player, boolean state) {
        Team team = QuestingData.getQuestingData(player).getTeam();
        for (Team.PlayerEntry entry : team.getPlayers()) {
            if (!entry.isInTeam() || !entry.getName().equals(QuestingData.getUserName(player))) continue;
            entry.setBookOpen(state);
            break;
        }
    }

    public static void reset() {
        nameOverride.clear();
        nameOverrideReversed.clear();
        clientNameOverride = null;
    }

    public static void closeInterface() {
        PacketHandler.sendToServer(PacketHandler.getWriter(PacketId.CLOSE_INTERFACE));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.onPacketData(event.packet.payload().array(), (EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.onPacketData(event.packet.payload().array(), (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onPacketData(byte[] incomingData, EntityPlayer player, boolean onServer) {
        try (DataReader dr = null;){
            dr = this.getDataReaderForPacket(incomingData);
            if (dr == null) {
                return;
            }
            dr.readByte();
            PacketId id = PacketId.getFromId((byte)dr.readData(DataBitHelper.PACKET_ID));
            switch (id) {
                case OPEN_INTERFACE: {
                    boolean isOpBook = dr.readBoolean();
                    if (isOpBook) {
                        String openName = dr.readString(DataBitHelper.NAME_LENGTH);
                        clientNameOverride = openName.equals(player.func_146103_bH().getName()) ? null : openName;
                    }
                    QuestingData.getQuestingData(player).receiveDataFromServer(dr);
                    GuiQuestBook.displayGui(player, isOpBook);
                    return;
                }
                case QUEST_DATA: {
                    this.handleQuestData(player, dr);
                    return;
                }
                case TASK_REQUEST: {
                    this.handleTaskRequest(player, dr);
                    return;
                }
                case CLAIM_REWARD: {
                    this.handleRewardClaim(player, dr);
                    return;
                }
                case SELECT_TASK: {
                    this.handleSelectTask(player, dr);
                    return;
                }
                case SOUND: {
                    SoundHandler.handleSoundPacket(dr);
                    return;
                }
                case LORE: {
                    SoundHandler.handleLorePacket(player, dr);
                    return;
                }
                case TEAM: {
                    Team.handlePacket(player, dr, onServer);
                    return;
                }
                case REFRESH_INTERFACE: {
                    QuestingData.getQuestingData(player).receiveDataFromServer(dr);
                    return;
                }
                case CLOSE_INTERFACE: {
                    PacketHandler.remove(player);
                    return;
                }
                case REFRESH_TEAM: {
                    QuestingData.getQuestingData(player).getTeam().onPacket(dr);
                    return;
                }
                case OP_BOOK: {
                    OPBookHelper.handlePacket(player, dr);
                    return;
                }
                case QUEST_SYNC: {
                    QuestLine.receiveServerSync(dr);
                    GuiEditMenuItem.Search.initItems();
                    return;
                }
                case BAG_INTERFACE: {
                    GuiReward.open(player, dr);
                    return;
                }
                case DEATH_STATS_UPDATE: {
                    DeathStats.handlePacket(player, dr);
                    return;
                }
                case TEAM_STATS_UPDATE: {
                    TeamStats.handlePacket(player, dr);
                    return;
                }
                case TRACKER_ACTIVATE: {
                    TileEntityTracker.openInterface(player, dr);
                    return;
                }
                case TRACKER_RESPONSE: {
                    TileEntityTracker.saveToServer(player, dr);
                    return;
                }
                case BLOCK_SYNC: {
                    this.handleBlockSync(player, dr);
                    return;
                }
            }
            return;
        }
    }

    private DataReader getDataReaderForPacket(byte[] incomingData) throws Throwable {
        if (this.missingPackets == 0) {
            byte count = incomingData[0];
            if (count == 1) {
                return new DataReader(incomingData);
            }
            this.missingPackets = incomingData[0];
            if (this.missingPackets < 0) {
                this.missingPackets += 256;
            }
            this.data = new byte[this.missingPackets][];
        }
        this.data[incomingData.length - this.missingPackets--] = incomingData;
        if (this.missingPackets != 0) {
            return null;
        }
        int byteCount = 0;
        for (byte[] bytes : this.data) {
            byteCount += bytes.length;
        }
        byte[] packetData = new byte[byteCount];
        int start = 0;
        for (byte[] bytes : this.data) {
            int len = bytes.length;
            System.arraycopy(bytes, 0, packetData, start, len);
            start += len;
        }
        return new DataReader(packetData);
    }

    private void handleSelectTask(EntityPlayer player, DataReader dr) {
        int questId = dr.readData(DataBitHelper.QUESTS);
        int taskId = dr.readData(DataBitHelper.TASKS);
        Quest quest = Quest.getQuest(questId);
        if (quest != null && taskId >= 0 && taskId < quest.getTasks().size()) {
            QuestingData data = QuestingData.getQuestingData(player);
            data.selectedQuest = questId;
            data.selectedTask = taskId;
        }
    }

    private void handleRewardClaim(EntityPlayer player, DataReader dr) {
        int questId = dr.readData(DataBitHelper.QUESTS);
        Quest quest = Quest.getQuest(questId);
        if (quest != null) {
            quest.claimReward(player, dr);
        }
    }

    private void handleTaskRequest(EntityPlayer player, DataReader dr) {
        int questId = dr.readData(DataBitHelper.QUESTS);
        int taskId = dr.readData(DataBitHelper.TASKS);
        Quest quest = Quest.getQuest(questId);
        if (quest != null && taskId >= 0 && taskId < quest.getTasks().size()) {
            QuestTask task = quest.getTasks().get(taskId);
            task.onUpdate(player, dr);
        }
    }

    private void handleQuestData(EntityPlayer player, DataReader dr) {
        int questId = dr.readData(DataBitHelper.QUESTS);
        Quest quest = Quest.getQuest(questId);
        if (quest != null) {
            quest.preRead(dr.readData(DataBitHelper.PLAYERS), quest.getQuestData(player));
            quest.read(dr, quest.getQuestData(player), QuestingData.FILE_VERSION, true);
        }
    }

    public static void sendToPlayer(String name, DataWriter dw) {
        if (!Quest.isEditing || QuestingData.isSinglePlayer()) {
            PacketHandler.sendToBookPlayer(name, dw);
        }
        dw.close();
    }

    private static void sendToBookPlayer(String name, DataWriter dw) {
        EntityPlayer other;
        String playerName;
        EntityPlayer player;
        if (QuestingData.getQuestingData(name).getTeam().getEntry(name).isBookOpen() && (player = QuestingData.getPlayer(name)) != null) {
            dw.sendToPlayer((EntityPlayerMP)player);
        }
        if ((playerName = nameOverrideReversed.get(name)) != null && (other = QuestingData.getPlayer(playerName)) != null) {
            dw.sendToPlayer((EntityPlayerMP)other);
        }
    }

    public static void sendToRawPlayer(EntityPlayer player, DataWriter dw) {
        if (!Quest.isEditing || QuestingData.isSinglePlayer()) {
            dw.sendToPlayer((EntityPlayerMP)player);
        }
        dw.close();
    }

    public static void sendToAllPlayers(DataWriter dw) {
        if (!Quest.isEditing && !QuestingData.isSinglePlayer()) {
            dw.sendToAllPlayers();
        }
        dw.close();
    }

    public static void sendToServer(DataWriter dw) {
        if (!Quest.isEditing || QuestingData.isSinglePlayer()) {
            dw.sendToServer();
        }
        dw.close();
    }

    public static void sendToAllPlayersWithOpenBook(DataWriter dw) {
        if (!Quest.isEditing || QuestingData.isSinglePlayer()) {
            for (String name : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72369_d()) {
                PacketHandler.sendToBookPlayer(name, dw);
            }
        }
        dw.close();
    }

    public static void sendBlockPacket(IBlockSync block, EntityPlayer player, int id) {
        if (block instanceof TileEntity) {
            DataWriter dw = PacketHandler.getWriter(PacketId.BLOCK_SYNC);
            TileEntity te = (TileEntity)block;
            boolean onServer = !te.func_145831_w().field_72995_K;
            dw.writeData(te.field_145851_c, DataBitHelper.WORLD_COORDINATE);
            dw.writeData(te.field_145848_d, DataBitHelper.WORLD_COORDINATE);
            dw.writeData(te.field_145849_e, DataBitHelper.WORLD_COORDINATE);
            dw.writeData(id, block.infoBitLength());
            block.writeData(dw, player, onServer, id);
            if (!onServer) {
                dw.sendToServer();
            } else if (player != null) {
                dw.sendToPlayer((EntityPlayerMP)player);
            } else {
                dw.sendToAllPlayersAround(te, 128.0);
            }
            dw.close();
        }
    }

    private void handleBlockSync(EntityPlayer player, DataReader dr) {
        int z;
        int y;
        boolean onServer = !player.field_70170_p.field_72995_K;
        int x = dr.readData(DataBitHelper.WORLD_COORDINATE);
        TileEntity te = player.field_70170_p.func_147438_o(x, y = dr.readData(DataBitHelper.WORLD_COORDINATE), z = dr.readData(DataBitHelper.WORLD_COORDINATE));
        if (te instanceof IBlockSync) {
            IBlockSync block = (IBlockSync)te;
            int id = dr.readData(block.infoBitLength());
            block.readData(dr, player, onServer, id);
        }
    }
}

