/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.tileentity;

import hardcorequesting.QuestingData;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestDataTaskItems;
import hardcorequesting.quests.QuestTask;
import hardcorequesting.quests.QuestTaskItemsConsume;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBarrel
extends TileEntity
implements IInventory,
IFluidHandler {
    private static final int SYNC_TIME = 20;
    private int modifiedSyncTimer;
    private String playerName;
    public int selectedQuest;
    public int selectedTask;
    private static final String NBT_PLAYER_NAME = "Player";
    private static final String NBT_QUEST = "Quest";
    private static final String NBT_TASK = "Task";

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        QuestTask task;
        if (resource == null) {
            return 0;
        }
        if (doFill && (task = this.getCurrentTask()) != null && task instanceof QuestTaskItemsConsume && ((QuestTaskItemsConsume)task).increaseFluid(resource.copy(), (QuestDataTaskItems)task.getData(this.playerName), this.playerName) && this.modifiedSyncTimer <= 0) {
            this.modifiedSyncTimer = 20;
        }
        return resource.amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        QuestTask task = this.getCurrentTask();
        if (task != null && task instanceof QuestTaskItemsConsume && ((QuestTaskItemsConsume)task).increaseItems(new ItemStack[]{itemstack}, (QuestDataTaskItems)task.getData(this.playerName), this.playerName) && this.modifiedSyncTimer <= 0) {
            this.modifiedSyncTimer = 20;
        }
    }

    public void func_145845_h() {
        if (this.modifiedSyncTimer > 0 && --this.modifiedSyncTimer == 0) {
            this.doSync();
            this.updateState();
        }
    }

    private void doSync() {
        EntityPlayer player;
        QuestTask task;
        if (!this.field_145850_b.field_72995_K && (task = this.getCurrentTask()) != null && (player = QuestingData.getPlayer(this.playerName)) != null) {
            task.getParent().sendUpdatedDataToTeam(player);
        }
    }

    private void updateState() {
        if (!this.field_145850_b.field_72995_K) {
            boolean oldState;
            EntityPlayer player;
            QuestTask task = this.getCurrentTask();
            boolean state = false;
            if (task != null && (player = QuestingData.getPlayer(this.playerName)) != null) {
                state = !task.isCompleted(player);
            }
            boolean bl = oldState = this.func_145832_p() == 1;
            if (state != oldState) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, state ? 1 : 0, 3);
            }
        }
    }

    public QuestTask getCurrentTask() {
        Quest quest;
        if (this.playerName != null && this.selectedQuest >= 0 && this.selectedQuest < Quest.size() && (quest = Quest.getQuest(this.selectedQuest)) != null && this.selectedTask >= 0 && this.selectedTask < quest.getTasks().size()) {
            return quest.getTasks().get(this.selectedTask);
        }
        return null;
    }

    public String func_145825_b() {
        return "hqm:item_barrel";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void storeSettings(EntityPlayer player) {
        if (this.modifiedSyncTimer > 0) {
            this.modifiedSyncTimer = 0;
            this.doSync();
        }
        this.playerName = QuestingData.getUserName(player);
        QuestingData data = QuestingData.getQuestingData(player);
        this.selectedQuest = data.selectedQuest;
        this.selectedTask = data.selectedTask;
        this.updateState();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_PLAYER_NAME)) {
            this.playerName = compound.func_74779_i(NBT_PLAYER_NAME);
            this.selectedQuest = compound.func_74765_d(NBT_QUEST);
            this.selectedTask = compound.func_74771_c(NBT_TASK);
        } else {
            this.playerName = null;
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.playerName != null) {
            compound.func_74778_a(NBT_PLAYER_NAME, this.playerName);
            compound.func_74777_a(NBT_QUEST, (short)this.selectedQuest);
            compound.func_74774_a(NBT_TASK, (byte)this.selectedTask);
        }
    }

    public String getPlayer() {
        return this.playerName;
    }
}

