/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.lib;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SchematicTileWhitelist
extends SchematicTile {
    private final List<String> whitelistNBT = new ArrayList<String>();
    private final boolean ignoreDrops;

    public SchematicTileWhitelist(String[] whitelist, boolean ignoreDrops) {
        for (String s : whitelist) {
            this.whitelistNBT.add(s);
        }
        this.ignoreDrops = ignoreDrops;
    }

    public SchematicTileWhitelist() {
        this.ignoreDrops = false;
    }

    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        if (this.ignoreDrops) {
            this.storedRequirements = new ItemStack[1];
            this.storedRequirements[0] = new ItemStack(this.block, 1, this.meta);
        } else {
            super.storeRequirements(context, x, y, z);
        }
    }

    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        super.initializeFromObjectAt(context, x, y, z);
        if (this.tileNBT != null && this.whitelistNBT.size() > 0) {
            NBTTagCompound source = this.tileNBT;
            this.tileNBT = new NBTTagCompound();
            this.tileNBT.func_74782_a("id", source.func_74781_a("id"));
            for (String s : this.whitelistNBT) {
                if (!source.func_74764_b(s)) continue;
                this.tileNBT.func_74782_a(s, source.func_74781_a(s));
            }
        }
    }
}

