/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.data.Assets;
import net.minecraft.client.gui.Gui;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiElementVSlider
extends GuiElement {
    private int currentScroll;
    private int maxScroll;
    private boolean wasClicking;
    private boolean isScrolling;
    private boolean mouseOver;

    public GuiElementVSlider(int guiLeft, int guiTop, int xSize, int ySize) {
        super(guiLeft, guiTop, xSize, ySize);
    }

    public void setMaxScroll(int maxScroll) {
        this.maxScroll = maxScroll;
        if (this.currentScroll > maxScroll) {
            this.currentScroll = maxScroll;
        }
    }

    public int getCurrentPos() {
        return this.currentScroll;
    }

    @Override
    public void _handleMouseInput() {
        if (!this.mouseOver) {
            return;
        }
        this.handleMouseScroll();
    }

    public void handleMouseScroll() {
        int input = Mouse.getEventDWheel();
        if (input != 0) {
            if (input > 0) {
                input = 1;
            }
            if (input < 0) {
                input = -1;
            }
            this.currentScroll -= input * 20;
            if (this.currentScroll > this.maxScroll) {
                this.currentScroll = this.maxScroll;
            }
            if (this.currentScroll < 0) {
                this.currentScroll = 0;
            }
        }
    }

    @Override
    public void _renderBackground(float f, int mouseX, int mouseY) {
        this.mouseOver = this.contains(mouseX, mouseY);
        float xScale = (float)this.xSize / 20.0f;
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        boolean isClicking = Mouse.isButtonDown((int)0);
        int slidertop = guiTop + 4;
        int sliderbottom = guiTop + this.ySize - 19;
        float sliderpos = 0.0f;
        if (this.maxScroll == 0) {
            this.currentScroll = 0;
        } else {
            sliderpos = (float)this.currentScroll / (float)this.maxScroll;
        }
        if (sliderpos > 1.0f) {
            sliderpos = 1.0f;
        }
        if (this.currentScroll == 0) {
            sliderpos = 0.0f;
        }
        if (!this.wasClicking && isClicking && this.mouseOver) {
            this.isScrolling = true;
        }
        if (!isClicking) {
            this.isScrolling = false;
        }
        this.wasClicking = isClicking;
        if (this.isScrolling) {
            sliderpos = ((float)(mouseY - slidertop) - 7.5f) / (float)(sliderbottom - slidertop);
            if (sliderpos < 0.0f) {
                sliderpos = 0.0f;
            }
            if (sliderpos > 1.0f) {
                sliderpos = 1.0f;
            }
            this.currentScroll = (int)(sliderpos * (float)this.maxScroll);
        }
        this.mc.field_71446_o.func_110577_a(Assets.GUIs.scrollbar);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)guiLeft, (float)guiTop, (float)0.0f);
        GL11.glScalef((float)xScale, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)20, (int)4, (float)32.0f, (float)32.0f);
        for (int y = 4; y < this.ySize - 4; y += 22) {
            int ys = 22;
            if (ys > this.ySize - y - 4) {
                ys = this.ySize - y - 4;
            }
            Gui.func_146110_a((int)0, (int)(0 + y), (float)0.0f, (float)4.0f, (int)20, (int)ys, (float)32.0f, (float)32.0f);
        }
        Gui.func_146110_a((int)0, (int)(0 + this.ySize - 4), (float)0.0f, (float)26.0f, (int)20, (int)4, (float)32.0f, (float)32.0f);
        if (this.isScrolling) {
            Gui.func_146110_a((int)4, (int)(4 + (int)((float)(sliderbottom - slidertop) * sliderpos)), (float)20.0f, (float)15.0f, (int)12, (int)15, (float)32.0f, (float)32.0f);
        } else {
            Gui.func_146110_a((int)4, (int)(4 + (int)((float)(sliderbottom - slidertop) * sliderpos)), (float)20.0f, (float)0.0f, (int)12, (int)15, (float)32.0f, (float)32.0f);
        }
        GL11.glPopMatrix();
    }
}

