/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.page;

import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public abstract class Page {
    public static void setQuality(ItemStack page, String trait, int quality) {
        Page.getQualityStruct(page).func_74768_a(trait, quality);
    }

    public static int getTotalQuality(ItemStack page) {
        NBTTagCompound compound = Page.getQualityStruct(page);
        int sum = 0;
        for (Object tagname : compound.func_150296_c()) {
            sum += compound.func_74762_e((String)tagname);
        }
        return sum;
    }

    public static Integer getQuality(ItemStack page, String trait) {
        NBTTagCompound data = Page.getQualityStruct(page);
        if (data.func_74764_b(trait)) {
            return data.func_74762_e(trait);
        }
        return null;
    }

    private static NBTTagCompound getData(ItemStack item) {
        if (item == null) {
            return null;
        }
        return item.field_77990_d;
    }

    private static NBTTagCompound getQualityStruct(ItemStack page) {
        NBTTagCompound data = Page.getData(page);
        if (data == null) {
            return null;
        }
        if (!data.func_74764_b("Quality")) {
            data.func_74782_a("Quality", (NBTBase)new NBTTagCompound());
        }
        return data.func_74775_l("Quality");
    }

    public static boolean isBlank(ItemStack page) {
        return !Page.isLinkPanel(page) && Page.getSymbol(page) == null;
    }

    public static boolean isLinkPanel(ItemStack page) {
        NBTTagCompound data = Page.getData(page);
        if (data == null) {
            return false;
        }
        return data.func_74764_b("linkpanel");
    }

    public static void makeLinkPanel(ItemStack page) {
        NBTTagCompound data = Page.getData(page);
        if (data == null) {
            page.field_77990_d = Page.createDefault();
            data = Page.getData(page);
        }
        if (!data.func_74764_b("linkpanel")) {
            data.func_74782_a("linkpanel", (NBTBase)new NBTTagCompound());
        }
    }

    public static void addLinkProperty(ItemStack page, String linkproperty) {
        if (page == null) {
            return;
        }
        NBTTagCompound data = Page.getData(page);
        if (data == null) {
            page.field_77990_d = Page.createDefault();
            data = Page.getData(page);
        }
        if (!data.func_74764_b("linkpanel")) {
            data.func_74782_a("linkpanel", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound linkpanel = data.func_74775_l("linkpanel");
        NBTTagList list = linkpanel.func_150295_c("properties", 8);
        list.func_74742_a((NBTBase)new NBTTagString(linkproperty));
        linkpanel.func_74782_a("properties", (NBTBase)list);
    }

    public static Collection<String> getLinkProperties(ItemStack page) {
        NBTTagCompound data = Page.getData(page);
        if (data == null) {
            return null;
        }
        if (!data.func_74764_b("linkpanel")) {
            return null;
        }
        NBTTagCompound linkpanel = data.func_74775_l("linkpanel");
        ArrayList<String> properties = NBTUtils.readStringCollection(linkpanel.func_150295_c("properties", 8), new ArrayList());
        return properties;
    }

    public static void applyLinkPanel(ItemStack linkpanel, ItemStack linkingitem) {
        Collection<String> properties = Page.getLinkProperties(linkpanel);
        if (properties == null) {
            return;
        }
        for (String property : properties) {
            LinkOptions.setFlag(linkingitem.field_77990_d, property, true);
        }
    }

    public static void setSymbol(ItemStack page, String symbol2) {
        NBTTagCompound data = Page.getData(page);
        if (data == null) {
            return;
        }
        if (symbol2 == null) {
            data.func_82580_o("symbol");
        } else {
            data.func_74778_a("symbol", symbol2);
        }
    }

    public static String getSymbol(ItemStack page) {
        NBTTagCompound data = Page.getData(page);
        if (data == null) {
            return null;
        }
        String symbol2 = data.func_74779_i("symbol");
        if (symbol2.equals("")) {
            symbol2 = null;
        }
        return symbol2;
    }

    public static void getTooltip(ItemStack page, List<String> list) {
        Collection<String> properties;
        if (Page.isLinkPanel(page) && (properties = Page.getLinkProperties(page)) != null && properties.size() > 0) {
            for (String property : properties) {
                list.add(InkEffects.getLocalizedName(property));
            }
        }
    }

    public static NBTTagCompound createDefault() {
        return new NBTTagCompound();
    }

    public static ItemStack createPage() {
        ItemStack page = new ItemStack(ModItems.page, 1, 0);
        page.field_77990_d = Page.createDefault();
        return page;
    }

    public static ItemStack createLinkPage() {
        ItemStack page = new ItemStack(ModItems.page, 1, 0);
        page.field_77990_d = Page.createDefault();
        Page.makeLinkPanel(page);
        return page;
    }

    public static ItemStack createLinkPage(String property) {
        ItemStack page = new ItemStack(ModItems.page, 1, 0);
        page.field_77990_d = Page.createDefault();
        Page.addLinkProperty(page, property);
        return page;
    }

    public static ItemStack createSymbolPage(String symbol2) {
        ItemStack page = new ItemStack(ModItems.page, 1, 0);
        page.field_77990_d = Page.createDefault();
        Page.setSymbol(page, symbol2);
        return page;
    }

    public static ItemStack createPage(NBTTagCompound pagedata) {
        ItemStack page = new ItemStack(ModItems.page, 1, 0);
        page.field_77990_d = pagedata;
        return page;
    }
}

