/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class SunsetRenderer {
    private float[] colorsSunriseSunset = new float[4];
    protected AgeDirector controller;
    protected ColorGradient gradient;

    public SunsetRenderer(AgeDirector controller, ColorGradient gradient) {
        this.controller = controller;
        this.gradient = gradient;
    }

    @SideOnly(value=Side.CLIENT)
    protected float[] getSunriseSunsetColors(float celestial_angle, float partialtick) {
        float f4;
        float f2 = 0.4f;
        float f3 = MathHelper.func_76134_b((float)(celestial_angle * 3.141593f * 2.0f)) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float f5 = (f3 - f4) / f2 * 0.5f + 0.5f;
            float f6 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f5 * 3.141593f))) * 0.99f;
            f6 *= f6;
            ColorGradient gradient = this.gradient;
            Color color = null;
            if (gradient == null) {
                gradient = this.controller.getSunriseSunsetColor();
            }
            if (gradient != null && gradient.getColorCount() > 0) {
                color = gradient.getColor((float)this.controller.getTime() / 12000.0f);
            }
            if (color == null) {
                this.colorsSunriseSunset[0] = f5 * 0.3f + 0.7f;
                this.colorsSunriseSunset[1] = f5 * f5 * 0.7f + 0.2f;
                this.colorsSunriseSunset[2] = f5 * f5 * 0.0f + 0.2f;
            } else {
                this.colorsSunriseSunset[0] = color.r;
                this.colorsSunriseSunset[1] = color.g;
                this.colorsSunriseSunset[2] = color.b;
            }
            this.colorsSunriseSunset[3] = f6;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderHorizon(TextureManager eng, World worldObj, float celestial_period, float angle, float partial, float alpha) {
        float celestial_radians = celestial_period * (float)Math.PI * 2.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        RenderHelper.func_74518_a();
        float[] horizoncolors = this.getSunriseSunsetColors(celestial_period, partial);
        if (horizoncolors != null) {
            float horizonRed = horizoncolors[0];
            float horizonGreen = horizoncolors[1];
            float horizonBlue = horizoncolors[2];
            horizoncolors[3] = horizoncolors[3] * alpha;
            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                float red = (horizonRed * 30.0f + horizonGreen * 59.0f + horizonBlue * 11.0f) / 100.0f;
                float green = (horizonRed * 30.0f + horizonGreen * 70.0f) / 100.0f;
                float blue = (horizonRed * 30.0f + horizonBlue * 70.0f) / 100.0f;
                horizonRed = red;
                horizonGreen = green;
                horizonBlue = blue;
            }
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)celestial_radians) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_78371_b(6);
            tessellator.func_78369_a(horizonRed, horizonGreen, horizonBlue, horizoncolors[3]);
            tessellator.func_78377_a(0.0, 100.0, 0.0);
            tessellator.func_78369_a(horizoncolors[0], horizoncolors[1], horizoncolors[2], 0.0f);
            int var26 = 16;
            for (int var27 = 0; var27 <= var26; ++var27) {
                float var13 = (float)var27 * (float)Math.PI * 2.0f / (float)var26;
                float var14 = MathHelper.func_76126_a((float)var13);
                float var15 = MathHelper.func_76134_b((float)var13);
                tessellator.func_78377_a((double)(var14 * 120.0f), (double)(var15 * 120.0f), (double)(-var15 * 40.0f * horizoncolors[3]));
            }
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
    }
}

