/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openperipheral.addons.glasses.NbtGuidProviders;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.api.meta.IItemStackCustomMetaProvider;

public class NbtTerminalMetaProvider
implements IItemStackCustomMetaProvider<Item> {
    public Class<? extends Item> getTargetClass() {
        return Item.class;
    }

    public String getKey() {
        return "op_terminal_embedded";
    }

    public boolean canApply(Item target, ItemStack stack) {
        return NbtGuidProviders.hasTerminalCapabilities(stack);
    }

    public Object getMeta(Item target, ItemStack stack) {
        HashMap results = Maps.newHashMap();
        Optional<Long> terminalGuid = NbtGuidProviders.getTerminalGuid(stack);
        if (terminalGuid.isPresent()) {
            results.put("bridge_name", TerminalUtils.formatTerminalId((Long)terminalGuid.get()));
        }
        return results;
    }
}

