/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.client;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import openmods.structured.IStructureElement;
import openmods.structured.StructureObserver;
import openperipheral.addons.glasses.client.DrawableContainerSlave;
import openperipheral.addons.glasses.drawable.Drawable;

public abstract class SurfaceClient {
    private static final Comparator<Drawable> COMPARATOR = new Comparator<Drawable>(){

        @Override
        public int compare(Drawable o1, Drawable o2) {
            return Ints.compare((int)o1.z, (int)o2.z);
        }
    };
    public final DrawableContainerSlave drawablesContainer;
    private final SurfaceClientObserver surfaceObserver = new SurfaceClientObserver();

    private SurfaceClient(long guid) {
        this.drawablesContainer = this.createDrawableContainer(guid, this.surfaceObserver);
    }

    protected abstract DrawableContainerSlave createDrawableContainer(long var1, StructureObserver<Drawable, IStructureElement> var3);

    public static SurfaceClient createPublicSurface(long guid) {
        return new SurfaceClient(guid){

            @Override
            protected DrawableContainerSlave createDrawableContainer(long guid, StructureObserver<Drawable, IStructureElement> observer) {
                return new DrawableContainerSlave.Public(guid, observer);
            }
        };
    }

    public static SurfaceClient createPrivateSurface(long guid) {
        return new SurfaceClient(guid){

            @Override
            protected DrawableContainerSlave createDrawableContainer(long guid, StructureObserver<Drawable, IStructureElement> observer) {
                return new DrawableContainerSlave.Private(guid, observer);
            }
        };
    }

    public List<Drawable> getSortedDrawables() {
        return this.surfaceObserver.sortedElementsView;
    }

    private class SurfaceClientObserver
    extends StructureObserver<Drawable, IStructureElement> {
        private final List<Drawable> sortedElements = Lists.newArrayList();
        private final List<Drawable> sortedElementsView = Collections.unmodifiableList(this.sortedElements);

        public void onContainerAdded(int containerId, Drawable container) {
            container.setId(containerId);
            this.sortedElements.add(container);
        }

        public void onContainerRemoved(int containerId, Drawable container) {
            this.sortedElements.remove((Object)container);
        }

        public void onContainerUpdated(int containerId, Drawable container) {
            container.onUpdate();
        }

        public void onStructureUpdate() {
            Collections.sort(this.sortedElements, COMPARATOR);
        }

        public void onDataUpdate() {
            Collections.sort(this.sortedElements, COMPARATOR);
        }
    }
}

