/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import openmods.geometry.Box2d;
import openmods.structured.StructureField;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.drawable.DrawableType;
import openperipheral.addons.glasses.utils.GlassesRenderingUtils;
import openperipheral.addons.glasses.utils.RenderState;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Property;
import openperipheral.api.adapter.method.ScriptObject;

@ScriptObject
@AdapterSourceName(value="glasses_liquid")
public class LiquidIcon
extends Drawable {
    @Property
    @StructureField
    public float x;
    @Property
    @StructureField
    public float y;
    @Property
    @StructureField
    public float width;
    @Property
    @StructureField
    public float height;
    @Property
    @StructureField
    public String fluid;
    @Property
    @StructureField
    public float alpha = 1.0f;
    private IIcon fluidIcon;
    private int iconWidth;
    private int iconHeight;

    LiquidIcon() {
    }

    public LiquidIcon(float x, float y, float width, float height, String fluid) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fluid = fluid;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawContents(RenderState renderState, float partialTicks) {
        if (this.fluidIcon == null || this.iconWidth <= 0 || this.iconHeight <= 0) {
            return;
        }
        renderState.setupTexturedRender();
        renderState.setColor(0xFFFFFF, this.alpha);
        TextureManager render = FMLClientHandler.instance().getClient().field_71446_o;
        render.func_110577_a(TextureMap.field_110575_b);
        float xIterations = this.width / (float)this.iconWidth;
        float yIterations = this.height / (float)this.iconHeight;
        for (float xIteration = 0.0f; xIteration < xIterations; xIteration += 1.0f) {
            for (float yIteration = 0.0f; yIteration < yIterations; yIteration += 1.0f) {
                float xDrawSize = Math.min(xIterations - xIteration, 1.0f);
                float yDrawSize = Math.min(yIterations - yIteration, 1.0f);
                GlassesRenderingUtils.drawTexturedQuad(xIteration * (float)this.iconWidth, yIteration * (float)this.iconHeight, this.fluidIcon, xDrawSize * (float)this.iconWidth, yDrawSize * (float)this.iconHeight, xDrawSize, yDrawSize);
            }
        }
    }

    @Override
    public DrawableType getTypeEnum() {
        return DrawableType.LIQUID;
    }

    @Override
    public boolean isVisible() {
        return this.alpha > 0.0f && this.fluidIcon != null && this.iconWidth > 0 && this.iconHeight > 0;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.fluidIcon = LiquidIcon.findFluidIcon(this.fluid);
        if (this.fluidIcon != null) {
            this.iconWidth = this.fluidIcon.func_94211_a();
            this.iconHeight = this.fluidIcon.func_94216_b();
        }
        this.setBoundingBox(Box2d.fromOriginAndSize((float)this.x, (float)this.y, (float)this.width, (float)this.height));
    }

    private static IIcon findFluidIcon(String fluid) {
        Fluid drawLiquid = FluidRegistry.getFluid((String)fluid);
        return drawLiquid != null ? drawLiquid.getFlowingIcon() : null;
    }
}

