/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import openmods.geometry.Box2d;
import openmods.structured.StructureField;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.drawable.DrawableType;
import openperipheral.addons.glasses.utils.Point2d;
import openperipheral.addons.glasses.utils.RenderState;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Property;
import openperipheral.api.adapter.method.ScriptObject;
import org.lwjgl.opengl.GL11;

@ScriptObject
@AdapterSourceName(value="glasses_point")
public class Point
extends Drawable {
    @Property
    @StructureField
    public int color;
    @Property
    @StructureField
    public float opacity;
    @Property
    @StructureField
    public Point2d coord = Point2d.NULL;
    @Property
    @StructureField
    public float size = 1.0f;

    Point() {
    }

    public Point(Point2d coord, int color, float opacity) {
        this.coord = coord;
        this.color = color;
        this.opacity = opacity;
    }

    private void updateBoundingBox() {
        this.setBoundingBox(Box2d.fromOriginAndSize((float)this.coord.x, (float)this.coord.y, (float)0.0f, (float)0.0f));
    }

    @Override
    protected void drawContents(RenderState renderState, float partialTicks) {
        renderState.setColor(this.color, this.opacity);
        renderState.setupSolidRender();
        renderState.setPointSize(this.size);
        GL11.glBegin((int)0);
        GL11.glVertex2i((int)0, (int)0);
        GL11.glEnd();
    }

    @Override
    protected DrawableType getTypeEnum() {
        return DrawableType.POINT;
    }

    @Override
    protected boolean isVisible() {
        return true;
    }

    @Override
    public void onUpdate() {
        if (this.size <= 0.0f) {
            this.size = 1.0f;
        }
        this.updateBoundingBox();
    }
}

