/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.container;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.draconicevolution.common.blocks.DraconiumChest;
import com.brandon3055.draconicevolution.common.inventory.InventoryCraftingChest;
import com.brandon3055.draconicevolution.common.inventory.InventoryCraftingChestResult;
import com.brandon3055.draconicevolution.common.lib.OreDoublingRegistry;
import com.brandon3055.draconicevolution.common.tileentities.TileDraconiumChest;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.ChestContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@ChestContainer(isLargeChest=false, rowSize=26)
public class ContainerDraconiumChest
extends Container {
    public InventoryCrafting craftMatrix;
    public IInventory craftResult;
    private TileDraconiumChest tile;
    private EntityPlayer player;
    private World worldObj;
    private int lastProgressTime;
    private int lastEnergyStored;
    private int lastBurnSpeed;
    private int lastTickFeedMode;
    private boolean lastTickOutputLock;

    public ContainerDraconiumChest(InventoryPlayer invPlayer, TileDraconiumChest tile) {
        this.tile = tile;
        this.player = invPlayer.field_70458_d;
        this.worldObj = tile.func_145831_w();
        tile.func_70295_k_();
        this.craftMatrix = new InventoryCraftingChest(this, 3, 3, tile);
        this.craftResult = new InventoryCraftingChestResult(tile);
        this.addContainerSlots();
        this.addCraftingSlots();
        this.addPlayerInventory();
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    private void addContainerSlots() {
        for (int chestRow = 0; chestRow < 9; ++chestRow) {
            for (int chestCol = 0; chestCol < 26; ++chestCol) {
                this.func_75146_a(new SlotDChest((IInventory)this.tile, chestCol + chestRow * 26, 8 + chestCol * 18, 15 + chestRow * 18));
            }
        }
    }

    private void addPlayerInventory() {
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, playerInvCol + playerInvRow * 9 + 9, 161 + 18 * playerInvCol, 179 + playerInvRow * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, hotbarSlot, 161 + 18 * hotbarSlot, 235));
        }
    }

    private void addCraftingSlots() {
        int yOffset = 188;
        int xOffset = 334;
        this.func_75146_a(new SlotChargable((IInventory)this.tile, 239, 8, 235));
        for (int row = 0; row < 5; ++row) {
            this.func_75146_a(new SlotSmeltable((IInventory)this.tile, 234 + row, 45 + row * 18, 197));
        }
        this.func_75146_a((Slot)new SlotCrafting(this.player, (IInventory)this.craftMatrix, this.craftResult, 0, xOffset + 94, yOffset + 18));
        for (int gridCol = 0; gridCol < 3; ++gridCol) {
            for (int gridRow = 0; gridRow < 3; ++gridRow) {
                this.func_75146_a(new SlotDChest((IInventory)this.craftMatrix, gridRow + gridCol * 3, xOffset + gridRow * 18, yOffset + gridCol * 18));
            }
        }
    }

    public void func_75130_a(IInventory inventory) {
        this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.craftMatrix, this.worldObj));
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tile.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (i < this.tile.func_70302_i_() + 16 && i != 240) {
                if (!this.func_75135_a(itemstack1, this.tile.func_70302_i_() + 16, this.field_75151_b.size(), true)) {
                    return null;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (i == 240) {
                if (!this.func_75135_a(itemstack1, this.tile.func_70302_i_() + 16, this.field_75151_b.size(), true) && !this.func_75135_a(itemstack1, 0, this.tile.func_70302_i_(), false)) {
                    return null;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (!DraconiumChest.isStackValid(itemstack1) || !this.func_75135_a(itemstack1, 0, this.tile.func_70302_i_(), false)) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            slot.func_82870_a(player, itemstack1);
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer p_75134_1_) {
        super.func_75134_a(p_75134_1_);
        this.tile.func_70305_f();
        if (!this.worldObj.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                ItemStack itemstack = this.craftMatrix.func_70304_b(i);
                if (itemstack == null) continue;
                this.player.func_71019_a(itemstack, false);
            }
        }
    }

    public boolean func_94530_a(ItemStack par1ItemStack, Slot par2Slot) {
        return par2Slot.field_75224_c != this.craftResult && super.func_94530_a(par1ItemStack, par2Slot);
    }

    public void func_75132_a(ICrafting iCrafting) {
        super.func_75132_a(iCrafting);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            if (this.lastProgressTime != this.tile.smeltingProgressTime) {
                icrafting.func_71112_a((Container)this, 0, this.tile.smeltingProgressTime);
            }
            if (this.lastEnergyStored != this.tile.getEnergyStored(ForgeDirection.DOWN)) {
                icrafting.func_71112_a((Container)this, 1, this.tile.getEnergyStored(ForgeDirection.DOWN) / 32);
            }
            if (this.lastBurnSpeed != this.tile.smeltingBurnSpeed) {
                icrafting.func_71112_a((Container)this, 2, this.tile.smeltingBurnSpeed);
            }
            if (this.lastTickFeedMode != this.tile.smeltingAutoFeed) {
                icrafting.func_71112_a((Container)this, 3, this.tile.smeltingAutoFeed);
            }
            if (this.lastTickOutputLock == this.tile.lockOutputSlots) continue;
            icrafting.func_71112_a((Container)this, 4, this.tile.lockOutputSlots ? 1 : 0);
        }
        this.lastTickOutputLock = this.tile.lockOutputSlots;
        this.lastTickFeedMode = this.tile.smeltingAutoFeed;
        this.lastBurnSpeed = this.tile.smeltingBurnSpeed;
        this.lastProgressTime = this.tile.smeltingProgressTime;
        this.lastEnergyStored = this.tile.getEnergyStored(ForgeDirection.DOWN);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        if (id == 0) {
            this.tile.smeltingProgressTime = value;
        } else if (id == 1) {
            this.tile.energy.setEnergyStored(value * 32);
        } else if (id == 2) {
            this.tile.smeltingBurnSpeed = value;
        } else if (id == 3) {
            this.tile.smeltingAutoFeed = value;
        } else if (id == 4) {
            this.tile.lockOutputSlots = value == 1;
        }
    }

    public TileDraconiumChest getTile() {
        return this.tile;
    }

    public class SlotDChest
    extends Slot {
        public SlotDChest(IInventory inventory, int id, int x, int y) {
            super(inventory, id, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return DraconiumChest.isStackValid(stack);
        }
    }

    public class SlotChargable
    extends Slot {
        public SlotChargable(IInventory inventory, int id, int x, int y) {
            super(inventory, id, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (super.func_75214_a(stack)) {
                return stack != null && stack.func_77973_b() instanceof IEnergyContainerItem;
            }
            return false;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    public class SlotSmeltable
    extends Slot {
        public SlotSmeltable(IInventory p_i1824_1_, int p_i1824_2_, int p_i1824_3_, int p_i1824_4_) {
            super(p_i1824_1_, p_i1824_2_, p_i1824_3_, p_i1824_4_);
        }

        public boolean func_75214_a(ItemStack stack) {
            return FurnaceRecipes.func_77602_a().func_151395_a(stack) != null || OreDoublingRegistry.getOreResult(stack) != null;
        }
    }
}

