/*
 * Decompiled with CFR 0.152.
 */
package portalgun.common.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import portalgun.common.PortalGun;
import portalgun.common.entity.EntityPortalBall;
import portalgun.common.tileentity.TileEntityPortalMod;

public class ChunkLoadHandler
implements ForgeChunkManager.LoadingCallback {
    public static HashMap<EntityPortalBall, ForgeChunkManager.Ticket> entTickets = new HashMap();
    public static HashMap<TileEntityPortalMod, ForgeChunkManager.Ticket> portalTickets = new HashMap();

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> ticketList, World world) {
        for (ForgeChunkManager.Ticket ticket : ticketList) {
            TileEntity te = world.func_147438_o(ticket.getModData().func_74762_e("portalX"), ticket.getModData().func_74762_e("portalY"), ticket.getModData().func_74762_e("portalZ"));
            if (te != null && te instanceof TileEntityPortalMod) {
                TileEntityPortalMod tep = (TileEntityPortalMod)te;
                ForgeChunkManager.Ticket ticket1 = portalTickets.get((Object)tep);
                if (ticket1 != null) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket1);
                }
                portalTickets.put(tep, ticket);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(tep.field_145851_c >> 4, tep.field_145849_e >> 4));
                continue;
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public static void removePortalAsChunkLoader(TileEntityPortalMod ent) {
        ForgeChunkManager.Ticket ticket = portalTickets.get((Object)ent);
        if (ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        portalTickets.remove((Object)ent);
    }

    public static void addPortalAsChunkLoader(TileEntityPortalMod tep) {
        if (tep != null && !tep.isSpacePortal) {
            ForgeChunkManager.Ticket ticket = portalTickets.get((Object)tep);
            if (ticket == null && (ticket = ForgeChunkManager.requestTicket((Object)PortalGun.instance, (World)tep.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
                portalTickets.put(tep, ticket);
            }
            if (ticket != null) {
                ticket.getModData().func_74768_a("portalX", tep.field_145851_c);
                ticket.getModData().func_74768_a("portalY", tep.field_145848_d);
                ticket.getModData().func_74768_a("portalZ", tep.field_145849_e);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(tep.field_145851_c >> 4, tep.field_145849_e >> 4));
            }
        }
    }

    public static void removeTicket(EntityPortalBall ent) {
        ForgeChunkManager.Ticket ticket = entTickets.get((Object)ent);
        if (ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        entTickets.remove((Object)ent);
    }

    public static void addTicket(EntityPortalBall ent, ForgeChunkManager.Ticket ticket) {
        if (ent != null) {
            if (entTickets.get((Object)ent) != null) {
                ChunkLoadHandler.removeTicket(ent);
            }
            entTickets.put(ent, ticket);
            if (entTickets.size() > 20) {
                EntityPortalBall ball = null;
                for (Map.Entry<EntityPortalBall, ForgeChunkManager.Ticket> e : entTickets.entrySet()) {
                    EntityPortalBall ent1 = e.getKey();
                    if ((ball == null || ent1.age <= ball.age) && ent1.age <= ent.age) continue;
                    ball = ent1;
                }
                if (ball != null) {
                    ChunkLoadHandler.removeTicket(ball);
                }
            }
        }
    }
}

