/*
 * Decompiled with CFR 0.152.
 */
package portalgun.common.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gravigun.common.GraviGun;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import portalgun.common.PortalGun;
import portalgun.common.core.EntityHelper;
import portalgun.common.entity.EntityCube;
import portalgun.common.entity.EntityRadio;
import portalgun.common.entity.EntityTurret;
import portalgun.common.item.ItemPortalGun;
import portalgun.common.item.ItemPotato;
import portalgun.common.packet.PacketGrabEntity;
import portalgun.common.tileentity.TileEntityPortalMod;

public class TickHandlerServer {
    public HashMap<EntityLivingBase, Entity> grabMap = new HashMap();
    public HashMap<String, TileEntityPortalMod> portals = new HashMap();
    public HashMap<TileEntityPortalMod, Integer> moonPortals = new HashMap();
    public HashMap<String, int[]> potatosProgression = new HashMap();
    public HashMap<String, Entity> lastSeenEntity = new HashMap();
    public HashMap<String, Boolean> hasFallen = new HashMap();
    public NBTTagCompound data = null;
    public EntityLivingBase watchingSpawnFor = null;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            this.playerTick(event.player.field_70170_p, (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            this.worldTick(event.world);
        }
    }

    public void worldTick(World world) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity ent = (Entity)world.field_72996_f.get(i);
            if (!(ent instanceof EntityZombie)) continue;
            this.zombieTick(world, (EntityZombie)ent);
        }
    }

    public void zombieTick(World world, EntityZombie zombie) {
        boolean currentItemIsPortalGun;
        boolean bl = currentItemIsPortalGun = zombie.func_70694_bm() != null && zombie.func_70694_bm().func_77973_b() instanceof ItemPortalGun;
        if (currentItemIsPortalGun && zombie.func_70681_au().nextFloat() < 0.008f) {
            if (zombie.func_70681_au().nextFloat() < 0.4f) {
                Entity grabbed = PortalGun.proxy.tickHandlerServer.getGrabbed((EntityLivingBase)zombie);
                if (grabbed != null) {
                    zombie.field_70170_p.func_72956_a((Entity)zombie, "portalgun:object_use_stop_", 0.3f, 1.0f);
                } else {
                    EntityHelper.tryGrab((EntityLivingBase)zombie, true);
                }
            } else {
                zombie.field_70177_z = zombie.field_70177_z + 5.0f * zombie.func_70681_au().nextFloat() * (zombie.func_70681_au().nextBoolean() ? 1.0f : -1.0f);
                zombie.field_70125_A = zombie.field_70125_A + 20.0f * zombie.func_70681_au().nextFloat() * (zombie.func_70681_au().nextBoolean() ? 1.0f : -1.0f);
                EntityHelper.shootPortal((EntityLivingBase)zombie, zombie.func_70694_bm(), zombie.func_70681_au().nextInt(2) + 1);
            }
        }
    }

    public void playerTick(World world, EntityPlayerMP player) {
        int n;
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b.size() > 0 && player == FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b.get(0)) {
            for (Map.Entry<EntityLivingBase, Entity> entry : this.grabMap.entrySet()) {
                this.updateGrabbing(entry.getKey().field_70170_p, entry.getKey(), entry.getValue());
            }
            Iterator<Map.Entry<TileEntityPortalMod, Integer>> moonPortalsIterator = this.moonPortals.entrySet().iterator();
            while (moonPortalsIterator.hasNext()) {
                Map.Entry<TileEntityPortalMod, Integer> entry = moonPortalsIterator.next();
                entry.setValue(entry.getValue() + 1);
                if (entry.getValue() <= 60) continue;
                PortalGun.addPortalToList(entry.getKey());
                entry.getKey().findLink();
                moonPortalsIterator.remove();
            }
        }
        int singleSlotBlue = -1;
        int n2 = -1;
        boolean heal = false;
        for (int i1 = 0; i1 < player.field_71071_by.field_70462_a.length; ++i1) {
            ItemStack is2 = player.field_71071_by.field_70462_a[i1];
            if (is2 == null) continue;
            if (PortalGun.getSettings("autoMergeGuns") == 1) {
                if (is2.func_77973_b() == PortalGun.itemPGBlue && is2.func_77960_j() == 5) {
                    if (singleSlotBlue == -1) {
                        singleSlotBlue = i1;
                    }
                } else if (is2.func_77973_b() == PortalGun.itemPGOrange && is2.func_77960_j() == 5 && n == -1) {
                    n = i1;
                }
            }
            if (is2.func_77973_b() != PortalGun.itemMulti || is2.func_77960_j() != 1) continue;
            heal = true;
        }
        if (heal && world.func_72820_D() % 100L == 0L) {
            player.func_70691_i(1.0f);
        }
        if (singleSlotBlue != -1 && n != -1) {
            ItemStack is = new ItemStack(PortalGun.itemPGBlue, 1, 0);
            is.func_77982_d(player.field_71071_by.field_70462_a[singleSlotBlue < n ? singleSlotBlue : n].func_77978_p());
            player.field_71071_by.field_70462_a[singleSlotBlue < n ? singleSlotBlue : n] = is;
            player.field_71071_by.field_70462_a[singleSlotBlue < n ? n : singleSlotBlue] = null;
        }
        if (PortalGun.getSettings("potatosSpeech") == 1) {
            ItemStack is = player.func_71045_bC();
            boolean holdingPotatogun = is != null && is.func_77973_b() instanceof ItemPortalGun && is.func_77960_j() == 4;
            boolean holdingPotatOS = is != null && is.func_77973_b() instanceof ItemPotato;
            int[] prog = this.getProgression((EntityPlayer)player);
            if (prog[0] <= 3) {
                if (prog[0] <= 0 || prog[0] == 2) {
                    if (holdingPotatogun && prog[1] < 20) {
                        prog[0] = 2;
                    }
                    if (holdingPotatogun || holdingPotatOS) {
                        prog[1] = prog[1] + 1;
                        if (prog[1] == 20) {
                            world.func_72956_a((Entity)player, "portalgun:potatos.introa", 0.15f, 1.0f);
                        }
                        if (prog[1] == 50) {
                            world.func_72956_a((Entity)player, "portalgun:potatos.introb", 0.15f, 1.0f);
                        }
                        if (prog[1] == 105) {
                            world.func_72956_a((Entity)player, "portalgun:potatos.introc", 0.15f, 1.0f);
                        }
                        if (holdingPotatOS && prog[1] > 110 || holdingPotatogun && prog[1] > 510) {
                            prog[0] = holdingPotatOS ? 1 : 3;
                            prog[1] = 0;
                        }
                    }
                } else if (holdingPotatogun) {
                    if (prog[0] == 1) {
                        prog[1] = prog[1] + 1;
                        if (prog[1] == 1) {
                            world.func_72956_a((Entity)player, "portalgun:potatos.stabbed", 0.15f, 1.0f);
                        }
                        if (prog[1] > 500) {
                            prog[0] = 3;
                            prog[1] = 0;
                        }
                    } else if (prog[0] == 3) {
                        prog[1] = prog[1] + 1;
                        if (prog[1] == 1) {
                            world.func_72956_a((Entity)player, "portalgun:potatos.wakeup", 0.15f, 1.0f);
                        }
                        if (prog[1] > 200) {
                            prog[0] = 4;
                            prog[1] = 0;
                        }
                    }
                }
            } else if (holdingPotatogun) {
                if (prog[0] == 4) {
                    if (prog[1] == 0) {
                        MovingObjectPosition mop = EntityHelper.getEntityLook((EntityLivingBase)player, (double)15.0);
                        if (mop != null) {
                            if (mop.field_72308_g != null) {
                                if (mop.field_72308_g != this.lastSeenEntity.get(player.func_70005_c_())) {
                                    if (mop.field_72308_g instanceof EntityChicken) {
                                        world.func_72956_a((Entity)player, "portalgun:potatos.see_chicken", 0.15f, 1.0f);
                                        this.lastSeenEntity.put(player.func_70005_c_(), mop.field_72308_g);
                                        prog[1] = prog[1] + 1;
                                    } else if ((double)mop.field_72308_g.func_70032_d((Entity)player) <= 10.0 && mop.field_72308_g instanceof EntityPainting) {
                                        EntityPainting painting = (EntityPainting)mop.field_72308_g;
                                        if (painting.field_70522_e.field_75702_A.equalsIgnoreCase("Fighters") || painting.field_70522_e.field_75702_A.equalsIgnoreCase("Pointer") || painting.field_70522_e.field_75702_A.equalsIgnoreCase("Pigscene")) {
                                            this.lastSeenEntity.put(player.func_70005_c_(), mop.field_72308_g);
                                            prog[0] = 7;
                                        }
                                    }
                                }
                            } else {
                                Block blockID = player.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                                double dist = player.func_70011_f((double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d);
                                if (blockID == Blocks.field_150474_ac && dist <= 10.0) {
                                    if (!(this.lastSeenEntity.get(player.func_70005_c_()) instanceof EntityCow)) {
                                        world.func_72956_a((Entity)player, "portalgun:potatos.see_mobspawner", 0.15f, 1.0f);
                                        this.lastSeenEntity.put(player.func_70005_c_(), (Entity)new EntityCow(player.field_70170_p));
                                        prog[1] = prog[1] + 1;
                                    }
                                } else if ((blockID == Blocks.field_150430_aB || blockID == Blocks.field_150471_bO) && dist <= 5.0) {
                                    world.func_72956_a((Entity)player, "portalgun:potatos.pressbutton", 0.15f, 1.0f);
                                    prog[1] = PortalGun.getSettings("potatosSpeechCooldown") * 8 / 9 + player.func_70681_au().nextInt(60);
                                } else if (blockID == Blocks.field_150414_aQ && dist <= 5.0 && !(this.lastSeenEntity.get(player.func_70005_c_()) instanceof EntityArrow)) {
                                    world.func_72956_a((Entity)player, "portalgun:potatos.cake", 0.15f, 1.0f);
                                    this.lastSeenEntity.put(player.func_70005_c_(), (Entity)new EntityArrow(player.field_70170_p));
                                    prog[1] = prog[1] + 1;
                                }
                            }
                        }
                        if (player.func_110143_aJ() < 6.0f) {
                            if (!(this.lastSeenEntity.get(player.func_70005_c_()) instanceof EntityPig)) {
                                prog[0] = 6;
                            }
                        } else if (player.func_70681_au().nextFloat() < 2.5E-5f && !(this.lastSeenEntity.get(player.func_70005_c_()) instanceof EntitySheep)) {
                            world.func_72956_a((Entity)player, "portalgun:potatos.paradox", 0.15f, 1.0f);
                            this.lastSeenEntity.put(player.func_70005_c_(), (Entity)new EntitySheep(player.field_70170_p));
                            prog[1] = prog[1] + 1;
                        }
                    } else {
                        prog[1] = prog[1] + 1;
                        if (prog[1] > PortalGun.getSettings("potatosSpeechCooldown")) {
                            prog[1] = 0;
                        }
                    }
                } else if (prog[0] == 5) {
                    prog[1] = prog[1] + 1;
                    if (prog[1] == 5) {
                        world.func_72956_a((Entity)player, "portalgun:potatos.slowclap", 0.15f, 1.0f);
                    }
                    if (prog[1] >= 65) {
                        if (!this.getHasFallen((EntityPlayer)player)) {
                            world.func_72956_a((Entity)player, "portalgun:potatos.slowclapa", 0.15f, 1.0f);
                            this.hasFallen.put(player.func_70005_c_(), true);
                        } else if (player.func_70089_S()) {
                            world.func_72956_a((Entity)player, "portalgun:potatos.slowclapb", 0.15f, 1.0f);
                        } else {
                            world.func_72956_a((Entity)player, "portalgun:potatos.insult", 0.15f, 1.0f);
                        }
                        prog[0] = 4;
                        prog[1] = PortalGun.getSettings("potatosSpeechCooldown") * 6 / 9 + player.func_70681_au().nextInt(60);
                    }
                } else if (prog[0] == 6) {
                    prog[1] = prog[1] + 1;
                    if (prog[1] == 5) {
                        world.func_72956_a((Entity)player, "portalgun:potatos.dying", 0.15f, 1.0f);
                        this.lastSeenEntity.put(player.func_70005_c_(), (Entity)new EntityPig(player.field_70170_p));
                    } else if (prog[1] >= 90) {
                        MovingObjectPosition mop = EntityHelper.getEntityLook((EntityLivingBase)player, (double)15.0);
                        if (mop != null && mop.field_72308_g != null && mop.field_72308_g instanceof EntityCreeper) {
                            world.func_72956_a((Entity)player, "portalgun:potatos.dying_seecreeper", 0.15f, 1.0f);
                        }
                        prog[0] = 4;
                    }
                } else if (prog[0] == 7) {
                    prog[1] = prog[1] + 1;
                    MovingObjectPosition mop = null;
                    if (prog[1] == 5) {
                        world.func_72956_a((Entity)player, "portalgun:potatos.pic_gosee", 0.15f, 1.0f);
                    } else if (prog[1] == 105) {
                        mop = EntityHelper.getEntityLook((EntityLivingBase)player, (double)10.0);
                        if (mop != null && mop.field_72308_g != null && mop.field_72308_g == this.lastSeenEntity.get(player.func_70005_c_())) {
                            prog[1] = 205;
                        } else {
                            world.func_72956_a((Entity)player, "portalgun:potatos.pic_nowait", 0.15f, 1.0f);
                        }
                    }
                    if (prog[1] == 205) {
                        if (mop == null) {
                            mop = EntityHelper.getEntityLook((EntityLivingBase)player, (double)10.0);
                        }
                        if (mop != null && mop.field_72308_g != null && mop.field_72308_g == this.lastSeenEntity.get(player.func_70005_c_())) {
                            world.func_72956_a((Entity)player, "portalgun:potatos.pic_see", 0.15f, 1.0f);
                        }
                        prog[0] = 4;
                    }
                }
            } else if (prog[0] > 4) {
                prog[0] = 4;
            }
        }
    }

    public void updateGrabbing(World world, EntityLivingBase ent, Entity grabbed) {
        boolean currentItemIsPortalGun = ent instanceof EntityPlayer ? ((EntityPlayer)ent).func_71045_bC() != null && ((EntityPlayer)ent).func_71045_bC().func_77973_b() instanceof ItemPortalGun : ((EntityZombie)ent).func_70694_bm() != null && ((EntityZombie)ent).func_70694_bm().func_77973_b() instanceof ItemPortalGun;
        boolean currentItemIsGraviGun = false;
        try {
            Class<?> clz = Class.forName("gravigun.common.item.ItemGraviGun");
            currentItemIsGraviGun = ent instanceof EntityPlayer ? ((EntityPlayer)ent).func_71045_bC() != null && clz.isInstance(((EntityPlayer)ent).func_71045_bC().func_77973_b()) : ((EntityZombie)ent).func_70694_bm() != null && clz.isInstance(((EntityZombie)ent).func_70694_bm().func_77973_b());
        }
        catch (Exception clz) {
            // empty catch block
        }
        if (currentItemIsGraviGun) {
            GraviGun.proxy.tickHandlerServer.updateGrabbing(world, ent, grabbed);
        } else if (grabbed != null) {
            if (grabbed.field_70128_L || grabbed == ent.field_70154_o || !currentItemIsPortalGun && !(grabbed instanceof EntityCube) && !(grabbed instanceof EntityRadio) || !ent.func_70089_S() || ent.field_71093_bK != grabbed.field_71093_bK) {
                this.setGrabbed(ent, null);
                if (currentItemIsPortalGun) {
                    world.func_72956_a((Entity)ent, "portalgun:object_use_stop_", 0.3f, 1.0f);
                }
            } else {
                double pX = ent.field_70165_t - 3.5 * Math.sin(Math.toRadians(ent.field_70177_z)) * Math.cos(Math.toRadians(ent.field_70125_A));
                double pY = ent.field_70163_u + (double)ent.func_70047_e() - 3.5 * Math.sin(Math.toRadians(ent.field_70125_A));
                double pZ = ent.field_70161_v + 3.5 * Math.cos(Math.toRadians(ent.field_70177_z)) * Math.cos(Math.toRadians(ent.field_70125_A));
                MovingObjectPosition mop = EntityHelper.getEntityLook((EntityLivingBase)ent, (double)3.5, (boolean)true);
                if (mop != null && mop.field_72308_g == null && world.func_147439_a(mop.field_72310_e == 4 ? mop.field_72311_b - 1 : (mop.field_72310_e == 5 ? mop.field_72311_b + 1 : mop.field_72311_b), mop.field_72310_e == 0 ? mop.field_72312_c - 1 : (mop.field_72310_e == 1 ? mop.field_72312_c + 1 : mop.field_72312_c), mop.field_72310_e == 2 ? mop.field_72309_d - 1 : (mop.field_72310_e == 3 ? mop.field_72309_d + 1 : mop.field_72309_d)) == PortalGun.blockPortal) {
                    TileEntityPortalMod tep;
                    TileEntity te = world.func_147438_o(mop.field_72310_e == 4 ? mop.field_72311_b - 1 : (mop.field_72310_e == 5 ? mop.field_72311_b + 1 : mop.field_72311_b), mop.field_72310_e == 0 ? mop.field_72312_c - 1 : (mop.field_72310_e == 1 ? mop.field_72312_c + 1 : mop.field_72312_c), mop.field_72310_e == 2 ? mop.field_72309_d - 1 : (mop.field_72310_e == 3 ? mop.field_72309_d + 1 : mop.field_72309_d));
                    if (te != null && te instanceof TileEntityPortalMod && (tep = (TileEntityPortalMod)te).getLink() != null) {
                        TileEntityPortalMod tep1;
                        TileEntityPortalMod tileEntityPortalMod = tep1 = tep.top ? tep.getLink().tepPair : tep.getLink();
                        if (tep1 != null) {
                            double dist = 3.5 - ent.func_70011_f((double)tep.field_145851_c + tep.getXCenter(), (double)tep.field_145848_d + tep.getYCenter(), (double)tep.field_145849_e + tep.getZCenter());
                            pX = (double)tep1.field_145851_c + 0.5;
                            pY = (double)tep1.field_145848_d + 0.5;
                            pZ = (double)tep1.field_145849_e + 0.5;
                            if (tep1.set == 0) {
                                pY -= dist;
                            } else if (tep1.set == 1) {
                                pY += dist;
                            } else if (tep1.set == 2) {
                                switch (tep1.type) {
                                    case 1: {
                                        pZ += dist;
                                        break;
                                    }
                                    case 2: {
                                        pX -= dist;
                                        break;
                                    }
                                    case 3: {
                                        pZ -= dist;
                                        break;
                                    }
                                    case 4: {
                                        pX += dist;
                                    }
                                }
                            }
                            grabbed.func_70107_b(pX, pY, pZ);
                        }
                    }
                } else if (grabbed.func_70011_f(pX, pY, pZ) > 4.0) {
                    if (grabbed instanceof EntityEnderman && grabbed.func_70011_f(pX, pY, pZ) > 6.0) {
                        this.setGrabbed(ent, null);
                        if (currentItemIsPortalGun) {
                            world.func_72956_a((Entity)ent, "portalgun:object_use_stop_", 0.3f, 1.0f);
                        }
                    } else {
                        grabbed.field_70169_q = ent.field_70165_t;
                        grabbed.field_70167_r = ent.field_70163_u;
                        grabbed.field_70166_s = ent.field_70161_v;
                        grabbed.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                    }
                }
                if (grabbed instanceof EntityFireball) {
                    EntityFireball fireball = (EntityFireball)grabbed;
                    fireball.field_70232_b = 0.0;
                    fireball.field_70233_c = 0.0;
                    fireball.field_70230_d = 0.0;
                }
                this.setVelocity(grabbed, pX - grabbed.field_70165_t, pY - (grabbed.field_70121_D.field_72337_e + grabbed.field_70121_D.field_72338_b) / 2.0, pZ - grabbed.field_70161_v);
                grabbed.field_70143_R = 0.0f;
                grabbed.field_70122_E = false;
                grabbed.field_70160_al = true;
                grabbed.field_71088_bW = 5;
                if (grabbed instanceof EntityTurret) {
                    ((EntityTurret)grabbed).updateRenderYaw(ent.field_70177_z % 360.0f);
                } else if (grabbed instanceof EntityCube) {
                    EntityCube cube = (EntityCube)grabbed;
                    cube.field_70177_z = ent.field_70177_z;
                    cube.field_70125_A = 0.0f;
                    cube.rotationChangeFactor = 0.0f;
                    cube.rotationChangeFactor2 = 0.0f;
                } else if (grabbed instanceof EntityRadio) {
                    grabbed.field_70177_z = ent.field_70177_z - 180.0f;
                } else if (grabbed instanceof EntityFallingBlock) {
                    ((EntityFallingBlock)grabbed).field_145812_b = 2;
                }
            }
        }
    }

    public void setGrabbed(EntityLivingBase living, Entity ent) {
        if (living.field_70170_p instanceof WorldServer) {
            for (Map.Entry<EntityLivingBase, Entity> e : this.grabMap.entrySet()) {
                if (e.getValue() != ent || e.getKey() == living) continue;
                this.setGrabbed(e.getKey(), null);
                break;
            }
            if (ent == null) {
                Entity ent1 = this.grabMap.get(living);
                if (ent1 != null) {
                    ent1.field_71088_bW = 0;
                }
                this.grabMap.remove(living);
            } else {
                this.grabMap.put(living, ent);
            }
            PacketHandler.sendToAll(PortalGun.channels, (AbstractPacket)new PacketGrabEntity(1, new int[]{living.func_145782_y()}, new int[]{ent == null ? -1 : ent.func_145782_y()}));
        }
    }

    public Entity getGrabbed(EntityLivingBase living) {
        return this.grabMap.get(living);
    }

    public int[] getProgression(EntityPlayer player) {
        int[] prog = this.potatosProgression.get(player.func_70005_c_());
        if (prog == null) {
            prog = new int[]{0, 0};
            this.potatosProgression.put(player.func_70005_c_(), prog);
        }
        return prog;
    }

    public boolean getHasFallen(EntityPlayer player) {
        try {
            return this.hasFallen.get(player.func_70005_c_());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public void setVelocity(Entity entity, double d, double d1, double d2) {
        if (entity == null) {
            return;
        }
        entity.field_70159_w = d;
        entity.field_70181_x = d1;
        entity.field_70179_y = d2;
    }

    public void loadData(WorldServer world) {
        try {
            File file = new File(world.getChunkSaveLocation(), "portalgun.dat");
            if (!file.exists()) {
                this.data = new NBTTagCompound();
                PortalGun.console("Save data does not exist!");
                return;
            }
            this.data = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        }
        catch (EOFException e) {
            PortalGun.console("Save data is corrupted! Attempting to read from backup.");
            try {
                File file = new File(world.getChunkSaveLocation(), "portalgun_backup.dat");
                if (!file.exists()) {
                    this.data = new NBTTagCompound();
                    PortalGun.console("No backup detected!");
                    return;
                }
                this.data = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
                File file1 = new File(world.getChunkSaveLocation(), "portalgun.dat");
                file1.delete();
                file.renameTo(file1);
                PortalGun.console("Restoring data from backup.");
            }
            catch (Exception e1) {
                this.data = new NBTTagCompound();
                PortalGun.console("Even your backup data is corrupted. What have you been doing?!", true);
            }
        }
        catch (IOException e) {
            this.data = new NBTTagCompound();
            PortalGun.console("Failed to read save data!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveData(WorldServer world) {
        if (this.data != null) {
            for (Map.Entry<String, int[]> entry : this.potatosProgression.entrySet()) {
                this.data.func_74768_a(entry.getKey() + "_SP", entry.getValue()[0] <= 3 ? entry.getValue()[0] : 4);
            }
            for (Map.Entry<String, Object> entry : this.hasFallen.entrySet()) {
                this.data.func_74757_a(entry.getKey() + "_Fallen", ((Boolean)entry.getValue()).booleanValue());
            }
            for (Map.Entry<String, Object> entry : PortalGun.cHex.entrySet()) {
                String name = entry.getKey();
                if (name.equalsIgnoreCase("def1") || name.equalsIgnoreCase("def2") || name.equalsIgnoreCase("coopA1") || name.equalsIgnoreCase("coopA2") || name.equalsIgnoreCase("coopB1") || name.equalsIgnoreCase("coopB2")) continue;
                this.data.func_74768_a("chex_" + entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
            try {
                if (world.getChunkSaveLocation() == null || !world.getChunkSaveLocation().exists()) return;
                File file = new File(world.getChunkSaveLocation(), "portalgun.dat");
                if (file.exists()) {
                    File file2 = new File(world.getChunkSaveLocation(), "portalgun_backup.dat");
                    if (file2.exists()) {
                        if (file2.delete()) {
                            file.renameTo(file2);
                        } else {
                            PortalGun.console("Failed to delete mod backup data!", true);
                        }
                    } else {
                        file.renameTo(file2);
                    }
                }
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.data, (OutputStream)new FileOutputStream(file));
                return;
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
                throw new RuntimeException("Failed to save portalgun data");
            }
        } else {
            PortalGun.console("Mod data is null! This is a problem!", true);
        }
    }
}

