/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import com.google.common.base.Charsets;
import cpw.mods.fml.common.network.ByteBufUtils;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Validate;

public class MCDataOutputWrapper
implements MCDataOutput {
    public DataOutput dataout;

    public static void writeVarInt(DataOutput to, int i) throws IOException {
        while ((i & 0x80) != 0) {
            to.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        to.writeByte(i);
    }

    public static void writeVarShort(DataOutput to, int s) throws IOException {
        int low = s & Short.MAX_VALUE;
        int high = (s & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        to.writeShort(low);
        if (high != 0) {
            to.writeByte(high);
        }
    }

    public static void writeUTF8String(DataOutput to, String string) throws IOException {
        byte[] utf8Bytes = string.getBytes(Charsets.UTF_8);
        Validate.isTrue((ByteBufUtils.varIntByteCount((int)utf8Bytes.length) < 3 ? 1 : 0) != 0, (String)"The string is too long for this encoding.", (Object[])new Object[0]);
        MCDataOutputWrapper.writeVarInt(to, utf8Bytes.length);
        to.write(utf8Bytes);
    }

    public MCDataOutputWrapper(DataOutput out) {
        this.dataout = out;
    }

    @Override
    public MCDataOutputWrapper writeBoolean(boolean b) {
        try {
            this.dataout.writeBoolean(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeByte(int b) {
        try {
            this.dataout.writeByte(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeShort(int s) {
        try {
            this.dataout.writeShort(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeInt(int i) {
        try {
            this.dataout.writeInt(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeFloat(float f) {
        try {
            this.dataout.writeFloat(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeDouble(double d) {
        try {
            this.dataout.writeDouble(d);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeLong(long l) {
        try {
            this.dataout.writeLong(l);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeChar(char c) {
        try {
            this.dataout.writeChar(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutput writeVarInt(int i) {
        try {
            MCDataOutputWrapper.writeVarInt(this.dataout, i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutput writeVarShort(int s) {
        try {
            MCDataOutputWrapper.writeVarShort(this.dataout, s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeByteArray(byte[] barray) {
        try {
            this.dataout.write(barray);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    @Override
    public MCDataOutputWrapper writeCoord(BlockCoord coord) {
        this.writeInt(coord.x);
        this.writeInt(coord.y);
        this.writeInt(coord.z);
        return this;
    }

    @Override
    public MCDataOutputWrapper writeString(String s) {
        try {
            MCDataOutputWrapper.writeUTF8String(this.dataout, s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeItemStack(ItemStack stack) {
        this.writeItemStack(stack, false);
        return this;
    }

    public MCDataOutputWrapper writeItemStack(ItemStack stack, boolean large) {
        if (stack == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            if (large) {
                this.writeInt(stack.field_77994_a);
            } else {
                this.writeByte(stack.field_77994_a);
            }
            this.writeShort(stack.func_77960_j());
            this.writeNBTTagCompound(stack.field_77990_d);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeNBTTagCompound(NBTTagCompound compound) {
        try {
            if (compound == null) {
                this.writeShort(-1);
            } else {
                byte[] bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)compound);
                this.writeShort((short)bytes.length);
                this.writeByteArray(bytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutputWrapper writeFluidStack(FluidStack fluid) {
        if (fluid == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(fluid.getFluidID());
            this.writeVarInt(fluid.amount);
            this.writeNBTTagCompound(fluid.tag);
        }
        return this;
    }
}

