/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fluids.FluidStack;

class FluidStackSet
implements Set<FluidStack> {
    List<FluidStack> itemStacks = new ArrayList<FluidStack>();

    FluidStackSet() {
    }

    public String toString() {
        return this.itemStacks.toString();
    }

    protected FluidStack getExisting(FluidStack stack) {
        for (FluidStack stack2 : this.itemStacks) {
            if (!stack2.isFluidEqual(stack)) continue;
            return stack2;
        }
        return null;
    }

    @Override
    public boolean add(FluidStack e) {
        if (e != null) {
            if (this.getExisting(e) == null) {
                return this.itemStacks.add(e.copy());
            }
            this.getExisting((FluidStack)e).amount += e.amount;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends FluidStack> c) {
        boolean addedAll = true;
        for (FluidStack fluidStack : c) {
            addedAll = this.add(fluidStack) && addedAll;
        }
        return addedAll;
    }

    @Override
    public void clear() {
        this.itemStacks.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof FluidStack)) {
            return false;
        }
        return this.getExisting((FluidStack)o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean addedAll = true;
        for (Object o : c) {
            addedAll = addedAll && this.contains(o);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.itemStacks.isEmpty();
    }

    @Override
    public Iterator<FluidStack> iterator() {
        return this.itemStacks.iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.contains(o)) {
            FluidStack r = (FluidStack)o;
            FluidStack existing = this.getExisting(r);
            if (existing.amount > r.amount) {
                existing.amount -= r.amount;
            } else {
                this.itemStacks.remove(existing);
            }
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean addedAll = true;
        for (Object o : c) {
            boolean removed = this.remove(o);
            addedAll = removed && addedAll;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.itemStacks.retainAll(c);
    }

    @Override
    public int size() {
        return this.itemStacks.size();
    }

    @Override
    public Object[] toArray() {
        return this.itemStacks.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.itemStacks.toArray(a);
    }
}

