/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.Mods;
import binnie.extrabees.ExtraBees;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public enum ExtraBeesFlowers implements IFlowerProvider,
IAlleleFlowers
{
    WATER,
    SUGAR,
    ROCK,
    BOOK,
    DEAD,
    REDSTONE,
    WOOD,
    LEAVES,
    Sapling,
    Fruit,
    Mystical;

    boolean dominant = true;

    public String getUID() {
        return "extrabees.flower." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public IFlowerProvider getProvider() {
        return this;
    }

    public String getDescription() {
        return ExtraBees.proxy.localise("flowers." + this.name().toString().toLowerCase() + ".name");
    }

    public void register() {
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
    }

    public static void doInit() {
        for (ExtraBeesFlowers effect : ExtraBeesFlowers.values()) {
            effect.register();
        }
    }

    public ItemStack[] getItemStacks() {
        switch (this) {
            case WATER: {
                return new ItemStack[]{new ItemStack(Blocks.field_150392_bi)};
            }
            case SUGAR: {
                return new ItemStack[]{new ItemStack(Blocks.field_150436_aH)};
            }
            case ROCK: {
                return new ItemStack[]{new ItemStack(Blocks.field_150347_e)};
            }
            case BOOK: {
                return new ItemStack[]{new ItemStack(Blocks.field_150342_X)};
            }
            case REDSTONE: {
                return new ItemStack[]{new ItemStack(Blocks.field_150429_aA)};
            }
            case DEAD: {
                return new ItemStack[]{new ItemStack((Block)Blocks.field_150330_I)};
            }
            case Fruit: {
                return new ItemStack[]{new ItemStack(Items.field_151034_e)};
            }
            case LEAVES: {
                return new ItemStack[]{new ItemStack((Block)Blocks.field_150362_t)};
            }
            case Sapling: {
                return new ItemStack[]{new ItemStack(Blocks.field_150345_g)};
            }
            case WOOD: {
                return new ItemStack[]{new ItemStack(Blocks.field_150364_r)};
            }
        }
        return new ItemStack[0];
    }

    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        switch (this) {
            case WATER: {
                return block == Blocks.field_150392_bi;
            }
            case ROCK: {
                return block.func_149688_o() == Material.field_151576_e;
            }
            case SUGAR: {
                return block == Blocks.field_150436_aH;
            }
            case BOOK: {
                return block == Blocks.field_150342_X;
            }
            case REDSTONE: {
                return block == Blocks.field_150429_aA;
            }
            case DEAD: {
                return block == Blocks.field_150330_I;
            }
            case WOOD: {
                return block.isWood((IBlockAccess)world, x, y, z);
            }
            case Fruit: {
                return world.func_147438_o(x, y, z) instanceof IFruitBearer;
            }
            case LEAVES: {
                return block.isLeaves((IBlockAccess)world, x, y, z);
            }
            case Sapling: {
                return block.getClass().getName().toLowerCase().contains("sapling");
            }
            case Mystical: {
                return block == Mods.Botania.block("flower");
            }
        }
        return false;
    }

    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        switch (this) {
            case WATER: {
                if (world.func_147437_c(x, y, z) && world.func_147439_a(x, y - 1, z) == Blocks.field_150355_j) {
                    return world.func_147465_d(x, y, z, Blocks.field_150392_bi, 0, 2);
                }
                return false;
            }
            case SUGAR: {
                if (world.func_147439_a(x, y - 1, z) == Blocks.field_150436_aH && world.func_147437_c(x, y, z)) {
                    return world.func_147465_d(x, y, z, Blocks.field_150436_aH, 0, 0);
                }
                return false;
            }
        }
        return false;
    }

    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        if (this == Mystical) {
            ArrayList<ItemStack> prods = new ArrayList<ItemStack>();
            for (ItemStack stack : products) {
                prods.add(stack);
            }
            for (int k = 0; k < 50; ++k) {
                int z2;
                int y2;
                int tX = 7;
                int tY = 7;
                int tZ = 3;
                int x2 = x - tX + world.field_73012_v.nextInt(1 + 2 * tX);
                Block block = world.func_147439_a(x2, y2 = y - tY + world.field_73012_v.nextInt(1 + 2 * tY), z2 = z - tZ + world.field_73012_v.nextInt(1 + 2 * tZ));
                if (block == null || block != Mods.Botania.block("flower")) continue;
                int meta = world.func_72805_g(x2, y2, z2);
                Item item = Mods.Botania.item("petal");
                if (item == null) continue;
                prods.add(new ItemStack(item, 1, meta));
            }
            return prods.toArray(new ItemStack[0]);
        }
        return products;
    }

    public String getName() {
        return this.getDescription();
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }

    public List<IFlower> getFlowers() {
        return new ArrayList<IFlower>();
    }
}

