/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.block.ILogType;
import binnie.extratrees.gen.WorldGenTree;
import binnie.extratrees.worldgen.BlockTypeLog;
import forestry.api.arboriculture.ITree;

public class WorldGenEucalyptus {

    public static class RainbowGum
    extends WorldGenTree {
        public RainbowGum(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(0.5f, 0.6f) * (float)this.height;
            float width = (float)this.height * this.randBetween(0.15f, 0.2f);
            if (width < 1.5f) {
                width = 1.5f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.7f * width, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), width, 1, this.leaf, false);
                float f4 = leafSpawn;
                leafSpawn = f4 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), width - 0.5f, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(7, 3);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class RoseGum
    extends WorldGenTree {
        public RoseGum(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            int offset = (this.girth - 1) / 2;
            for (int x = 0; x < this.girth; ++x) {
                for (int y = 0; y < this.girth; ++y) {
                    for (int i = 0; i < 2; ++i) {
                        this.addBlock(x - offset, i, y - offset, new BlockTypeLog(ILogType.ExtraTreeLog.Eucalyptus2), true);
                    }
                }
            }
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(0.4f, 0.5f) * (float)this.height;
            float width = (float)this.height * this.randBetween(0.05f, 0.1f);
            if (width < 1.5f) {
                width = 1.5f;
            }
            this.bushiness = 0.5f;
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.7f * width, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                this.bushiness = 0.1f;
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), this.randBetween(0.9f, 1.1f) * width, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(9, 3);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class SwampGum
    extends WorldGenTree {
        public SwampGum(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float weakerBottm = this.randBetween(0.5f, 0.6f) * (float)this.height;
            float bottom = this.randBetween(0.4f, 0.5f) * (float)this.height;
            float width = (float)this.height * this.randBetween(0.15f, 0.2f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.bushiness = 0.3f;
            while (leafSpawn > weakerBottm) {
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), this.randBetween(0.9f, 1.0f) * width, 1, this.leaf, false);
            }
            this.bushiness = 0.6f;
            while (leafSpawn > bottom) {
                float f4 = leafSpawn;
                leafSpawn = f4 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), this.randBetween(0.8f, 0.9f) * width, 1, this.leaf, false);
            }
            float f5 = leafSpawn;
            leafSpawn = f5 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f5, 0.0f), 0.5f * width, 1, this.leaf, false);
            for (int i = 0; i < 5; ++i) {
                float f6 = leafSpawn;
                leafSpawn = f6 - 1.0f;
                this.generateSphere(new WorldGenTree.Vector(this.randBetween(-1, 1), f6, this.randBetween(-1, 1)), this.randBetween(1, 2), this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(14, 3);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }
}

