/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.genetics.gui.ControlAnalystPage;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflyEffect;
import forestry.api.lepidopterology.IButterfly;
import forestry.plugins.PluginApiculture;

public class AnalystPageBehaviour
extends ControlAnalystPage {
    public AnalystPageBehaviour(IWidget parent, IArea area, IIndividual ind) {
        super(parent, area);
        IBee bee;
        this.setColour(0x660033);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, "\u00a7nBehaviour").setColour(this.getColour());
        y += 12;
        if (ind instanceof IBee) {
            bee = (IBee)ind;
            int fertility = bee.getGenome().getFlowering();
            new ControlTextCentered((IWidget)this, y += 8, "Pollinates nearby\n" + bee.getGenome().getFlowerProvider().getDescription()).setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 20, "\u00a7oEvery " + this.getTimeString((float)PluginApiculture.ticksPerBeeWorkCycle * 100.0f / (float)fertility)).setColour(this.getColour());
            y += 22;
            IAlleleBeeEffect effect = bee.getGenome().getEffect();
            int[] t = bee.getGenome().getTerritory();
            if (!effect.getUID().contains("None")) {
                String effectDesc = BinnieCore.proxy.localiseOrBlank("allele." + effect.getUID() + ".desc");
                String loc = effectDesc.equals("") ? "Effect: " + effect.getName() : effectDesc;
                new ControlText(this, new IArea(4.0f, y, this.w() - 8.0f, 0.0f), loc, TextJustification.TopCenter).setColour(this.getColour());
                y = (int)((float)y + (CraftGUI.Render.textHeight(loc, this.w() - 8.0f) + 1.0f));
                new ControlTextCentered((IWidget)this, y, "\u00a7oWithin " + (int)((float)t[0] / 2.0f) + " blocks").setColour(this.getColour());
                y += 22;
            }
            new ControlTextCentered((IWidget)this, y, "Territory: \u00a7o" + t[0] + "x" + t[1] + "x" + t[2]).setColour(this.getColour());
            y += 22;
        }
        if (ind instanceof IButterfly) {
            bee = (IButterfly)ind;
            new ControlTextCentered((IWidget)this, y, "\u00a7oMetabolism: " + Binnie.Genetics.mothBreedingSystem.getAlleleName((IChromosomeType)EnumButterflyChromosome.METABOLISM, ind.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.METABOLISM))).setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 20, "Pollinates nearby\n" + bee.getGenome().getFlowerProvider().getDescription()).setColour(this.getColour());
            new ControlTextCentered((IWidget)this, y += 20, "\u00a7oEvery " + this.getTimeString(1500.0f)).setColour(this.getColour());
            y += 22;
            IAlleleButterflyEffect effect = bee.getGenome().getEffect();
            if (!effect.getUID().contains("None")) {
                String effectDesc = BinnieCore.proxy.localiseOrBlank("allele." + effect.getUID() + ".desc");
                String loc = effectDesc.equals("") ? "Effect: " + effect.getName() : effectDesc;
                new ControlText(this, new IArea(4.0f, y, this.w() - 8.0f, 0.0f), loc, TextJustification.TopCenter).setColour(this.getColour());
                y = (int)((float)y + (CraftGUI.Render.textHeight(loc, this.w() - 8.0f) + 1.0f));
                y += 22;
            }
        }
    }

    @Override
    public String getTitle() {
        return "Behaviour";
    }
}

